/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.CustFunct;
import bigpete.EnemyRobot;
import bigpete.EnemyRobotList;
import bigpete.PointPolar;
import bigpete.Stewie;
import bigpete.VirtualBullet;
import bigpete.VirtualBulletList;
import java.awt.geom.Point2D;

public class Movement {
    final double Pi = Math.PI;
    final double Pi2 = Math.PI * 2;
    final double enemy_weighting = -3.0;
    final double wall_weighting = -400.0;
    final double cent_weighting = -600.0;
    final double corner_weighting = -1.0;
    final double enemy_perp_weighting = 600.0;
    EnemyRobotList target_list = null;
    VirtualBulletList bullet_list = null;
    Stewie robot;
    double width = 1000.0;
    double height = 1000.0;

    Movement(Stewie robot_in, EnemyRobotList targets, VirtualBulletList bullets) {
        this.target_list = targets;
        this.bullet_list = bullets;
        this.robot = robot_in;
        this.height = this.robot.getBattleFieldHeight();
        this.width = this.robot.getBattleFieldWidth();
    }

    public void move() {
        PointPolar direction = this.bestDirection(this.robot.currentPosition());
        this.robot.turnTo(direction.getAngle());
        this.robot.setAhead(100.0);
    }

    private PointPolar bestDirection(Point2D robot_position) {
        Point2D grav = this.getGravityValues(robot_position);
        PointPolar prefered_direction = new PointPolar();
        prefered_direction.vectorToPolar(grav);
        Point2D perp = this.getTargetPerpValues(robot_position, prefered_direction.getAngle());
        Point2D bull = this.getBulletForce(robot_position);
        PointPolar tmp = new PointPolar();
        tmp.vectorToPolar(grav.getX() + perp.getX() + bull.getX(), grav.getY() + perp.getY() + bull.getY());
        return tmp;
    }

    private Point2D getBulletForce(Point2D current_position) {
        if (this.target_list.getNumber() == 0) {
            return new Point2D.Double(0.0, 0.0);
        }
        double bullet_weighting = -20 / this.target_list.getNumber();
        double robot_width = 36.0;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < this.bullet_list.getNumber(); ++i) {
            VirtualBullet tmp = this.bullet_list.getBullet(i);
            if (tmp.gonePast(current_position)) {
                this.bullet_list.remove(i);
                continue;
            }
            if (!(tmp.getDistance(current_position) < 400.0)) continue;
            x += bullet_weighting / Math.pow(Math.abs(Math.max(tmp.getDistance(current_position) - 36.0, 10.0)), 2.0) * Math.sin(tmp.getBearingToPath(current_position));
            y += bullet_weighting / Math.pow(Math.abs(Math.max(tmp.getDistance(current_position) - 36.0, 10.0)), 2.0) * Math.cos(tmp.getBearingToPath(current_position));
        }
        return new Point2D.Double(x, y);
    }

    private Point2D getTargetPerpValues(Point2D robot_position, double prefered_direction) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < this.target_list.getNumber(); ++i) {
            EnemyRobot tmp = this.target_list.getRobot(i);
            double target_bearing = CustFunct.normaliseAbsolute(tmp.getRelativeBearing());
            double bearing = Math.abs(CustFunct.normaliseRelative(target_bearing - 1.5707963267948966 - (prefered_direction = CustFunct.normaliseAbsolute(prefered_direction)))) < Math.abs(CustFunct.normaliseRelative(target_bearing + 1.5707963267948966 - prefered_direction)) ? CustFunct.normaliseAbsolute(target_bearing - 1.5707963267948966) : CustFunct.normaliseAbsolute(target_bearing + 1.5707963267948966);
            x += 600.0 / Math.pow(Math.abs(tmp.getDistance() + 1.0), 2.0) * Math.sin(bearing);
            y += 600.0 / Math.pow(Math.abs(tmp.getDistance() + 1.0), 2.0) * Math.cos(bearing);
        }
        return new Point2D.Double(x, y);
    }

    private Point2D getGravityValues(Point2D robot_position) {
        double pos_x = robot_position.getX();
        double pos_y = robot_position.getY();
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < this.target_list.getNumber(); ++i) {
            EnemyRobot tmp = this.target_list.getRobot(i);
            double tmp_weighting = -3.0 * Math.max(20.0, tmp.getEnergy());
            x += tmp_weighting / Math.pow(Math.abs(tmp.getDistance() + 1.0), 2.0) * Math.sin(tmp.getRelativeBearing());
            y += tmp_weighting / Math.pow(Math.abs(tmp.getDistance() + 1.0), 2.0) * Math.cos(tmp.getRelativeBearing());
        }
        x -= 1.0 / Math.pow(pos_x, 2.0) * -400.0;
        x += 1.0 / Math.pow(this.width - pos_x, 2.0) * -400.0;
        y -= 1.0 / Math.pow(pos_y, 2.0) * -400.0;
        y += 1.0 / Math.pow(this.height - pos_y, 2.0) * -400.0;
        Point2D tmp = this.force(robot_position, new Point2D.Double(this.width / 2.0, this.height / 2.0), -600.0);
        x += tmp.getX();
        y += tmp.getY();
        int u = 0;
        while ((double)u <= this.width) {
            int v = 0;
            while ((double)v <= this.height) {
                tmp = this.force(robot_position, new Point2D.Double(u, v), -1.0);
                x += tmp.getX();
                y += tmp.getY();
                v = (int)((double)v + this.height);
            }
            u = (int)((double)u + this.width);
        }
        return new Point2D.Double(x, y);
    }

    private Point2D force(Point2D robot_position, Point2D object_position, double weighting) {
        double diff_x = object_position.getX() - robot_position.getX();
        double diff_y = object_position.getY() - robot_position.getY();
        double distance = Math.sqrt(Math.pow(diff_x, 2.0) + Math.pow(diff_y, 2.0));
        double force_angle = Math.atan(diff_y / diff_x);
        double x_tmp = weighting / Math.pow(distance + 1.0, 2.0) * Math.abs(Math.sin(force_angle));
        double y_tmp = weighting / Math.pow(distance + 1.0, 2.0) * Math.abs(Math.cos(force_angle));
        if (diff_x < 0.0) {
            x_tmp = -x_tmp;
        }
        if (diff_y < 0.0) {
            y_tmp = -y_tmp;
        }
        return new Point2D.Double(x_tmp, y_tmp);
    }
}

