/*
 * Decompiled with CFR 0.152.
 */
package kano.gamma;

import kano.gamma.KanoGamma;

public class MoveMgr {
    KanoGamma bot;
    long time = 1L;
    int direction = 1;
    int oneOnOneIter = 0;
    double maxX = 0.0;
    double maxY = 0.0;

    public MoveMgr(KanoGamma bot) {
        this.bot = bot;
        this.maxX = bot.getBattleFieldWidth();
        this.maxY = bot.getBattleFieldHeight();
    }

    public void normalMove() {
        long time2 = this.bot.getTime();
        if (this.bot.isNearWalls()) {
            this.time = time2 + 10L;
            this.bot.goTo(this.maxX / 2.0, this.maxY / 2.0);
            return;
        }
        if (time2 >= this.time) {
            this.direction *= -1;
            this.bot.setAhead(this.direction * 3000);
            this.time = time2 + 20L;
        }
        this.bot.setTurnRightRadians(this.bot.enemyMgr.currentTarget.bearing + Math.random() * Math.PI);
    }

    public void oneOnOneMove() {
        long time2 = this.bot.getTime();
        if (this.bot.isNearWalls()) {
            this.time = time2 + 10L;
            this.bot.goTo(this.maxX / 2.0, this.maxY / 2.0);
            return;
        }
        if (time2 >= this.time) {
            this.direction *= -1;
            this.bot.setAhead(this.direction * 3000);
            long moreTime = (long)(Math.random() * 20.0 + 10.0);
            if (this.oneOnOneIter > 5) {
                moreTime += 20L;
                this.oneOnOneIter = 0;
            } else {
                ++this.oneOnOneIter;
            }
            this.time = time2 + moreTime;
        }
        this.bot.setTurnRightRadians(this.bot.enemyMgr.currentTarget.bearing + Math.random() * Math.PI);
    }

    public void manualMove(double x, double y) {
        long time2 = this.bot.getTime();
        if (this.bot.isNearWalls()) {
            this.time = time2 + 10L;
            this.bot.goTo(this.maxX / 2.0, this.maxY / 2.0);
            return;
        }
        if (time2 >= this.time) {
            this.time = time2 + 10L;
            this.bot.goTo(x, y);
        }
    }
}

