/*
 * Decompiled with CFR 0.152.
 */
package rdt199.movement;

import rdt199.Manager;
import rdt199.util.BotFuncs;
import rdt199.util.Location;

public class MovementManager
extends Manager {
    protected Location m_Target;

    public MovementManager(int maxmodes) {
        super(maxmodes);
    }

    public void update() {
        this.chooseMode();
        if (this.m_Current != null) {
            this.m_Current.update();
            this.move();
        }
    }

    private void move() {
        if (this.m_Target == null) {
            return;
        }
        this.moveToXY(this.m_Target);
    }

    public void setTarget(Location loc) {
        this.m_Target = loc;
    }

    private void moveToXY(Location loc) {
        Location Loc = new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        double dTheta = BotFuncs.normaliseAbsRadians(BotFuncs.getAbsBearing(loc, Loc));
        dTheta = Math.toDegrees(dTheta);
        dTheta = BotFuncs.normaliseAbsDegrees(dTheta);
        boolean bForwards = this.setAbsoluteHeadingDegrees(dTheta);
        double flDistance = BotFuncs.getDistanceBetween(Loc, loc);
        if (bForwards) {
            BotFuncs.m_AdvancedRobot.setAhead(flDistance);
        } else {
            BotFuncs.m_AdvancedRobot.setBack(flDistance);
        }
    }

    public boolean setAbsoluteHeadingDegrees(double degrees) {
        double dRelativeAngle = BotFuncs.m_AdvancedRobot.getHeading() - degrees;
        if ((dRelativeAngle = BotFuncs.normaliseRelDegrees(dRelativeAngle)) == 0.0) {
            return true;
        }
        if (dRelativeAngle == 180.0 || dRelativeAngle == -180.0) {
            return false;
        }
        if (dRelativeAngle >= -90.0 && dRelativeAngle <= 90.0) {
            BotFuncs.m_AdvancedRobot.setTurnLeft(dRelativeAngle);
            return true;
        }
        BotFuncs.m_AdvancedRobot.setTurnLeft(BotFuncs.normaliseRelDegrees(dRelativeAngle - 180.0));
        return false;
    }
}

