package ph.intelligence;
import ph.*;
import robocode.*;
import java.awt.geom.*;

public class VirtualBullet {
    
    protected double power;
    protected long launchTime;
    protected double launchX;
    protected double launchY;
    protected double heading;
    
    /** Creates a new instance of EnemyBullet */
    public VirtualBullet(long launchTime, double power, double x, double y, double heading) {
        this.launchTime=launchTime;
        this.power=power;
        launchX=x;
        launchY=y;
        this.heading=heading;
    }
    
    public double speed() {
        return 20-(3*power);
    }
    
    public Point2D position(long when) {
        double x = launchX + (when-launchTime)*(speed() * Math.sin(Math.toRadians(heading)));
        double y = launchY + (when-launchTime)*(speed() * Math.cos(Math.toRadians(heading)));
        return new Point2D.Double(x,y);
    }
    
    public double launchX() {return launchX;}
    public double launchY() {return launchY;}
    public Point2D launchPos() {return new Point2D.Double(launchX,launchY);}
    public long launchTime() {return launchTime;}
    public double power(){return power;}
    public double heading(){return heading;}
    
    public long predictedTimeToImpact(double robotX, double robotY, long curTime) {
        Point2D bulletPos=position(curTime);
        double bulletX=bulletPos.getX();
        double bulletY=bulletPos.getY();
        double bearing=utils.getBearing(bulletX,bulletY,robotX,robotY);
        double absAngleDiff=Math.abs(utils.normalRelativeAngle(heading-bearing));
        if(absAngleDiff>=90) return Long.MAX_VALUE;
        return (long)(utils.dist(bulletX,bulletY,robotX,robotY) / Math.cos(absAngleDiff) / speed());
    }
    
    public Point2D predictedPointOfImpact(double robotX, double robotY, 
    long curTime) {
        return position(curTime+predictedTimeToImpact(robotX,robotY,curTime));
    }
    
}
