package urdos;
import robocode.*;
import java.awt.geom.*;
import java.awt.*;
import java.util.*;

/**
 * Uber Robotic Disk Operating System
 # a robot by members from: THE ELECRONIC COMMUNCIATIONS AND COMPUTER CLUB #
 */
public class URDOS extends AdvancedRobot
{
	/* CONSTANTS */
	private static int GF_BINS = 30;
	private static int WS_BINS = 30;
	private static int GF_SEGMENTS_DIST = 25;
	private static int MAX_ENEMIES = 30;
	private static int NO_OF_GUNS = 4;
	private static int SW = 160;
	private static int AG_RANDOM_POINTS = 5;
	private static double AG_CORNER_DIST = 20.0;

	/* SWITCHES - DEBUG */
	private static boolean DEBUG_GN = false;
	private static boolean DEBUG_AG = true;
	private static boolean DEBUG_WS = false;
	private static boolean DEBUG_GF = false;
	private static boolean DEBUG_GF_AS = false;
	private static boolean DEBUG_VG = false;

	/* SWITCHES - ETC. */
	private static boolean TARGETING = true;
	private static boolean TARGETING_FIRE = true;
	private static boolean MOVEMENT = true;
	private static boolean MOVEMENT_WS = true;
	private static boolean MOVEMENT_AG = true;

	/* DEBUG */
	private static int[] DEBUG_RECORDS;

	/* ENEMY ROBOT(S) DATA */
	private EnemyRobot target = null;
	private EnemyRobot target_last = null;
	private EnemyRobot[] enemies = new EnemyRobot[MAX_ENEMIES];

	/* DATA STORED FROM getXX() METHODS */
	private double bw_height;
	private double bw_width;
	private double gun_cooling_rate;

	private double radarturn = 0;
	private static Rectangle2D.Double rf = new Rectangle2D.Double(19, 19, 763, 563);

	/* MOVEMENT */
	private boolean movement_surf_backup = true;

	/* ANTI-GRAVITY */
	private ArrayList AGPoints = new ArrayList();

	/* WAVE-SURFING */
	private static double[][] surf_statistics = new double[MAX_ENEMIES][WS_BINS];
	private ArrayList sea_waves = new ArrayList();	
	private ArrayList sea_bear = new ArrayList();
	private ArrayList sea_d = new ArrayList();

	/* VIRTUALGUNS */
	private Gun[] Guns = new Gun[NO_OF_GUNS];
	private static int[][] vg_statistics = new int[MAX_ENEMIES][NO_OF_GUNS]; //[enemies][guns]
	private ArrayList virtualbullets = new ArrayList();

	/* GUESS-FACTOR (NORMAL) */
	private static double[][][] gf_statistics = new double[MAX_ENEMIES][GF_SEGMENTS_DIST][GF_BINS]; //[enemies][segment][gf]
	private ArrayList gf_waves = new ArrayList();

	/* GUESS-FACTOR (ANTI-SURFER) */
	private static double HISTORY_DEPTH = 0;
	private static double[][][] gf_ra_statistics = new double[MAX_ENEMIES][GF_SEGMENTS_DIST][GF_BINS]; //[enemies][segment][gf]
	private ArrayList gf_ra_waves = new ArrayList();

	public void run() {
		Guns[0] = new Gun("Head-On", Color.red);
		Guns[1] = new Gun("Linear", Color.green);
		Guns[2] = new Gun("Guess-Factor (Normal)", Color.blue);
		Guns[3] = new Gun("Guess-Factor (Anti-Surfer)", Color.cyan);

		setColors(new Color(0x464D6A),new Color(0x464D6A),new Color(0x464D6A));
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);

		bw_height = getBattleFieldHeight();
		bw_width = getBattleFieldWidth();
		gun_cooling_rate = getGunCoolingRate();

		if(DEBUG_RECORDS == null)
			DEBUG_RECORDS = new int[getOthers()+1];

		while(true) {
			setTurnRadarRightRadians(radarturn);
			/* ANTI-GRAVITY IMPLEMENTATION */
			if(MOVEMENT_AG && (getOthers() > 1 || movement_surf_backup)) {
				double fx,fy,v,of;
				fx = fy = 0;
				//EnemyPoints
				for(int i=0;i<MAX_ENEMIES&&enemies[i]!=null;i++) {
					v = enemies[i].energy/(Math.pow(getX()-enemies[i].x,2)+Math.pow(getY()-enemies[i].y,2));
					db("V: "+v,DEBUG_AG);
					AGPoints.add(new AGPoint(enemies[i].x,enemies[i].y,v));
				}
				//FixedPoints
				AGPoints.add(new AGPoint(bw_width/2,bw_height/2,(Math.random()*200)/(Math.pow(bw_width-getX(),2)+Math.pow(bw_height-getY(),3))));
				AGPoints.add(new AGPoint(AG_CORNER_DIST,AG_CORNER_DIST,-0.05));
				AGPoints.add(new AGPoint(AG_CORNER_DIST,bw_height-AG_CORNER_DIST,-0.05));
				AGPoints.add(new AGPoint(bw_width-AG_CORNER_DIST,AG_CORNER_DIST,-0.05));
				AGPoints.add(new AGPoint(bw_width-AG_CORNER_DIST,bw_height-AG_CORNER_DIST,-0.05));
				//RandomPoints
				for(int i=0;i<AG_RANDOM_POINTS;i++) {
					AGPoints.add(new AGPoint(Math.random()*bw_width,Math.random()*bw_height,0.0005));
				}
				//WindPoints
				fx += 20000/Math.pow(getX()-bw_width,3);
				fy += 20000/Math.pow(getY()-bw_height,3);
				fx += 20000/Math.pow(getX(),3);
				fy += 20000/Math.pow(getY(),3);

				for(int i=0;i<AGPoints.size();i++) {
					AGPoint curr_point = (AGPoint)AGPoints.get(i);
					of = Math.atan2(curr_point.x-getX(),curr_point.y-getY());
					fx -= Math.sin(of) * curr_point.force;
					fy -= Math.cos(of) * curr_point.force;
				}
				fx *= 10000;
				fy *= 10000;
				db("FX: "+fx+"|FY:"+fy,DEBUG_AG);
				db("AA:"+r2d(Math.atan2(fx,fy)),DEBUG_AG);
				setTurnRightRadians(normalRelativeAngle(Math.atan2(fx,fy)-getHeadingRadians()));
				setAhead(Math.sqrt(fx*fx+fy*fy));
				AGPoints = new ArrayList();
			}
			//cleanup for next round
			radarturn = Double.POSITIVE_INFINITY;
			//end cleanup
			execute();
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		EnemyRobot Enemy = new EnemyRobot(e);
		double bradar, enemy_x, enemy_y, bullet_power, bullet_speed;
		bradar = Enemy.absbearing - getRadarHeadingRadians(); //bearing relative to radar turn
		checkEnemy(Enemy);

		if(target == null ||
			(!target.name.equals(Enemy.name) &&
//				Enemy.energy <= target.energy - 10 &&
//				Enemy.distance <= target.distance)
				target.distance/Math.min(bw_width,bw_height) * target.energy/100 >
				Enemy.distance/Math.min(bw_width,bw_height) * Enemy.energy/100)
		) {
			target = target_last = Enemy;
			db("Acquired Target ... " + target.name, DEBUG_GN);
		}

		if(target.name.equals(Enemy.name)) {
			target_last = target;
			target = Enemy; //update data
		}

		/* WAVESURFING */
		if(getOthers() == 1 && MOVEMENT_WS) {
			EnemyWave curr_wave;
			double dl,dr,da;
			sea_bear.add(0,new Double(Math.PI + Enemy.absbearing));
			sea_d.add(0,new Integer(Enemy.rel_direction));
			double EnergyDrop = target_last.energy - target.energy;
			if(EnergyDrop <= 3.0 && EnergyDrop >= 0.1) {
				if(2 < sea_d.size()) {
					EnemyWave new_wave = new EnemyWave(target.x, target.y, target.absbearing + Math.PI, EnergyDrop, target.rel_direction);
					sea_waves.add(new_wave);
				}
			}

			for(int i=0;i<sea_waves.size();i++) {
				EnemyWave ee = (EnemyWave)sea_waves.get(i);
				if(ee.check()) {
					sea_waves.remove(ee);
					i--;
				}
			}

			//find a wave to surf
			curr_wave = select_nwave();

			//dump data
			String asd = "";
			for(int i=0;i<WS_BINS;i++) {
				asd += (int)(surf_statistics[getEnemy()][i]) + ",";
			}
			db("WS_STAT: "+asd, DEBUG_WS);

			if(curr_wave != null) {
				dl = getDanger(curr_wave,-1);
				dr = getDanger(curr_wave,1);
				db("DL: "+dl+" | DR: "+dr,DEBUG_WS);
				da = Math.atan2(getX()-curr_wave.orig_x,getY()-curr_wave.orig_y);
				da = dl < dr ? swm(getX(),getY(),da-(Math.PI/2), -1) : swm(getX(),getY(),da+(Math.PI/2),1);
				da = normalRelativeAngle(da - getHeadingRadians());
				db("DA: "+r2d(da),DEBUG_WS);
				if(Math.abs(da)>(Math.PI/2)){
					if(da<0) setTurnRightRadians(Math.PI+da);
					else setTurnLeftRadians(Math.PI-da);
					setBack(100);
				}
				else {
					if(da<0) setTurnLeftRadians(da*-1);
					else setTurnRightRadians(da);
					setAhead(100);
				}
			}
			movement_surf_backup = curr_wave != null && dist(getX(),getY(),target.x,target.y) < 200;
		}

		if(target.name.equals(Enemy.name) && TARGETING) {
			/* RADAR LOCK */
			if((getGunHeat()/gun_cooling_rate) < 6 || getOthers() == 1) { //let it swing around and look if it isn't about to fire
				radarturn = normalRelativeAngle(bradar);
				radarturn *= 2.05;
			}

			if(getOthers() == 1 && target.energy == 0) { //if disabled and alone, RAM! :D
				setTurnRightRadians(target.absbearing-getHeadingRadians());
				if(target.bearing == 0)
					setAhead(target.distance+1);
			}

			/* FIREPOWER MANAGEMENT */
			bullet_power = getOthers() * Math.max(2.0,0.1 * (getEnergy() - target.energy));
			bullet_power = target.energy/getEnergy() > 2.0 ? 0.1 : bullet_power;
			bullet_power = Math.min(bullet_power, target.energy / 4 );
			bullet_power = target.distance < 80 ? 3.0 : bullet_power;
			bullet_power = Math.min(getEnergy()-0.1, bullet_power);
			bullet_power = Math.min(3, Math.max(0.1, bullet_power));
			bullet_speed = 20.0 - (3.0 * bullet_power);

			/* VIRTUAL GUNS */
			double fire_angle[] = new double[NO_OF_GUNS];
			fire_angle[0] = normalRelativeAngle(Enemy.absbearing - getGunHeadingRadians());
			fire_angle[1] = target_linear(bullet_power);
			fire_angle[2] = target_gf_normal(bullet_power);
			fire_angle[3] = target_gf_ra(bullet_power);
			int best_vg = 3;
			for(int i=0;i<NO_OF_GUNS;i++) {
				if(vg_statistics[getEnemy()][i] > vg_statistics[getEnemy()][best_vg]) best_vg = i;
			}

			for(int i=0;i<NO_OF_GUNS;i++) {
				db(Guns[i].name + ": " + vg_statistics[getEnemy()][i], DEBUG_VG);
			}

			//process virtualbullets
			for(int i=0;i<virtualbullets.size();i++) {
				VirtualBullet currb = (VirtualBullet)virtualbullets.get(i);
				if(currb.check()) {
					virtualbullets.remove(currb);
					i--;
				}
			}

			double chosen_angle = fire_angle[best_vg];
			setTurnGunRightRadians(chosen_angle);
			if(getGunHeat() == 0.0 &&
				Math.abs(chosen_angle) < d2r(30) &&
				getEnergy() > bullet_power &&
				(getOthers() != 1 || target.energy != 0.0)
			) {
				if(TARGETING_FIRE) setFire(bullet_power);
				VirtualBullet tb;
				for(int i=0;i<NO_OF_GUNS;i++) {
					tb = new VirtualBullet(getX(), getY(), fire_angle[i], bullet_power, i);
					virtualbullets.add(tb);
				}
			}
		}
	}

	private double target_linear(double bullet_power) {
		double our_x = getX(), our_y = getY();
		double est_x = target.x, est_y = target.y;
		for(double delta_time=1;delta_time * (20 - 3 * bullet_power) < dist(our_x,our_y,est_x,est_y);delta_time++) {
			est_x += Math.sin(target.heading) * target.velocity;
			est_y += Math.cos(target.heading) * target.velocity;
			if(est_x < 18 ||
				est_y < 18 ||
				est_x > bw_width - 18 ||
				est_y > bw_height - 18
			) {
				est_x = Math.min(bw_width - 18, Math.max(18, est_x));
				est_y = Math.min(bw_height - 18, Math.max(18, est_y));
//				db("gg:"+est_x+","+est_y);
				break;
			}
		}
		return normalRelativeAngle(Math.atan2(est_x - getX(), est_y - getY()) - getGunHeadingRadians());
	}

	private double target_circular(double bullet_power) {
		return 0;
	}

	private double target_gf_normal(double bullet_power) {
		double[] current_segment;
		GFWave unrealbullet;
		int i, optimal;
		double fire_guessbullet;
		//process waves
		for(i=0;i<gf_waves.size();i++) {
			GFWave gg = (GFWave)gf_waves.get(i);
			if(gg.check(target.x,target.y)) {
				gf_waves.remove(gg);
				i--;
			}
		}

		//calculations for firing angle
		current_segment = gf_statistics[getEnemy()][(int)(Math.round(target.distance/100))];
		unrealbullet = new GFWave(getX(), getY(), target.absbearing, bullet_power, target.rel_direction, current_segment);
		//find optimal GF
		optimal = (int)(Math.floor(current_segment.length/2));
		String a = "";
		for(i=0;i<current_segment.length;i++) {	
			if(current_segment[i] > current_segment[optimal]) optimal = i;
			a += current_segment[i] + ",";
		}
		db("DD:"+a, DEBUG_GF);
		fire_guessbullet = optimal/(Math.floor(current_segment.length/2.0)*2.0);
		fire_guessbullet = (fire_guessbullet*2)-1;
		double angleOffset = target.rel_direction*fire_guessbullet*unrealbullet.max_escape_angle;
		double final_angle = angleOffset + target.absbearing - getGunHeadingRadians();
		//non-firing waves
		gf_waves.add(unrealbullet);
		return normalRelativeAngle(final_angle);
	}

	private double target_gf_ra(double bullet_power) {
		double[] current_segment;
		ASWave unrealbullet;
		int i, optimal;
		double fire_guessbullet;
		//process waves
		for(i=0;i<gf_ra_waves.size();i++) {
			ASWave gg = (ASWave)gf_ra_waves.get(i);
			if(gg.check(target.x,target.y)) {
				gf_ra_waves.remove(gg);
				i--;
			}
		}

		//calculations for firing angle
		current_segment = gf_ra_statistics[getEnemy()][Math.round((int)(target.distance/100))];
		unrealbullet = new ASWave(getX(), getY(), target.absbearing, bullet_power, target.rel_direction, current_segment);
		//find optimal GF
		optimal = (int)(Math.floor(current_segment.length/2));
		String a = "";
		for(i=0;i<current_segment.length;i++) {	
			if(current_segment[i] > current_segment[optimal]) optimal = i;
			a += current_segment[i] + ",";
		}
		db("DD:"+a, DEBUG_GF_AS);
		fire_guessbullet = optimal/(Math.floor(current_segment.length/2.0)*2.0);
		fire_guessbullet = (fire_guessbullet*2)-1;
		double angleOffset = target.rel_direction*fire_guessbullet*unrealbullet.max_escape_angle;
		double final_angle = angleOffset + target.absbearing - getGunHeadingRadians();
		if(getGunHeat() == 0 && final_angle < d2r(30))
			gf_ra_waves.add(unrealbullet);
		return normalRelativeAngle(final_angle);
	}

	/* WAVE-SURFING SUB FUNCTIONS */
	private EnemyWave select_nwave() {
		double min_dist = Double.POSITIVE_INFINITY;
		EnemyWave sel_wave = null;
		for(int i=0;i<sea_waves.size();i++) {
			EnemyWave ee = (EnemyWave)sea_waves.get(i);
			double dist = dist(getX(),getY(),ee.orig_x,ee.orig_y) - ee.getDistance();
			if(dist < min_dist && dist > ee.speed) {
				sel_wave = ee;
				min_dist = dist;
			}
		}
		return sel_wave;
	}

	private int getWFactor(EnemyWave ee, double enemy_x, double enemy_y) {
		double bearing = Math.atan2(enemy_x - ee.orig_x, enemy_y - ee.orig_y),f;
		db("EWB: "+r2d(normalRelativeAngle(bearing-ee.bearing)), DEBUG_WS);
		f = ee.dir * normalRelativeAngle(bearing-ee.bearing); f/=ee.getMaxEscapeAngle();
		return (int)(Math.min(Math.max(0, f *((WS_BINS-1)/2)+(WS_BINS - 1)/2),WS_BINS-1));
	}

	private double getDanger(EnemyWave ee, int dir) {
		double px=getX(),py=getY(),pv=getVelocity(),ph=getHeadingRadians();
		double mt,ma,md;
		int cc = 0;
		boolean i = false;
		do {
			ma = swm(px,py,Math.atan2(px-ee.orig_x,py-ee.orig_y)+dir*Math.PI/2,dir) - ph;
			md = 1;
			if(Math.cos(ma) < 0) {
				ma += Math.PI;
				md = -1;
			}
			ma = normalRelativeAngle(ma);
			mt = Math.PI/730.0*(40.0-3.0*Math.abs(pv));
			ph = normalRelativeAngle(ph + Math.max(-mt,Math.min(ma,mt)));
			pv += (pv*md<0?2:1)*md;
			pv = Math.max(-8,Math.min(8,pv));
			px += Math.sin(ph) * pv;
			py += Math.cos(ph) * pv;
			cc++;
			if(dist(px,py,ee.orig_x,ee.orig_y) < ee.getDistance() + (cc+1) * ee.speed) {
				i = true;
			}
		}
		while (cc < 500 && !i);
		return surf_statistics[getEnemy()][getWFactor(ee,px,py)];
	}

	private double swm(double enemy_x, double enemy_y, double ang, int dir) {
		while (!rf.contains(new Point2D.Double(enemy_x + Math.sin(ang) * SW,enemy_y + Math.cos(ang) * SW))) {
			ang += 0.05*dir;
		}
		return ang;
	}

	/* MISCELLANOUS EVENTS */
	public void onHitByBullet(HitByBulletEvent e) {
		if(!sea_waves.isEmpty()) {
			for(int i=0;i<sea_waves.size();i++) {
				EnemyWave ee = (EnemyWave)sea_waves.get(i);
				db(Math.round((20.0 - (3.0 * (e.getBullet().getPower())))*10) + " == " + Math.round(ee.speed*10) + " | " + Math.abs(ee.getDistance() - dist(getX(),getY(),ee.orig_x,ee.orig_y)) + " < 50", DEBUG_WS);
				if(Math.round((20.0 - (3.0 * (e.getBullet().getPower())))*10) == Math.round(ee.speed*10) && Math.abs(ee.getDistance() - dist(getX(),getY(),ee.orig_x,ee.orig_y)) < 50) {
					double ix = getWFactor(ee, e.getBullet().getX(), e.getBullet().getY());
					db("HIT_F: "+ix, DEBUG_WS);
					for(int j=0;j<WS_BINS;j++) {
						surf_statistics[getEnemy()][j] += 1 / (Math.pow(ix - j, 2) + 1);
					}
					sea_waves.remove(ee);
					return;
				}
			}
		}
	}

	public void onHitRobot(HitRobotEvent e) {
		if(getOthers() == 1) {
			if(getEnergy() - e.getEnergy() > 16)
				setAhead(e.getBearing() > -90 && e.getBearing() <= 90 ? 100 : -100);
		}
	}

	public void onRobotDeath(RobotDeathEvent e) {
		if(target != null && target.name.equals(e.getName())) {
			//target's dead, go find another one
			target = null;
			target_last = null;
			db("Target died... " + e.getName(), DEBUG_GN);
		}
		for(int i=0;i<MAX_ENEMIES&&enemies[i]!=null;i++) {
			if(enemies[i].name == e.getName()) enemies[i].dead = true;
		}
	}

	public void onWin(WinEvent e) {
		onDeath(null);
	}

	public void onDeath(DeathEvent e) {
		DEBUG_RECORDS[getOthers()]++;
		for (int i=0; i<DEBUG_RECORDS.length; i++)
			System.out.print(DEBUG_RECORDS[i] + " ");
		System.out.println();
	}

	/* DEBUG FRAMEWORK */
	public void onPaint(Graphics2D g){
		for(int i=0;i<virtualbullets.size();i++) {
			VirtualBullet virtualBullet = (VirtualBullet) virtualbullets.get(i);
			g.setColor(Guns[virtualBullet.gun].colour);
			g.fillOval((int)virtualBullet.getX() - 3, (int)virtualBullet.getY() -3, 6, 6);
		}
		for(int j = 0; j < 4; j++){
			g.setColor(Color.WHITE);
			g.drawString(Guns[j].name + ": " + vg_statistics[getEnemy()][j], 20, 5 + j*15 + 65);
			g.setColor(Guns[j].colour);
			g.fillOval(5, 5 + j * 15 + 65, 10, 10);
		}
	}


	private void db(String msg, boolean TYPE) {
		if(TYPE) System.out.println(msg);
	}

	private void db(double msg, boolean TYPE) {
		if(TYPE) System.out.println(msg);
	}

	private void db(boolean msg, boolean TYPE) {
		if(TYPE) System.out.println(msg);
	}

	/* UTILITY FUNCTIONS */
	private double normalRelativeAngle(double ang) {
		return robocode.util.Utils.normalRelativeAngle(ang);
	}

	private double normalAbsoluteAngle(double ang) {
		return robocode.util.Utils.normalAbsoluteAngle(ang);
	}

	private double getNextVelocity() {
		if(getDistanceRemaining() > 0 && getVelocity() >= 0) return Math.min(8.0,getVelocity()+1.0);
		if(getDistanceRemaining() > 0 && getVelocity() < 0) return Math.min(0.0,getVelocity()+2.0);
		if(getDistanceRemaining() < 0 && getVelocity() <= 0) return Math.max(-8.0,getVelocity()-2.0);
		if(getDistanceRemaining() < 0 && getVelocity() > 0) return Math.max(0.0,getVelocity()-2.0);
		return 0.0;
	}

	private double getNextY() {
		return getY() + getNextVelocity()*Math.cos(getHeadingRadians());
	}

	private double getNextX() {
		return getX() + getNextVelocity()*Math.sin(getHeadingRadians());
	}

	private double getNextHeading() {
		return getHeading() + Math.min(getTurnRemaining(),10-0.75*Math.abs(getVelocity()));
	}

	private void checkEnemy(EnemyRobot e) {
		int i;
		for(i=0;i<enemies.length;i++) {
			if(enemies[i] == null) break;
			if(enemies[i].name.equals(e.name)) {
				if(enemies[i].time < e.time) enemies[i] = e;
				return;
			}
		}
		enemies[i] = e;
	}

	private int getEnemy() {
		if(target == null) return 0;
		int i;
		for(i=0;i<enemies.length;i++) {
			if(enemies[i] == null) break;
			if(enemies[i].name.equals(target.name)) return i;
		}
		return i;
	}

	private double dist(double x1, double y1, double x2, double y2) {
		return Point2D.Double.distance(x1,y1,x2,y2);
	}

	private double d2r(double degrees) {
		return degrees/360*2*Math.PI;
	}

	private double r2d(double radians) {
		return radians/(2*Math.PI)*360;
	}

	public class Wave
	{
		public double orig_x, orig_y, bearing, power;
		public double speed;
		public long start_time;
		public boolean check() { return true; }
	}

	public class GFWave extends Wave
	{
		public double max_escape_angle;
		public int dir;
		public double[] slice;

		public GFWave () {}

		public GFWave(
			double orig_x,
			double orig_y,
			double bearing,
			double power,
			int dir,
			double[] slice
		) {
			this.orig_x = orig_x;
			this.orig_y = orig_y;
			this.bearing = bearing;
			this.power = power;
			this.dir = dir;
			this.start_time = getTime();
			this.slice = slice;
			speed = 20.0 - (3.0 * power);
			max_escape_angle = Math.asin(8 / speed);
		}

		public boolean check(double en_x, double en_y) {
			double ourgf;
			int ff;
			if((getTime() - start_time) * speed >= dist(orig_x,orig_y,en_x,en_y)) {
				ourgf = normalRelativeAngle( Math.atan2(en_x - orig_x, en_y - orig_y) - bearing );
//				db("poof goes our wave: "+ourgf+"/"+max_escape_angle+" = "+ourgf/max_escape_angle);
				ourgf = Math.min(Math.max(-1, ourgf/max_escape_angle),1) * dir;
				ff = (int)(Math.round((ourgf+1)*(slice.length-1)/2));
				for (int i=0;i<GF_BINS;i++) {
					slice[i] += 1.0 / (Math.pow(ff-i, 2) + 1);
				}
				db("poof goes our wave: "+ourgf, DEBUG_GF);
				return true;
			}
			return false;
		}
	}

	public class ASWave extends GFWave
	{
		public ASWave(
			double orig_x,
			double orig_y,
			double bearing,
			double power,
			int dir,
			double[] slice
		) {
			this.orig_x = orig_x;
			this.orig_y = orig_y;
			this.bearing = bearing;
			this.power = power;
			this.dir = dir;
			this.start_time = getTime();
			this.slice = slice;
			speed = 20.0 - (3.0 * power);
			max_escape_angle = Math.asin(8 / speed);
		}

		public boolean check(double en_x, double en_y) {
			double ourgf;
			int ff;
			if((getTime() - start_time) * speed >= dist(orig_x,orig_y,en_x,en_y)) {
				ourgf = normalRelativeAngle( Math.atan2(en_x - orig_x, en_y - orig_y) - bearing );
//				db("poof goes our wave: "+ourgf+"/"+max_escape_angle+" = "+ourgf/max_escape_angle);
				ourgf = Math.min(Math.max(-1, ourgf/max_escape_angle),1) * dir;
				ff = (int)(Math.round((ourgf+1)*(slice.length-1)/2));
				for (int i=0;i<GF_BINS;i++) {
					slice[i] = (HISTORY_DEPTH * slice[i] + (1.0 / (Math.pow(ff-i, 2) + 1)) * power) / (HISTORY_DEPTH+power);
				}
				HISTORY_DEPTH += power;
				db("poof goes our wave: "+ourgf, DEBUG_GF);
				return true;
			}
			return false;
		}
	}

	public class EnemyWave extends Wave
	{
		public int dir;

		public EnemyWave (
			double orig_x,
			double orig_y,
			double bearing,
			double power,
			int dir
		) {
			this.orig_x = orig_x;
			this.orig_y = orig_y;
			this.bearing = bearing;
			this.dir = dir;
			speed = 20.0 - (3.0 * power);
			start_time = getTime()-1;
		}

		public boolean check() {
			double time_taken = getTime() - start_time;
			if(time_taken * speed > dist(getX(),getY(),orig_x,orig_y) + 50) {
				return true;
			}
			return false;
		}

		public double getDistance() {
			return (getTime() - start_time) * speed;
		}

		public double getMaxEscapeAngle() {
			return Math.asin( 8.0 / speed);
		}
	}

	public class VirtualBullet extends Wave
	{
		public int gun;

		public VirtualBullet (
			double orig_x,
			double orig_y,
			double bearing,
			double power,
			int gun
		) {
			this.orig_x = orig_x;
			this.orig_y = orig_y;
			this.bearing = normalAbsoluteAngle(getGunHeadingRadians()+bearing);
			this.power = power;
			this.gun = gun;
			speed = 20.0 - (3.0 * this.power);
			start_time = getTime();
			db("New Bullet: "+gun, DEBUG_VG);
		}

		public boolean check() {
			double time_taken = getTime() - start_time;
			double px = orig_x + time_taken * speed * Math.sin(bearing);
			double py = orig_y + time_taken * speed * Math.cos(bearing);
			db("Gun: "+Guns[gun].name+" | "+ px +"," + py + " | " + target.x + "," + target.y, DEBUG_VG);
			if(Math.abs(target.x - px) < 18 && Math.abs(target.y - py) < 18) {
				vg_statistics[getEnemy()][this.gun]++;
				db("Hit - "+this.gun, DEBUG_VG);
				return true;
			}
//			db("VirtualBullet: "+px+","+py);
			if(px < 0 || py < 0 || px > bw_width || py > bw_height) {
				db(this.gun+" went out of bounds", DEBUG_VG);
				return true;
			}
			return false;
		}

		public double getX() {
			return orig_x + (getTime() - start_time) * speed * Math.sin(bearing);
		}

		public double getY() {
			return orig_y + (getTime() - start_time) * speed * Math.cos(bearing);
		}
	}


	public class Gun {
		public String name;
		public Color colour;
		public int hit_stats = 0;
		public Gun (String name, Color colour) {
			this.name = name;
			this.colour = colour;
		}
		public Gun (String name, int colour) {
			this.name = name;
			this.colour = new Color(colour);
		}
	}

	public class EnemyRobot
	{
		public String name;
		public double x;
		public double y;
		public double energy;

		public double bearing;
		public double absbearing;

		public double heading;
		public double distance;
		public double velocity;

		public int rel_direction;
		public long time;

		public boolean dead;

		public EnemyRobot(ScannedRobotEvent e) {
			bearing = e.getBearingRadians();
			absbearing = getHeadingRadians() + e.getBearingRadians();
			x = getX() + Math.sin(absbearing) * e.getDistance();
			y = getY() + Math.cos(absbearing) * e.getDistance();
			energy = e.getEnergy();
			distance = e.getDistance();
			velocity = e.getVelocity();
			heading = e.getHeadingRadians();
			name = e.getName();
			time = getTime();
			rel_direction = Math.sin(heading - absbearing) * velocity < 0 ?  -1 : 1;
			dead = false;
		}
	}

	public class AGPoint //Anti-Gravity Point
	{
		public double x;
		public double y;
		public double force;

		public AGPoint(double x, double y, double force) {
			this.x = x;
			this.y = y;
			this.force = force;
		}
	}
}