package tzu.util;

/**
 */

/**
 * A force that can be attributed to enemy bots in order to
 * control the movement of our own bot.  It is comprised of
 * direction in degrees (compass orientation) and force
 * (how far we have to move to escape the repulsion).
 */
public final class AntiGravity {


    private double direction;
    private double force;


    /**
     * Create an AntiGravity object with
     * zero direction and force.
     */
    public AntiGravity() {
        this (0,0);
    }


    /**
     * Create an AntiGravity object with
     * specified direction and force.
     */
    public AntiGravity(double newDirection, double newForce) {
        direction   = newDirection;
        force       = newForce;
    }

    /**
     * Create an AntiGravity object with the specified relative point.
     *
     * @param p     relative (not absolute) point that anti-gravity is
     * pushing towards; if p is (-3, 40), then anti-gravity force
     * is pushing us towards a point 3 pixels west and 40 pixels north of
     * our current position.
     */
    public AntiGravity(Point p) {
        direction   = BotMath.arcTan(p.y, p.x);
        force       = BotMath.sqrt(p.x * p.x + p.y * p.y);
    }


    /** Return direction (in degrees) of AntiGravity force. */
    public double getDirection() {
        return direction;
    }


    /** Return AntiGravity force. */
    public double getForce() {
        return force;
    }

    /** Return a string representing this AntiGravity object. */
    public String toString() {
        return "AntiGravity direction=" + BotMath.round2(direction) +
               "  force="   + BotMath.round2(force);
    }
}
