package kawigi.sbf.utils;
import kawigi.sbf.core.*;
import kawigi.sbf.core.messages.*;
import java.awt.geom.*;
import java.util.*;
import java.util.zip.*;
import java.io.*;
import robocode.*;

public class Utils
{
	/*
		Segmentations.  Note that to reference segments, I need to make
		an array of segment indexes that is one bigger than the size
		of these arrays (the first index should be 0 for 1-on-1 and 1
		for melee.
	*/
	
	/*
		1-on-1 segmentations:
			2 Wall
			3 accl (a little more estimated in melee)
			3 latd
			3 velocity
			4 time
			10 bft
	*/
	public static final int[] segmentSizes = {2, 3, 3, 3, 4, 10};
	/*
		melee segmentations:
			2 Wall
			3 accl (a little more estimated in melee)
			3 latd
			8 antigravity
			10 bft
	*/
	public static final int[] meleeSegmentSizes = {2, 3, 3, 8, 10};
	/*
		self segmentations
		2 wall
		3 accl
		3 latv
		4 time
		10 bft
	*/
	public static final int[] selfSegmentSizes = {2, 3, 3, 4, 10};
	
	public static final int GFS = 31;
	public static final int CRIB_LENGTH = 3;
	public static double fieldWidth, fieldHeight;
	private static TeamRobot robot;
	private static HashMap enemies;
	private static HashMap teammates;
	private static HashMap stats;
	private static HashMap selfstats;
	private static Point2D myLocation;
	private static VolatileEnemy currentTarget;
	private static int[] survivalInfo;
	private static long starttime;
	private static boolean isTeamGame, won, leader, droid;
	
	public static void initRound(TeamRobot r)
	{
		robot = r;
		fieldWidth = robot.getBattleFieldWidth();
		fieldHeight = robot.getBattleFieldHeight();
		if (stats == null)
		{
			stats = new HashMap();
			selfstats = new HashMap();
		}
		if (survivalInfo == null)
			survivalInfo = new int[robot.getOthers()+1];
		enemies = new HashMap();
		teammates = new HashMap();
		currentTarget = null;
		myLocation = new Point2D.Double();
		won = false;
		String[] team = r.getTeammates();
		if (team != null)
		{
			isTeamGame = true;
			for (int i=0; i<team.length; i++)
				teammates.put(team[i], new VolatileEnemy());
			teammates.put(r.getName(), new VolatileEnemy());
			leader = robot.getEnergy() > 180;
			droid = robot.getEnergy()%100 > 10 && robot.getEnergy()%100 < 30;
		}
		if (starttime == 0)
			starttime = System.currentTimeMillis();
		update();
	}
	
	public static void uninitRound()
	{
		enemies.clear();
		teammates.clear();
		printSurvival(robot.getOthers());
		//Disabling saving, since it doesn't work well.
		//if (robot.getNumRounds() == robot.getRoundNum()+1)
		//	save();
	}
	
	public static void printSurvival(int others)
	{
		if (won)
			return;
		if (others == 0)
			won = true;
		survivalInfo[others]++;
		for (int i=0; i<survivalInfo.length; i++)
			robot.out.print(pad((i+1) + suffix(i+1) + "s", 7));
		robot.out.println();
		for (int i=0; i<survivalInfo.length; i++)
			robot.out.print(pad((others == i ? "*" : "") + survivalInfo[i], 7));
		robot.out.println();
		long elapsed = System.currentTimeMillis()-starttime;
		robot.out.println(elapsed/60000 + " minutes and " + (elapsed%60000)/1000.0 + " seconds so far");
	}
	
	private static String suffix(int n)
	{
		if ((n/10)%10 != 1)
		{
			if (n%10 == 1)
				return "st";
			else if (n%10 == 2)
				return "nd";
			else if (n%10 == 3)
				return "rd";
		}
		return "th";
	}
	
	private static String pad(String s, int size)
	{
		while (size > s.length())
			s += " ";
		return s;
	}
	
	public static void update()
	{
		myLocation.setLocation(robot.getX(), robot.getY());
		VolatileEnemy e = getTeammate(robot.getName());
		if (e != null)
		{
			e.update(robot);
		}
		if (isTeamGame)
		{
			TeamController.sendMessage(new AllyUpdateMessage(robot.getName(), currentTarget == null ? null : currentTarget.name, new Point2D.Double(myLocation.getX(), myLocation.getY()), leader, droid, false));
		}
	}
	
	//utility functions, I figure anyone making a goto bot has something like these, and they
	//come in useful in a lot of other random places, too:
	public static Point2D projectPoint(Point2D startPoint, double theta, double dist)
	{
		return new Point2D.Double(startPoint.getX() + dist * Math.sin(theta), startPoint.getY() + dist * Math.cos(theta));
	}
	
	//This strange habit of putting point2 before point1 in this method - and the funny thing is I think
	//I've seen other people do the same thing:
	public static double angle(Point2D point2, Point2D point1)
	{
		return Math.atan2(point2.getX()-point1.getX(), point2.getY()-point1.getY());
	}
	
	//returns true if a point is within a truncated field
	public static boolean inFieldTrunc(Point2D p)
	{
		return new Rectangle2D.Double(30, 30, fieldWidth-60, fieldHeight-60).contains(p);
	}
	
	public static boolean inField(Point2D p)
	{
		return new Rectangle2D.Double(17.9, 17.9, fieldWidth-35.8, fieldHeight-35.8).contains(p);
	}
	
	public static double normalize(double angle)
	{
		return robocode.util.Utils.normalRelativeAngle(angle);
	}
	
	public static VolatileEnemy getEnemy(String name)
	{
		if (!enemies.containsKey(name))
			enemies.put(name, new VolatileEnemy());
		return (VolatileEnemy)enemies.get(name);
	}
	
	public static Iterator getEnemies()
	{
		return enemies.values().iterator();
	}
	
	public static int countEnemies()
	{
		return enemies.size();
	}
	
	public static VolatileEnemy getTeammate(String name)
	{
		if (!teammates.containsKey(name))
			teammates.put(name, new VolatileEnemy());
		return (VolatileEnemy)teammates.get(name);
	}
	
	public static Iterator getTeammates()
	{
		return teammates.values().iterator();
	}
	
	public static int countTeammates()
	{
		return teammates.size();
	}
	
	public static void save()
	{
		Iterator it = stats.keySet().iterator();
		while (it.hasNext())
		{
			try
			{
				String name = (String)it.next();
				ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(robot.getDataFile(name))));
				out.writeObject(stats.get(name));
				out.close();
			}
			catch (IOException ex)
			{
				System.out.println("Error writing enemies to file.");
			}
		}
		it = selfstats.keySet().iterator();
		while (it.hasNext())
		{
			try
			{
				String name = (String)it.next();
				ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(robot.getDataFile(name + "-self"))));
				out.writeObject(selfstats.get(name));
				out.close();
			}
			catch (IOException ex)
			{
				System.out.println("Error writing enemies to file.");
			}
		}
	}
	
	public static Stats getStats(String name)
	{
		name = getRealName(name);
		if (stats.containsKey(name))
			return (Stats)stats.get(name);
		else
		{
			//Disabling reading data, because reading data doesn't help yet :-)
			Object ret;
			//try
			//{
			//	ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(robot.getDataFile(name))));
			//	stats.put(name, ret = in.readObject());
			//}
			//catch (Exception ex)
			//{
				stats.put(name, ret = new Stats(segmentSizes, meleeSegmentSizes, GFS));
			//}
			return (Stats)ret;
		}
	}
	
	public static Stats getSelfStats(String name)
	{
		if (selfstats.containsKey(name))
			return (Stats)selfstats.get(name);
		else
		{
			Stats ret;
			selfstats.put(name, ret = new Stats(selfSegmentSizes, selfSegmentSizes, GFS));
			return ret;
		}
	}
	
	public static String getRealName(String name)
	{
		if (name.indexOf('(') >= 0)
			name = name.substring(0, name.indexOf('(')).trim();
		return name;
	}
	
	public static Point2D getMyLocation()
	{
		return myLocation;
	}
	
	public static VolatileEnemy getCurrentTarget()
	{
		return currentTarget;
	}
	
	public static void setCurrentTarget(VolatileEnemy e)
	{
		currentTarget = e;
	}
	
	public static double getTargetRating(VolatileEnemy e)
	{
		return e.distance(myLocation) - e.energy;
	}
	
	public static void robotDeath(String name)
	{
		if (enemies.containsKey(name))
		{
			if (enemies.remove(name) == currentTarget)
				currentTarget = null;
		}
		else if (teammates.containsKey(name))
			teammates.remove(name);
	}
	
	public static TeamRobot getRobot()
	{
		return robot;
	}
	
	public static double getPower(VolatileEnemy target)
	{
		double power = Math.min(robot.getEnergy()/5, 3);
		if (target.energy < 16)
		{
			double powerToFinish = Math.min(target.energy/4, (target.energy+2)/6);
			if (target.distance(myLocation) < 300)
			{
				//The goal here is to fire hard enough to finish them even if they hit me at their last bullet power
				//before my bullet reaches them.  If they are closer than 100, I hit them at this power, if they are
				//between 100 and 300 away, I use a percentage in between.
				//This may be part of the reason I get high bullet damage, but taking it out also reduces my survival.
				double targetEnergy = target.energy + target.lastBulletPower*3*Math.min(1, (1.5-target.distance(myLocation)/200));
				powerToFinish = Math.min(targetEnergy/4, (targetEnergy+2)/6);
			}
			power = Math.min(power, powerToFinish);
		}
		power = Math.min(power, 1200/target.distance(myLocation));
		return power;
		//return Math.min(3, Math.max(.1, 80*Math.min(target.energy, robot.getEnergy())/target.distance(myLocation)));
	}
	
	public static double getBulletVelocity(double power)
	{
		return 20-3*power;
	}
	
	public static boolean isTeamGame()
	{
		return isTeamGame;
	}
}
