package vuen.cfCake;
import vuen.Cake;
import robocode.*;
import java.io.*;
import java.awt.Color;

public class cComControl {
	private Cake oRobot = null;
	public cComEnemy mComEnemy = null;
	
	public double mTimeDelta = 0;
	public double mLastTime = 0;
	
	public double mEnergyDelta = 0;
	public double mLastEnergy = 100;
	
	public int mTarget = 0;

	public boolean mFireNow = false;
	public double mFirePower = 0;
	
	public void doPrintStats() {
		oRobot.out.println("");
		oRobot.out.println("  *************STATS*************");
		oRobot.mJaiControl.doPrintStats();
		oRobot.mRadControl.doPrintStats();
		oRobot.mGunControl.doPrintStats();
		oRobot.mMovControl.doPrintStats();
		if (oRobot.mJaiControl.mIsDuel) {
			oRobot.out.println("  ---Enemies - Individual Data");
			for (int i = 0; i < mComEnemy.mTotalNames; i++) {
				oRobot.out.println("  " + mComEnemy.mEnemyNames[i]);
				//oRobot.out.println("       Bias(Inc): " + Math.round((double)mGunTrackBias[i] * (double)1000) / (double)1000 + "(" + Math.round((double)mGunTrackBiasInc[i] * (double)1000) / (double)1000 + ") / " + Math.round(mGunFlakBias[i] * (double)1000) / (double)1000 + "(" + Math.round(mGunFlakBiasInc[i] * (double)1000) / (double)1000 + ")");
				//oRobot.out.println("       FirePower(Mult): " + Math.round((double)mGunTrack.mTweakFirePower[i] * (double)1000) / (double)1000 + "(" + Math.round((double)mGunTrack.mTweakFirePowerMult[i] * (double)1000) / (double)1000 + ") / " + Math.round((double)mGunFlak.mTweakFirePower[i] * (double)1000) / (double)1000 + "(" + Math.round((double)mGunFlak.mTweakFirePowerMult[i] * (double)1000) / (double)1000 + ")");
				oRobot.mJaiControl.doPrintEnemyStats(i);
				oRobot.mRadControl.doPrintEnemyStats(i);
				oRobot.mGunControl.doPrintEnemyStats(i);
				oRobot.mMovControl.doPrintEnemyStats(i);			
			}
		}
		oRobot.mJaiControl.mJaiScore.doPrintScore();
		oRobot.out.println("  ***********END STATS***********");
		oRobot.out.println("");
	}
	
	public cComControl(Cake pRobot) {
		oRobot = pRobot;
		mComEnemy = new cComEnemy(oRobot, this);
		mLastEnergy = oRobot.getEnergy();
		if (oRobot.getRoundNum() == 0) {
			oRobot.out.println("[" + oRobot.getTime() + "] COM: Creating Data Communications Access");
		}
	}
	
	public void doTurn() {
		mTimeDelta = oRobot.getTime() - mLastTime;
		mLastTime = oRobot.getTime();
		mEnergyDelta = oRobot.getEnergy() - mLastEnergy;
		mLastEnergy = oRobot.getEnergy();
		//mEnemyTargetTimeout += mTimeDelta;
		//if (mEnemyTargetTimeout >= CEnemyTargetTimeout) {
		//	mEnemyTargetable = false;
		//}
	}
	
	public void doComScannedRobot(ScannedRobotEvent e, boolean pTarget) {
		if (oRobot.isTeammate(e.getName()) == false) mComEnemy.doScannedEnemy(e, pTarget);
	}
	
	public void onMessageReceived(MessageEvent e) {
		//if (e.getMessage() instanceof cColor) {
		//	cColor pMsgColor = (cColor)e.getMessage();
		//	oRobot.setColors(pMsgColor.getColor(), new Color(255,255,255), new Color(255,255,255));
		//} else if (e.getMessage() instanceof cScan) {
			//cScan pMsgScan = (cScan)e.getMessage();
			//turnGunRight(normalRelativeAngle(Math.toDegrees(Math.atan2(pMsgScan.getX() - getX(), pMsgScan.getY() - getY())) - getGunHeading()));
			//fire(3);
		//}
	}
	
	public void doComFire(double privateComFirePower) {
		mFireNow = true;
		mFirePower = privateComFirePower;
	}
	
	public void doEndTurn() {
		if (mFireNow && oRobot.getGunHeat() == 0 && oRobot.getEnergy() > mFirePower) {
			mFireNow = false;
			//oRobot.fire(mFirePower);
			oRobot.setFire(mFirePower);
			oRobot.scan();
		} else {
			mFireNow = false;
			oRobot.scan();
		}
	}
	
	public void onLockChange(String pName) {
		mTarget = getNameIndex(pName);
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		if (oRobot.isTeammate(e.getName())) return;
		mComEnemy.mEnemyDead[getNameIndex(e.getName())] = true;
	}
	
	public int getNameIndex(String pName) {
		if (pName == null) return 0;
		int pIndex = -1;
		if (oRobot.isTeammate(pName)) {
			//team code here
			return 0;
		} else {
			for (int i = 0; i < mComEnemy.mTotalNames; i++) {
				//[28/10/03, 2.51]
				//I can't believe I got away with this for so long...
				//if (pName == mComEnemy.mEnemyNames[i]) pIndex = i;
				if (pName.equals(mComEnemy.mEnemyNames[i])) pIndex = i;
			}
			if (pIndex == -1) {
				mComEnemy.mEnemyNames[mComEnemy.mTotalNames] = pName;
				pIndex = mComEnemy.mTotalNames;
				mComEnemy.mTotalNames++;
				//oRobot.out.println("[" + oRobot.getTime() + "] COM: Adding " + pName + " to enemy names list, index " + pIndex);
			}
			return pIndex;
		}
	}
	
	public boolean isEnemyValid(int pIndex) {
		if (mComEnemy.mEnemyDead[pIndex])
			return false;
		else
			return true;
	}
}