package DTF;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;

import robocode.AdvancedRobot;
import robocode.util.*;


public class Util {
	// standardized on degrees
	
	public static double minX=0;
	public static double minY=0;
	public static double maxX=0;
	public static double maxY=0;
	
	public static Random rnd=new Random();
	
	private static /* AdvancedRobot */ Object me; //workaround for new warning in 1.7.2
	
	public static boolean debugging=false;
	
	
	private static DecimalFormat numformat=new DecimalFormat("0.000",new DecimalFormatSymbols(Locale.US)); //they make hard things easy and easy things hard
	
	public static void println(Object o) {
		if(me!=null) {
			((AdvancedRobot)me).out.println(o);
		}
	}
	
	public static AdvancedRobot getMe() {
		return (AdvancedRobot)me;
	}
	
	public static void init(AdvancedRobot robot) {
		minX=robot.getWidth()/2;
		maxX=robot.getBattleFieldWidth()-minX;
		
		minY=robot.getHeight()/2;
		maxY=robot.getBattleFieldHeight()-minY;
		
		me=robot;
	}
	
	public static double clamp(double a,double min,double max) {
		if(a<min) return min;
		else if(a>max) return max;
		else return a;
	}
	
	public static double clampX(double x) {
		return clamp(x,minX,maxX);
	}
	
	public static double clampY(double y) {
		return clamp(y,minY,maxY);
	}
	
	public static boolean inArena(double x, double y) {
		return x>=minX && x<=maxX && y>=minY && y<=maxY;
	}
	
	public static boolean inArena(double x, double y, double extraPad) {
		return x>=minX+extraPad && x<=maxX-extraPad && y>=minY+extraPad && y<=maxY-extraPad;
	}
	
	
	public static double tan(double degrees) { return Math.tan(Math.toRadians(degrees)); }

	public static double cos(double degrees) { return Math.cos(Math.toRadians(degrees)); }

	public static double sin(double degrees) { return Math.sin(Math.toRadians(degrees)); }

	public static double atan(double a) { return Math.toDegrees(Math.atan(a)); }	
	
	public static double normalBearing(double angle) {
		return (angle+1620.0)%360.0-180.0;
		//return Utils.normalRelativeAngleDegrees(angle); only in 1.7
	}
	
	public static double normalHeading(double angle) {
		return (angle+1440.0)%360.0;
		//return Utils.normalAbsoluteAngleDegrees(angle); only in 1.7
	}
	
	public static double heading(double x, double y) {
		if(x==0 && y==0) return 0;
		return normalHeading(Math.toDegrees(Math.atan2(x, y)));
	}
	
	public static double distance(double x, double y) {
		return Math.sqrt(x*x+y*y);
	}

	public static void shuffle(double[] a) {
		int len=a.length;
		for(int i=0;i<len;i++) {
			int j=i+rnd.nextInt(len-i);
			double t=a[i];
			a[i]=a[j];
			a[j]=t;
		}
	}
	
	public static void shuffle(Object[] a) {
		Collections.shuffle(Arrays.asList(a));
	}
	
	public static String formatDouble(double d) {
		return numformat.format(d);
	}
	
	public static String join(double[] a, String separater) {
		StringBuilder out=new StringBuilder();
		
		boolean add=false;
		for(double v:a) {
			if(add) {
				out.append(separater);
			}
			out.append(numformat.format(v));
			add=true;
		}
		return out.toString();
	}
}
