package stelo;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;

// random movement
public class Randomness extends AdvancedRobot {
    static final double MAX_VELOCITY = 8;
    static final double WALL_MARGIN = 25;
    Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle = 0.2;

	double lastEnemyAbsoluteBearing;
	double lastEnemyHeading;

    public void run() {
        setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);

        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY); 
        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        robotLocation = new Point2D.Double(getX(), getY());
        enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = vectorToLocation(enemyAbsoluteBearing, enemyDistance, robotLocation);

		attack(e);
		move();
		

        setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()) * 2);
		lastEnemyAbsoluteBearing = enemyAbsoluteBearing;
    }

	private void linearTarget(double bulletPower, ScannedRobotEvent e) {
		double myX = getX();
		double myY = getY();
		double absoluteBearing = deg2rad(getHeading() + e.getBearing() );
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = deg2rad(e.getHeading() );
		double enemyVelocity = e.getVelocity();
		
		
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		
		//turnRadarRight( rad2deg(Utils.normalRelativeAngle(absoluteBearing - deg2rad(getRadarHeading() ) ) ) );
		setTurnGunRight( rad2deg(Utils.normalRelativeAngle(theta - deg2rad(getGunHeading() ) ) ) );
	}
	
	private void circularTarget(double bulletPower, ScannedRobotEvent e, double w) {
		double absbearing = deg2rad(e.getBearing() ) + deg2rad(getHeading() );
		double eX = e.getDistance()*Math.sin(absbearing);
		double eY = e.getDistance()*Math.cos(absbearing);

		double db = 0;
		double ww = deg2rad(e.getHeading());  // enemy's starting heading
			
		do
		{
			// db+=11; //11 is the velocity of a fire(3) bullet.
			db += (20.0 - 3.0 * bulletPower);
			double dx=e.getVelocity()*Math.sin(ww);
			double dy=e.getVelocity()*Math.cos(ww);
			ww+=w;  // turn w radians for next step
				
			eX+=dx;
			eY+=dy;
		}while (db< Point2D.distance(0,0,eX,eY));	// The bullet travelled far enough to hit our target!
		
		setTurnGunRight(rad2deg(Math.asin(Math.sin(Math.atan2(eX, eY) - deg2rad(getGunHeading()))) ));			
	}
	
	private void attack(ScannedRobotEvent e) {
		double bulletPower = 1.8;
		
		if (e.getDistance() < 100) bulletPower = 3;
				
		double w = deg2rad(e.getHeading() ) - lastEnemyHeading;
		
		bulletPower = Math.min(bulletPower, e.getEnergy() / 4);
		bulletPower = Math.min(bulletPower, getEnergy() - 2);
		
		lastEnemyHeading = deg2rad(e.getHeading() );
				
		if (bulletPower <= getEnergy()) {
			//fire(bulletPower); // to use FiringAssistance, fire before move!
			if (w == 0)
				linearTarget(bulletPower, e);
			else {
				circularTarget(bulletPower, e, w);
			}
			fire(bulletPower);
		}
		
	}
	
	private double deg2rad(double d) {
		return d * Math.PI / 180;
	}
	
	private double rad2deg(double r) {
		return r * 180 / Math.PI;
	}		

    // Always try to move a bit further away from the enemy.
    // Only when the walls forces us we will close in on the enemy. We never bounce of walls.
    void move() {
		considerChangingDirection();
		Point2D robotDestination = null;
		double tries = 0;
		
		do {
			// robotDestination = vectorToLocation(absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
			//	    enemyDistance * (1.1 - tries / 100.0), enemyLocation);
			
		    robotDestination = vectorToLocation(absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
			    enemyDistance * 2.0 * (1.1 - tries / 100.0), enemyLocation);
		    tries++;
		} while (tries < 100 && !fieldRectangle(WALL_MARGIN).contains(robotDestination));
		// } while (tries < 100 && !fieldRectangle(WALL_MARGIN).contains(robotDestination));			
		goTo(robotDestination);
    }

    void considerChangingDirection() {
		// Change lateral direction at random
		// Tweak this to go for flat movement
		double flattenerFactor = 0.05;

		if (Math.random() < flattenerFactor) {
		    movementLateralAngle *= -1;
		}
    }

    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin,
	    getBattleFieldWidth() - margin * 2, getBattleFieldHeight() - margin * 2, 75, 75);
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation, destination) - getHeadingRadians());
		double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(robotLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
		// Hit the brake pedal hard if we need to turn sharply
		setMaxVelocity(Math.abs(getTurnRemaining()) > 33 ? 0 : MAX_VELOCITY);
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
		return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
		return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

	
	public void onHitByBullet(HitByBulletEvent e) {
		turnRadarRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians()));
	}
	
}
	