package kawigi.spare.util;
public class WallGravity extends GravityVector
{
	private double width, height;
	public WallGravity(double width, double height)
	{
		super(0, 0, 0);
		this.width = width;
		this.height = height;
	}
	
	public double absoluteAngle(double otherx, double othery)
	{
		double bottomVector = 10/Math.pow(othery-18, 1.5);
		double topVector = 10/Math.pow(height-18-othery, 1.5);
		double leftVector = 10/Math.pow(otherx-18, 1.5);
		double rightVector = 10/Math.pow(width-18-otherx, 1.5);
		return Math.atan2(rightVector-leftVector, topVector-bottomVector);
	}
	
	public double force(double otherx, double othery)
	{
		double distancex = Math.min(width-otherx, otherx)-18;
		double distancey = Math.min(height-othery, othery)-18;
		return 1000/Math.pow(distancex*distancex+distancey*distancey, 1.5);
	}
}
