package util;

import robocode.util.Utils;
import robocode.*;

public abstract class Tools
{
	public static double getDistance(double x1,double y1,double x2,double y2)
	{
		return Math.sqrt(((x2-x1)*(x2-x1))+((y1-y2)*(y1-y2)));
	}
	public static boolean shootAt(AdvancedRobot bot,double x,double y,double power)
	{
		Vector a=new Vector(bot.getX(),bot.getY(),x,y);
		bot.setTurnGunLeftRadians(Utils.normalRelativeAngle(bot.getGunHeadingRadians()-a.getAngle(new Vector(0,0,0,1))));
		if(Math.abs(bot.getGunHeadingRadians()-a.getAngle(new Vector(0,0,0,1)))<0.1)
			bot.fire(power);
		return false;
	}
	public static boolean setGoto(AdvancedRobot bot,double x,double y,double precision)
	{
		Vector direction=new Vector(0,0,Math.sin(bot.getHeadingRadians()),Math.cos(bot.getHeadingRadians()));
		Vector toPoint=new Vector(bot.getX(),bot.getY(),x,y);
		if(direction.getCross(toPoint)<0)
		{
			if(direction.getDot(toPoint)<0)
				bot.setTurnLeftRadians(Math.PI-direction.getAngle(toPoint));
			else
				bot.setTurnRightRadians(direction.getAngle(toPoint));
		}
		else
		{
			if(direction.getDot(toPoint)<0)
				bot.setTurnRightRadians(Math.PI-direction.getAngle(toPoint));
			else
				bot.setTurnLeftRadians(direction.getAngle(toPoint));
		}
		if(direction.getDot(toPoint)<0)
			bot.setBack(getDistance(bot.getX(),bot.getY(),x,y));
		else
			bot.setAhead(getDistance(bot.getX(),bot.getY(),x,y));
		if(getDistance(bot.getX(),bot.getY(),x,y)<=precision)
			return true;
		return false;
	}
	public static double[] linearPredict(AdvancedRobot bot,double x1,double y1,double x2,double y2,Vector velocity,double power)
	{
		double bulletSpeed=20-(3*power);
		double traveltime=new Vector(x1,y1,x2,y2).getLength()/bulletSpeed;
		double predx,predy;
		predx=x2+(velocity.x*traveltime);
		predy=y2+(velocity.y*traveltime);
		while(Math.abs(new Vector(x1,y1,predx,predy).getLength()-(bulletSpeed*traveltime))>3)
		{
			traveltime=new Vector(x1,y1,predx,predy).getLength()/bulletSpeed;
			predx=x2+(velocity.x*traveltime);
			predy=y2+(velocity.y*traveltime);
		}
		if(predx>bot.getBattleFieldWidth()-18)
			predx=bot.getBattleFieldWidth()-18;
		else if(predx<18)
			predx=18;
		if(predy>bot.getBattleFieldHeight()-18)
			predy=bot.getBattleFieldHeight()-18;
		else if(predy<18)
			predy=18;
		double[]returner={predx,predy};
		return returner;
	}
}
