package nat.gun.meteorite;

import nat.utils.Point;

@SuppressWarnings("serial")
public final class ScanInfo extends Point {
	public ScanInfo(Point pt) {
		super(pt);
	}

	public double heading, velocity, velocitiedHeading, absBearing;
	public int direction;
	public double lateralVelocity, advancingVelocity;
	public double accerelation;
	public double distance;
	public double wallDistanceForward, wallDistanceBackward;
	public double closestBotDistanceN, closestBotDistanceE;
	public double closestBotDistanceS, closestBotDistanceW;
	public double closestBotDistanceNE, closestBotDistanceSE;
	public double closestBotDistanceNW, closestBotDistanceSW;
	public double gravityValueN, gravityValueE;
	public double gravityValueS, gravityValueW;
	public double gravityValueNE, gravityValueSE;
	public double gravityValueNW, gravityValueSW;
	public double distanceLast2, distanceLast4, distanceLast8;
	public double distanceLast16, distanceLast32;
	public double angledDistanceLast2, angledDistanceLast4;
	public double angledDistanceLast8, angledDistanceLast16;
	public double angledDistanceLast32;

	public int time;
	public int round;

	public Trace getTrace(Trace last) {
		int lastTime;
		if (last == null) {
			lastTime = time - 1;
		} else {
			lastTime = last.time;
		}
		int timeDiff = time - lastTime;
		if (timeDiff == 1) {
			Trace result = new Trace();
			result.heading = heading;
			result.x = x;
			result.y = y;
			result.time = time;
			last.next = result;
			result.previous = last;
			last = result;
			return last;
		}
		double meanHeadingChange = (heading - last.heading) / (double) timeDiff;
		double deltaX, deltaY;
		deltaX = (x - last.x) / (double) timeDiff;
		deltaY = (y - last.y) / (double) timeDiff;
		for (int i = 0; i < timeDiff; i++) {
			Trace trace = new Trace();
			trace.x = last.x + deltaX;
			trace.y = last.y + deltaY;
			trace.heading = last.heading + meanHeadingChange;
			last.next = trace;
			trace.previous = last;
			last = trace;
		}
		return last;
	}
}
