package cs;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 * Talon - a robot by Chase Nano Melee bot
 * 
 * The idea is to avoid driving toward enemy robots, nearer ones are more
 * dangerous to drive towards.
 * 
 * Codesize: 243
 */
public class Talon extends AdvancedRobot {
	private static Point2D.Double[] map = new Point2D.Double[10];
	private static int n = 0, direction = 90;

	public void run() {
		setAdjustGunForRobotTurn(true);
		setAllColors(Color.RED);
		double angle, bestDanger, danger;
		while(true) {
			setAhead((bestDanger = angle = 360)*direction);
			setFire(1);
			while(angle-- > 0) {
				int t = getOthers();
				danger = 0;
				try {
					while(true) {
						// our most recent scans, unfortunately not enough room
						// to project them
						Point2D.Double v = map[--t];
						// set our gun to face this nearest enemy
						setTurnGunRight(Utils.normalRelativeAngleDegrees(v.y - getGunHeading()));
						// the difference between current angle we are
						// considering and the enemy
						// multiply it by how close they are, closer is more
						// dangerous to move towards
						danger += 1 / (Math.abs(Utils.normalRelativeAngleDegrees(angle - v.y)) + 1) * (1 / v.x);
					}
				} catch(Exception e) {
					// We don't have room for any kind of sanity checks, also
					// the only way to get out of the loop without
					// having to have a comparison, saves us some code size
				}
				if(danger < bestDanger) {
					bestDanger = danger;
					setTurnRight(Utils.normalRelativeAngleDegrees(angle + (direction - 90) - getHeading()));
				}
			}
			// Turning it by only 1 saves us some code size but in radians this
			// value > PI/4 the maximum
			// turn the radar can turn, meaning it will cover the full arc as
			// long as we call it every turn.
			turnRadarRightRadians(1);
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		try {
			// Set the most recent scan into our map of enemies
			map[--n] = new Point2D.Double(e.getDistance(), getHeading() + e.getBearing());
		}
		catch(Exception ex) {
			// attempted to scan but it failed, set the number of enemies again
			// we miss a enemy scan but we gain some code size here
			n = getOthers();
		}
	}
	
	public void onHitWall(HitWallEvent event) {
		ahead((direction = -direction)*0.22);
	}
}
