package ags.lunartwins;

import static robocode.util.Utils.normalRelativeAngle;
import robocode.*;
import ags.lunartwins.util.*;

/**
 * The base of the LunarTwins team
 * 
 * @author Alexander Schultz
 */
abstract public class LunarBase extends TeamRobot {
    public static AbsolutePoint location;
    public static final int bfheight=800, bfwidth=800;
    
    public double getFirePower() {
        double distance = currentDist();
        if (distance < 75)
            return 3.0;
        else if (distance < 400) 
            return 2.5;
        return 1.0;
    }
    public abstract double currentDist();
    
    public void run() {
        setAdjustRadarForGunTurn(true);
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForRobotTurn(true);
        
        while(true) {
            location = AbsolutePoint.fromXY(getX(), getY());
            
            AbsolutePoint target = getTarget();
            if (target != null) {
                RelativePoint rel = RelativePoint.fromPP(target, location);
                setTurnGunRightRadians(rel.getDirDist(getGunHeadingRadians()));
                setFire(getFirePower());
            }
            
            AbsolutePoint goal = getGoal();
            if (goal != null) {
                RelativePoint rel = RelativePoint.fromPP(goal, location);
                double turn = rel.getDirDist(getHeadingRadians());
                
                if (Math.abs(turn) > Math.PI/2) {
                    turn = normalRelativeAngle(turn+Math.PI);
                    setBack(rel.getMagnitude());
                } else {
                    setAhead(rel.getMagnitude());
                }
                
                //if (Math.abs(turn) > Math.PI/3)
                //    setAhead(0);
                setTurnRightRadians(turn);
            }
            
            doRadar();
            
            execute();
        }
    }
    
    private static final int ROBOT_SIZE = 18;
    public static AbsolutePoint wallAdjust(AbsolutePoint goal, AbsolutePoint target) {
        double x, y;
        
        if (target.getY() > goal.getY())
            y = target.getY() - 50;
        else
            y = target.getY() + 50;
        if (target.getX() > goal.getX())
            x = target.getX() - 50;
        else
            x = target.getX() + 50;
        
        if (Math.round(goal.getX()) > bfwidth - ROBOT_SIZE) {
            x = bfwidth - (ROBOT_SIZE+1);
        } else if (Math.round(goal.getX()) < ROBOT_SIZE) {
            x = ROBOT_SIZE+1;
        } else if (Math.round(goal.getY()) > bfheight - ROBOT_SIZE) {
            y = bfheight - (ROBOT_SIZE+1);
        } else if (Math.round(goal.getY()) < ROBOT_SIZE) {
            y = ROBOT_SIZE+1;
        } else {
            return goal;
        }
        return AbsolutePoint.fromXY(x, y);
    }
    
    /*public void onPaint(java.awt.Graphics2D g) {
        if (getGoal() == null)
            return;
        g.drawOval((int)getGoal().getX(), (int)getGoal().getY(), 3, 3);
        
        g.setColor(java.awt.Color.red);
        AbsolutePoint p = getTarget();
        g.drawOval((int)p.getX(), (int)p.getY(), 4, 4);
    }*/
    
    abstract public void doRadar();
    abstract public AbsolutePoint getGoal();
    abstract public AbsolutePoint getTarget();
}
