/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.Arena;
import amarok.AverageEventPrediction;
import amarok.BotConstants;
import amarok.BotMath;
import amarok.Enemy;
import amarok.LineCirclePrediction;
import amarok.Manager;
import amarok.SelectNearest;
import amarok.SelectOne2One;
import amarok.SittingDuckPrediction;
import amarok.Strategy;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import robocode.AdvancedRobot;

public class FireSolution
implements BotConstants,
Runnable {
    private boolean go;
    private boolean solved;
    private Arena arena;
    private Strategy selectNearest;
    private Strategy selectOne2One;
    private Manager targettingManager;
    private Strategy sittingDuckPrediction;
    private Strategy averageEventPrediction;
    private Strategy lineCirclePrediction;
    private Manager predictingManager;
    private double calculatedGunHeading;
    private double calculatedGunPower;
    private long calculatedFiringTime;
    private long calculatedEndFiringTime;
    private double vb;

    public void setGo(boolean flag) {
        this.go = flag;
    }

    public void run() {
        while (this.go) {
            if (this.solved) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            this.targettingManager.doOneTurn();
            if (this.arena.getEnemy() == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.predictingManager.doOneTurn();
        }
    }

    public boolean isSolved() {
        return this.solved;
    }

    public void setSolved(boolean flag) {
        this.solved = flag;
    }

    public double getCalculatedGunHeading() {
        return this.calculatedGunHeading;
    }

    public void setCalculatedGunHeading(double d) {
        this.calculatedGunHeading = d;
    }

    public double getCalculatedGunPower() {
        return this.calculatedGunPower;
    }

    public void setCalculatedGunPower(double d) {
        this.calculatedGunPower = d;
    }

    public long getCalculatedFiringTime() {
        return this.calculatedFiringTime;
    }

    public void setCalculatedFiringTime(long l) {
        this.calculatedFiringTime = l;
    }

    public long getCalculatedEndFiringTime() {
        return this.calculatedEndFiringTime;
    }

    public void setCalculatedEndFiringTime(long l) {
        this.calculatedEndFiringTime = l;
    }

    public void solveLineCircle(AdvancedRobot me, Enemy nme) {
        int deltaHeat = (int)(me.getGunHeat() / me.getGunCoolingRate());
        if ((long)deltaHeat > 50L) {
            return;
        }
        Point2D.Double nmeStart = nme.getPoint();
        double x = nmeStart.x;
        double y = nmeStart.y;
        double X = me.getX();
        double Y = me.getY();
        double velocity = nme.getVelocity();
        double heading = nme.getHeading();
        long time = me.getTime();
        double botDistance = 0.0;
        double firingRange = 0.0;
        double vmax = 15.5;
        int i = deltaHeat;
        while ((long)i < 50L) {
            y += velocity * (double)i * Math.cos(heading);
            if ((x += velocity * (double)i * Math.sin(heading)) < 0.0 || x > this.arena.getWidth()) {
                return;
            }
            if (y < 0.0 || x > this.arena.getHeight()) {
                return;
            }
            firingRange = vmax * (double)i;
            botDistance = BotMath.getDistance(x, y, X, Y);
            if (firingRange >= botDistance) {
                System.out.println("x|y|X|Y|heading " + x + "|" + y + "|" + X + "|" + Y + "|" + Math.toDegrees(heading));
                double dx = x - X;
                double dy = y - Y;
                System.out.println("dx|dy " + dx + "|" + dy);
                this.calculatedGunHeading = Math.asin(dx / botDistance) % Math.PI;
                System.out.println("calculatedGunHeading " + Math.toDegrees(this.calculatedGunHeading));
                if (dx < 0.0) {
                    this.calculatedGunHeading += Math.PI * 2;
                }
                System.out.println("calculatedGunHeading " + Math.toDegrees(this.calculatedGunHeading));
                double gunOffset = (me.getGunHeadingRadians() - this.calculatedGunHeading) % (Math.PI * 2);
                int deltaGun = (int)(gunOffset / BotConstants.GUN_TURN_RATE);
                if (deltaGun > i) {
                    return;
                }
                double vb = botDistance / (double)i;
                this.calculatedGunPower = (20.0 - vb) / 3.0;
                this.calculatedFiringTime = (long)i + time;
                System.out.println(time + ": solved solution: " + Math.toDegrees(this.calculatedGunHeading) + "|" + this.calculatedGunPower + " at " + this.calculatedFiringTime);
                this.setSolved(true);
                return;
            }
            ++i;
        }
    }

    public boolean testLineCircle(Line2D.Double line, double Mx, double My, double radius) {
        System.out.println(line.getX1() + "|" + line.getY1() + "|" + line.getX2() + "|" + line.getY2());
        double px = line.getX1();
        double py = line.getY1();
        double rx = line.getX2() - px;
        double ry = line.getY2() - py;
        double a = rx * rx + ry * ry;
        double b = ((px - Mx) * rx + (py - My) * ry) * 2.0;
        double c = (Mx - px) * (Mx - px) + (My - py) * (My - py) - radius * radius;
        double[] eqn = new double[]{c, b, a};
        int roots = QuadCurve2D.solveQuadratic(eqn);
        if (roots <= 0) {
            return false;
        }
        int j = 0;
        while (j <= roots) {
            double x = px + eqn[j] * rx;
            double y = py + eqn[j] * ry;
            double distance = BotMath.getDistance(Mx, My, x, y);
            double vb = distance / 50.0;
            System.out.println(x + "|" + y + "|" + distance + "|" + vb);
            if (vb > 0.1 && vb < 20.0) {
                double z = Math.sqrt(x * x + y * y);
                this.calculatedGunHeading = Math.asin(x / z) % (Math.PI * 2);
                this.calculatedGunPower = (20.0 - vb) / 3.0;
                return true;
            }
            ++j;
        }
        return false;
    }

    public FireSolution(Arena a) {
        this.arena = a;
        this.setSolved(false);
        this.setGo(false);
        this.calculatedEndFiringTime = 0L;
        this.selectNearest = new SelectNearest(this.arena);
        this.selectOne2One = new SelectOne2One(this.arena);
        this.targettingManager = new Manager();
        this.targettingManager.addStrategy(this.selectNearest);
        this.targettingManager.addStrategy(this.selectOne2One);
        this.sittingDuckPrediction = new SittingDuckPrediction(this.arena);
        this.averageEventPrediction = new AverageEventPrediction(this.arena);
        this.lineCirclePrediction = new LineCirclePrediction(this.arena);
        this.predictingManager = new Manager();
        this.predictingManager.addStrategy(this.averageEventPrediction);
        this.predictingManager.addStrategy(this.sittingDuckPrediction);
        this.predictingManager.addStrategy(this.lineCirclePrediction);
    }
}

