/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.BulletTracking;
import pa3k.GaussAimingDataStorage;
import pa3k.GaussCorrectionInfo;
import pa3k.GaussData;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import pa3k.TronAiming;
import robocode.AdvancedRobot;

public class TronAimingGaussCorrection
extends TronAiming {
    protected GaussData data;

    public TronAimingGaussCorrection(AdvancedRobot advancedRobot, String string, boolean bl) {
        super(advancedRobot, string, bl);
        this.data = GaussAimingDataStorage.getRankingBins(string);
    }

    @Override
    public BulletTracking getBestAimingAngle(Position position, Opponent opponent, Tracking tracking, double d, long l) {
        BulletTracking bulletTracking = super.getBestAimingAngle(position, opponent, tracking, d, l);
        bulletTracking.setAimingInfo(new GaussCorrectionInfo(bulletTracking));
        double d2 = this.data.getRandomCorrection() / 2.0;
        Log.log(3, "Applying random correction: " + d2);
        bulletTracking.setFiringAngle(bulletTracking.getFiringAngle() + d2);
        Log.paintLine(2, position, bulletTracking.getFiringAngle(), Color.BLACK, 0);
        return bulletTracking;
    }

    @Override
    public double[] getEscapeBins(BulletTracking bulletTracking) {
        return super.getEscapeBins(bulletTracking);
    }

    @Override
    public void dumpStats() {
        super.dumpStats();
        Log.log(1, this.data.toString());
    }

    protected void processEnemyPosition(BulletTracking bulletTracking) {
        if (this.possibleHits.size() + this.hits.size() < 15) {
            return;
        }
        GaussCorrectionInfo gaussCorrectionInfo = (GaussCorrectionInfo)bulletTracking.getAimingInfo();
        double d = bulletTracking.getFiringAngle() - gaussCorrectionInfo.getOriginalAngle();
        Log.log(3, "New difference: " + (d *= bulletTracking.getAngleAdvance() / Math.abs(bulletTracking.getAngleAdvance())));
        this.data.addPoint(d);
    }

    @Override
    public void hit(BulletTracking bulletTracking) {
        this.processEnemyPosition(bulletTracking);
        super.hit(bulletTracking);
    }

    @Override
    public void possibleHit(BulletTracking bulletTracking) {
        this.processEnemyPosition(bulletTracking);
        super.possibleHit(bulletTracking);
    }
}

