/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio.utils.structures;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import rsalesc.roborio.utils.R;
import rsalesc.roborio.utils.structures.FloatingHeap;

public abstract class KdTree<T> {
    private static int BUCKET_SIZE = 28;
    protected int dim;
    protected double[][] points;
    private Object[] data;
    private int length;
    private Integer maxLength;
    private int bucketSize;
    protected double[] min;
    protected double[] max;
    private int hyperplane;
    private double cutPosition;
    private KdTree<T> left;
    private KdTree<T> right;
    private KdTree<T> parent;
    private Queue<double[]> pointQueue;

    public KdTree(int n, Integer n2, int n3) {
        this.dim = n;
        this.bucketSize = n3;
        this.points = new double[n3][];
        this.data = new Object[n3];
        this.length = 0;
        this.maxLength = n2;
        this.pointQueue = new ArrayDeque<double[]>();
        this.parent = null;
    }

    public KdTree(int n, Integer n2) {
        this(n, n2, BUCKET_SIZE);
    }

    private KdTree(KdTree<T> kdTree) {
        this.dim = kdTree.dim;
        this.bucketSize = kdTree.bucketSize;
        this.points = new double[Math.max(this.bucketSize, kdTree.length)][];
        this.data = new Object[Math.max(this.bucketSize, kdTree.length)];
        this.length = 0;
        this.maxLength = kdTree.maxLength;
        this.parent = kdTree;
    }

    public int size() {
        return this.length;
    }

    public void add(double[] dArray, T t) {
        if (dArray.length != this.dim) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.dim; ++i) {
            if (!Double.isNaN(dArray[i])) continue;
            throw new IllegalStateException("NaN on query point");
        }
        KdTree<T> kdTree = this;
        while (!kdTree.isLeaf() || kdTree.isHeavy()) {
            if (kdTree.isLeaf()) {
                kdTree.hyperplane = this.minkowskiBestHyperplane(kdTree);
                kdTree.cutPosition = (kdTree.max[kdTree.hyperplane] + kdTree.min[kdTree.hyperplane]) / 2.0;
                if (kdTree.cutPosition == Double.POSITIVE_INFINITY) {
                    kdTree.cutPosition = Double.MAX_VALUE;
                } else if (kdTree.cutPosition == Double.NEGATIVE_INFINITY) {
                    kdTree.cutPosition = -1.7976931348623157E308;
                } else if (Double.isNaN(kdTree.cutPosition)) {
                    kdTree.cutPosition = 0.0;
                }
                if (R.isNear(kdTree.max[kdTree.hyperplane], kdTree.min[kdTree.hyperplane])) {
                    super.stretch();
                    break;
                }
                if (kdTree.cutPosition == kdTree.max[kdTree.hyperplane]) {
                    kdTree.cutPosition = kdTree.min[kdTree.hyperplane];
                }
                KdNode kdNode = new KdNode(kdTree);
                KdNode kdNode2 = new KdNode(kdTree);
                double d = 0.0;
                for (int i = 0; i < kdTree.length; ++i) {
                    d = Math.max(d, kdTree.points[i][kdTree.hyperplane]);
                    KdNode kdNode3 = kdTree.points[i][kdTree.hyperplane] <= kdTree.cutPosition ? kdNode : kdNode2;
                    super.extendNode(kdTree.points[i], kdTree.data[i]);
                }
                if (kdNode.size() == this.bucketSize) {
                    throw new IllegalStateException("left child is heavy");
                }
                if (kdNode2.size() == this.bucketSize) {
                    throw new IllegalStateException("right child is heavy");
                }
                kdTree.left = kdNode;
                kdTree.right = kdNode2;
                kdTree.points = null;
                kdTree.data = null;
            }
            kdTree.updateClippingWindow(dArray);
            ++kdTree.length;
            if (dArray[kdTree.hyperplane] <= kdTree.cutPosition) {
                kdTree = kdTree.left;
                continue;
            }
            kdTree = kdTree.right;
        }
        kdTree.extendNode(dArray, t);
        this.pointQueue.add(dArray);
        if (this.maxLength != null && this.maxLength < this.length) {
            this.remove(this.pointQueue.poll());
        }
    }

    private void stretch() {
        double[][] dArrayArray = new double[this.length * 2][];
        System.arraycopy(this.points, 0, dArrayArray, 0, this.length);
        this.points = dArrayArray;
        Object[] objectArray = new Object[this.length * 2];
        System.arraycopy(this.data, 0, objectArray, 0, this.length);
        this.data = objectArray;
    }

    private void extendNode(double[] dArray, Object object) {
        this.points[this.length] = dArray;
        this.data[this.length] = object;
        ++this.length;
        this.updateClippingWindow(dArray);
    }

    private void updateClippingWindow(double[] dArray) {
        if (this.length == 0) {
            return;
        }
        if (this.min == null || this.max == null) {
            this.min = new double[this.dim];
            System.arraycopy(dArray, 0, this.min, 0, this.dim);
            this.max = new double[this.dim];
            System.arraycopy(dArray, 0, this.max, 0, this.dim);
        } else {
            for (int i = 0; i < this.dim; ++i) {
                if (Double.isNaN(dArray[i])) {
                    this.min[i] = 0.0;
                    this.max[i] = 0.0;
                    continue;
                }
                this.min[i] = Math.min(this.min[i], dArray[i]);
                this.max[i] = Math.max(this.max[i], dArray[i]);
            }
        }
    }

    private void recomputeClippingWindow() {
        if (!this.isLeaf()) {
            throw new IllegalArgumentException("only leaf can have clipping window recomputed");
        }
        this.min = null;
        this.max = null;
        for (int i = 0; i < this.length; ++i) {
            this.updateClippingWindow(this.points[i]);
        }
    }

    public List<Entry<T>> kNN(double[] dArray, int n, double d) {
        if (dArray.length != this.dim) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.dim; ++i) {
            if (!Double.isNaN(dArray[i])) continue;
            throw new IllegalStateException("NaN on kNN point");
        }
        if (this.size() == 0) {
            return new ArrayList<Entry<T>>();
        }
        FloatingHeap.Min<KdTree<KdTree>> min = new FloatingHeap.Min<KdTree<KdTree>>();
        FloatingHeap.Max max = new FloatingHeap.Max();
        int n2 = Math.min(n, this.size());
        min.push(0.0, this);
        while (min.size() > 0 && (max.size() < n2 || min.top().key < max.top().key)) {
            this.searchTick(dArray, n2, d, min, max);
        }
        ArrayList<Entry<T>> arrayList = new ArrayList<Entry<T>>();
        while (max.size() > 0) {
            arrayList.add(new Entry(max.top().key / d, max.top().payload));
            max.pop();
        }
        return arrayList;
    }

    public List<Entry<T>> kNN(double[] dArray, int n) {
        return this.kNN(dArray, n, 1.0);
    }

    private void searchTick(double[] dArray, int n, double d, FloatingHeap.Min<KdTree<T>> min, FloatingHeap.Max<T> max) {
        KdTree<T> kdTree = (KdTree<T>)min.top().payload;
        min.pop();
        while (!kdTree.isLeaf()) {
            double d2;
            KdTree<T> kdTree2;
            KdTree<T> kdTree3;
            double d3;
            double d4 = this.minkowskiToHyperrect(dArray, kdTree.left.min, kdTree.left.max);
            if (d4 < (d3 = this.minkowskiToHyperrect(dArray, kdTree.right.min, kdTree.right.max))) {
                kdTree3 = kdTree.left;
                kdTree2 = kdTree.right;
                d2 = d3;
            } else {
                kdTree3 = kdTree.right;
                kdTree2 = kdTree.left;
                d2 = d4;
            }
            if (kdTree2.length > 0 && (max.size() < n || d2 < max.top().key)) {
                min.push(d2, kdTree2);
            }
            if (kdTree3.length == 0) {
                return;
            }
            kdTree = kdTree3;
        }
        for (int i = 0; i < kdTree.length; ++i) {
            double d5 = this.minkowskiDistance(dArray, kdTree.points[i]) * d;
            if (max.size() < n) {
                max.push(d5, kdTree.data[i]);
                continue;
            }
            if (!(max.top().key > d5)) continue;
            max.pop();
            max.push(d5, kdTree.data[i]);
        }
    }

    public void remove(double[] dArray) {
        KdTree<T> kdTree = this;
        while (!kdTree.isLeaf()) {
            if (dArray[kdTree.hyperplane] <= kdTree.cutPosition) {
                kdTree = kdTree.left;
                continue;
            }
            kdTree = kdTree.right;
        }
        for (int i = 0; i < kdTree.length; ++i) {
            if (dArray != kdTree.points[i]) continue;
            System.arraycopy(kdTree.points, i + 1, kdTree.points, i, kdTree.length - (i + 1));
            System.arraycopy(kdTree.data, i + 1, kdTree.data, i, kdTree.length - (i + 1));
            kdTree.points[kdTree.length - 1] = null;
            kdTree.data[kdTree.length - 1] = null;
            KdTree<T> kdTree2 = kdTree;
            while (kdTree != null) {
                --kdTree.length;
                kdTree = kdTree.parent;
            }
            super.recomputeClippingWindow();
            return;
        }
        throw new IllegalStateException("point was not found");
    }

    private boolean isLeaf() {
        return this.data != null;
    }

    private boolean isHeavy() {
        return this.length >= this.data.length;
    }

    public abstract int minkowskiBestHyperplane(KdTree<T> var1);

    public abstract double minkowskiDistance(double[] var1, double[] var2);

    public abstract double minkowskiToHyperrect(double[] var1, double[] var2, double[] var3);

    public static class Entry<T> {
        public final double distance;
        public final T payload;

        public Entry(double d, T t) {
            this.distance = d;
            this.payload = t;
        }
    }

    private class KdNode
    extends KdTree<T> {
        private KdNode(KdTree<T> kdTree2) {
            super(kdTree2);
        }

        @Override
        public int minkowskiBestHyperplane(KdTree<T> kdTree) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double minkowskiDistance(double[] dArray, double[] dArray2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double minkowskiToHyperrect(double[] dArray, double[] dArray2, double[] dArray3) {
            throw new UnsupportedOperationException();
        }
    }
}

