/*
 * Decompiled with CFR 0.152.
 */
package mb.guns;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import mb.MBRobot;
import mb.core.Coordinates;
import mb.guns.Gun;
import mb.utils.CoordinatesUtils;
import mb.utils.MathUtils;
import mb.waves.Segments;
import mb.waves.Wave;
import mb.waves.WaveStorage;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.GunTurnCompleteCondition;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class LinearTargetingGunExperimental
extends Gun {
    private WaveStorage waveStorage;

    public LinearTargetingGunExperimental(MBRobot me) {
        super(me);
        this.waveStorage = new WaveStorage(me);
    }

    @Override
    public void fire(ScannedRobotEvent event) {
        double bulletPower = this.getBulletPowerFromScannedDistance(event);
        Coordinates myCoords = this.getMyCoordinates();
        Coordinates enemyCoordinates = MathUtils.getEnemyCoordinates(myCoords, this.getHeading(), event.getBearing(), event.getDistance());
        Segments segment = new Segments();
        segment.heading = this.getRobot().getGunHeading();
        segment.distance = event.getDistance();
        segment.velocity = event.getVelocity();
        Wave wave = new Wave(0L, bulletPower, myCoords, enemyCoordinates, segment, this.getGunHeading());
        Coordinates future = enemyCoordinates;
        int i = 1;
        while (i < 100) {
            future = this.getFutureRobotCoordinates(event, i);
            if (wave.checkHit(future, i)) break;
            ++i;
        }
        Coordinates futureRobotCoordinates = future;
        this.paintOriginal(futureRobotCoordinates);
        List<Coordinates> diffVectors = this.waveStorage.getDiffVectors(event, this.getRobot());
        Coordinates diff = this.getDiffVector(diffVectors, futureRobotCoordinates);
        futureRobotCoordinates.Add(diff);
        double angleGun = this.getGunBearingToCoordinates(futureRobotCoordinates);
        angleGun = this.adjustToMaxEscapeAngle(bulletPower, angleGun);
        this.setTurnGunRight(angleGun);
        if (this.getGunHeat() == 0.0) {
            this.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this.getRobot()));
            this.setFire(bulletPower);
        } else {
            this.setTurnGunRight(this.getGunBearingToCoordinates(enemyCoordinates));
        }
        this.waveStorage.newWave(this.getTime(), bulletPower, new Coordinates(this.getX(), this.getY()), futureRobotCoordinates, event, this.getRobot());
        this.paintDiffs(futureRobotCoordinates, diffVectors);
    }

    private double adjustToMaxEscapeAngle(double bulletPower, double angleGun) {
        double maxEscapeAngle = Math.toDegrees(Math.asin(8.0 / Rules.getBulletSpeed((double)bulletPower)));
        if (angleGun > 0.0 && angleGun > maxEscapeAngle) {
            angleGun = maxEscapeAngle;
        } else if (angleGun < 0.0 && angleGun < -maxEscapeAngle) {
            angleGun = -maxEscapeAngle;
        }
        return angleGun;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        Coordinates enemyCoords = MathUtils.getEnemyCoordinates(this.getMyCoordinates(), this.getHeading(), event.getBearing(), event.getDistance());
        this.waveStorage.checkWaves(enemyCoords, this.getTime());
        super.onScannedRobot(event);
    }

    @Override
    protected double getBulletPowerFromScannedDistance(ScannedRobotEvent event) {
        double bulletPower = super.getBulletPowerFromScannedDistance(event);
        double hitHitByRatio = this.getRobot().getBattleStatistics().getHitHitByRatio();
        if (bulletPower < 3.0 && hitHitByRatio > 1.2) {
            bulletPower = Math.min(3.0, bulletPower * hitHitByRatio * hitHitByRatio);
        }
        return super.getBulletPowerFromScannedDistance(event);
    }

    private double getGunBearingToCoordinates(Coordinates coord) {
        double x = this.getX() - coord.getX();
        double y = this.getY() - coord.getY();
        double angle = Math.toDegrees(Math.atan(y / x));
        angle = Math.signum(-x) * 90.0 - this.getGunHeading() - angle;
        if (Math.abs(angle) > 180.0) {
            angle = 360.0 - Math.abs(angle);
        }
        return angle;
    }

    private Coordinates getFutureRobotCoordinates(ScannedRobotEvent event, double time) {
        Coordinates enemy = MathUtils.getEnemyCoordinates(this.getMyCoordinates(), this.getHeading(), event.getBearing(), event.getDistance());
        enemy.xmax = this.battleFieldWidth;
        enemy.ymax = this.battleFieldHeight;
        double a2 = Math.toRadians(event.getHeading() % 360.0);
        double movedx = Math.sin(a2) * event.getVelocity() * time;
        double movedy = Math.cos(a2) * event.getVelocity() * time;
        Coordinates moved = new Coordinates(movedx, movedy);
        enemy.Add(moved);
        return enemy;
    }

    private void paintDiffs(Coordinates target, List<Coordinates> formerDiffs) {
        Graphics2D graphics = this.getRobot().getGraphics();
        graphics.setColor(Color.BLUE);
        graphics.fillOval((int)target.getX(), (int)target.getY(), 6, 6);
        graphics.setColor(Color.magenta);
        for (Coordinates diff : formerDiffs) {
            graphics.fillOval((int)(target.getX() + diff.getX()), (int)(target.getY() + diff.getY()), 4, 4);
        }
    }

    private void paintOriginal(Coordinates target) {
        Graphics2D graphics = this.getRobot().getGraphics();
        graphics.setColor(Color.yellow);
        graphics.fillOval((int)target.getX(), (int)target.getY(), 6, 6);
    }

    private Coordinates getDiffVector(List<Coordinates> diffVectors, Coordinates original) {
        if (diffVectors.size() < 5) {
            return new Coordinates(0.0, 0.0);
        }
        int maxNearestVectors = 0;
        int center = 0;
        int i = 0;
        while (i < diffVectors.size()) {
            int currentNearestVectors = 0;
            int j = 0;
            while (j < diffVectors.size()) {
                Coordinates point2;
                Coordinates point1;
                if (i != j && MathUtils.getDistance(point1 = CoordinatesUtils.addVectors(original, diffVectors.get(i)), point2 = CoordinatesUtils.addVectors(original, diffVectors.get(j))) < 18.0) {
                    ++currentNearestVectors;
                }
                ++j;
            }
            if (currentNearestVectors > maxNearestVectors) {
                center = i;
                maxNearestVectors = currentNearestVectors;
            }
            ++i;
        }
        if (maxNearestVectors < 5) {
            return new Coordinates(0.0, 0.0);
        }
        return diffVectors.get(center);
    }
}

