/*
 * Decompiled with CFR 0.152.
 */
package synnalagma;

import synnalagma.Point;
import synnalagma.RobotBase;
import synnalagma.RobotMath;

public class AntiGravity {
    public static double OPTIMAL_DISTANCE = 299.9;
    public static final double WALL_FACTOR = 5000.0;
    public static final double CENTER_FACTOR = -5000.0;
    public static final int WALL_POW = 2;
    public static final int CENTER_POW = 3;
    public static final int OTHER_POW = 2;
    public double turnAngle = 0.0;
    public Point totalForce = new Point();
    boolean turnPolicy = false;
    public int direction = 1;
    public int lastDirection = 1;

    public void add(Point point) {
        double d;
        double d2 = RobotBase.monRobot.getX();
        double d3 = point.distance(d2, d = RobotBase.monRobot.getY());
        this.turnPolicy |= d3 < 40.0;
        double d4 = point.getForce() / Math.pow(d3, 2.0);
        double d5 = RobotMath.NormaliseBearing(1.5707963267948966 - Math.atan2(d - point.y, d2 - point.x));
        this.totalForce.x += Math.sin(d5) * d4;
        this.totalForce.y += Math.cos(d5) * d4;
    }

    public void add(double d, double d2, double d3) {
        double d4 = RobotBase.monRobot.getX();
        double d5 = RobotBase.monRobot.getY();
        double d6 = d3 / Math.pow(RobotMath.distance(d4, d5, d, d2), 2.0);
        double d7 = RobotMath.NormaliseBearing(1.5707963267948966 - Math.atan2(d5 - d2, d4 - d));
        this.totalForce.x += Math.sin(d7) * d6;
        this.totalForce.y += Math.cos(d7) * d6;
    }

    public void add(Point point, double d) {
        double d2 = RobotBase.monRobot.getX();
        double d3 = RobotBase.monRobot.getY();
        double d4 = d / Math.pow(point.distance(d2, d3), 2.0);
        double d5 = RobotMath.NormaliseBearing(1.5707963267948966 - Math.atan2(d3 - point.y, d2 - point.x));
        this.totalForce.x += Math.sin(d5) * d4;
        this.totalForce.y += Math.cos(d5) * d4;
    }

    public void calcul(boolean bl) {
        this.turnPolicy |= bl;
        double d = RobotBase.monRobot.getX();
        double d2 = RobotBase.monRobot.getY();
        this.totalForce.x = d - this.totalForce.x;
        this.totalForce.y = d2 - this.totalForce.y;
        this.turnAngle = RobotMath.absbearing(d, d2, this.totalForce.x, this.totalForce.y);
        this.turnTo();
        this.totalForce.force = this.totalForce.distance(0.0, 0.0);
    }

    public void initialize(boolean bl, boolean bl2) {
        double d;
        double d2 = RobotBase.monRobot.getX();
        double d3 = RobotBase.monRobot.getY();
        this.totalForce = new Point();
        if (bl2) {
            d = RobotBase.monRobot.myGetBattleFieldWidth() - d2;
            this.turnPolicy |= d < 40.0;
            this.totalForce.x += 5000.0 / Math.pow(d, 2.0);
            d = d2;
            this.turnPolicy |= d < 40.0;
            this.totalForce.x -= 5000.0 / Math.pow(d, 2.0);
            d = RobotBase.monRobot.myGetBattleFieldHeight() - d3;
            this.turnPolicy |= d < 40.0;
            this.totalForce.y += 5000.0 / Math.pow(d, 2.0);
            d = d3;
            this.turnPolicy |= d < 40.0;
            this.totalForce.y -= 5000.0 / Math.pow(d, 2.0);
        }
        if (bl) {
            d = -5000.0 / Math.pow(RobotMath.distance(d2, d3, RobotBase.monRobot.myGetBattleFieldWidth() / 2.0, RobotBase.monRobot.myGetBattleFieldHeight() / 2.0), 3.0);
            double d4 = RobotMath.NormaliseBearing(1.5707963267948966 - Math.atan2(d3 - RobotBase.monRobot.myGetBattleFieldHeight() / 2.0, d2 - RobotBase.monRobot.myGetBattleFieldWidth() / 2.0));
            this.totalForce.x += Math.sin(d4) * d;
            this.totalForce.y += Math.cos(d4) * d;
        }
    }

    public void turnTo() {
        this.turnAngle = RobotMath.NormaliseBearing(RobotBase.monRobot.getHeadingRadians() - this.turnAngle);
        double d = this.turnAngle;
        if (d > 1.5707963267948966) {
            d -= Math.PI;
            this.direction = -1;
        } else if (d < -1.5707963267948966) {
            d += Math.PI;
            this.direction = -1;
        } else {
            this.direction = 1;
        }
        if (this.turnPolicy || this.lastDirection == this.direction) {
            this.turnAngle = d;
            this.lastDirection = this.direction;
        } else {
            this.direction = this.lastDirection;
        }
    }
}

