/*
 * Decompiled with CFR 0.152.
 */
package rjw.util;

import java.util.ArrayList;

public class DecayBins {
    private int _binCount;
    private int _decayLength;
    private double[] _decayArray;
    private double _decaySum;
    private BinPut[][] _history;
    private int _defaultBin;
    private int _next;
    private int _size;
    private transient ArrayList<BinPut> _binPuts;
    private transient double[] _bins = null;
    private transient int _minBindex;
    private transient int _maxBindex;

    public DecayBins(int binCount, int decayLength) {
        this(binCount, decayLength, (binCount + 1) / 2);
    }

    public DecayBins(int binCount, int decayLength, int defaultBin) {
        this._binCount = binCount;
        this._binPuts = new ArrayList();
        this._decayLength = decayLength;
        this._decayArray = DecayBins.cosineCurve(this._decayLength);
        this._history = new BinPut[decayLength][];
        this._defaultBin = defaultBin;
        this._minBindex = defaultBin;
        this._maxBindex = defaultBin;
        double[] dArray = this._decayArray;
        int n = this._decayArray.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            this._decaySum += value;
            ++n2;
        }
    }

    public void put(int bindex) {
        this._binPuts.add(new BinPut(bindex, false));
    }

    public void put(int bindex, boolean decrement) {
        this._binPuts.add(new BinPut(bindex, decrement));
    }

    public void endTick() {
        if (this._size != this._decayLength) {
            ++this._size;
        }
        this._history[this._next] = this._binPuts.toArray(new BinPut[this._binPuts.size()]);
        this._next = (this._next + 1) % this._decayLength;
        this._binPuts = new ArrayList();
        this.clearCache();
    }

    public int size() {
        return this._size;
    }

    public int maxBindex() {
        this.buildCache();
        return this._maxBindex;
    }

    public int minBindex() {
        this.buildCache();
        return this._minBindex;
    }

    public double maxPossibleValue() {
        if (this._size == this._decayLength) {
            return this._decaySum;
        }
        double sum = 0.0;
        int i = 0;
        while (i < this._size) {
            sum += this._decayArray[i];
            ++i;
        }
        return sum;
    }

    public double bin(int bindex) {
        this.buildCache();
        return this._bins[bindex];
    }

    public double[] bins() {
        this.buildCache();
        return this._bins;
    }

    private void buildCache() {
        if (this._bins != null) {
            return;
        }
        this._bins = new double[this._binCount];
        int i = 0;
        while (i < this._size) {
            int j = this._next - i - 1;
            if (j < 0) {
                j += this._decayLength;
            }
            BinPut[] binPutArray = this._history[j];
            int n = binPutArray.length;
            int n2 = 0;
            while (n2 < n) {
                BinPut binPut = binPutArray[n2];
                int n3 = binPut._bindex;
                this._bins[n3] = this._bins[n3] + (double)(binPut._decrement ? -1 : 1) * this._decayArray[i];
                if (this._bins[binPut._bindex] > this._bins[this._maxBindex]) {
                    this._maxBindex = binPut._bindex;
                }
                if (this._bins[binPut._bindex] < this._bins[this._minBindex]) {
                    this._minBindex = binPut._bindex;
                }
                ++n2;
            }
            ++i;
        }
    }

    private void clearCache() {
        this._bins = null;
        this._minBindex = this._defaultBin;
        this._maxBindex = this._defaultBin;
    }

    private static double[] cosineCurve(int length) {
        double[] values = new double[length];
        int i = 0;
        while (i < length) {
            values[i] = Math.cos((double)i / (double)length * 1.5707963267948966);
            ++i;
        }
        return values;
    }

    private class BinPut {
        protected int _bindex;
        protected boolean _decrement;

        protected BinPut(int bindex, boolean decrement) {
            this._bindex = bindex;
            this._decrement = decrement;
        }
    }
}

