/*
 * Decompiled with CFR 0.152.
 */
package rjw.util;

import rjw.pluggablerobot.Math2;
import rjw.util.DecayBins;
import robocode.util.Utils;

public class GuessFactor {
    private int _binCount;
    private DecayBins _bins;
    private int _curBin;

    public GuessFactor(int binCount, int decayLength) {
        this._binCount = binCount;
        this._bins = new DecayBins(binCount, decayLength);
        this._curBin = 0;
    }

    public void visit(double guessFactor) {
        this._curBin = (int)Math.floor((guessFactor + 1.0) / 2.0 * (double)this._binCount);
        if (this._curBin == this._binCount) {
            --this._curBin;
        }
        this._bins.put(this._curBin);
        this._bins.endTick();
    }

    public boolean hasData() {
        return this._bins.size() > 0;
    }

    public double fireHeading(double targetBearing, double targetDirection, double power) {
        double guessFactor = (double)this._bins.maxBindex() / (double)(this._binCount - 1) * 2.0 - 1.0;
        double angleOffset = guessFactor * Math2.maxEscapeAngle(power) * targetDirection;
        return Utils.normalAbsoluteAngle((double)(targetBearing + angleOffset));
    }

    public double[] bins() {
        return this._bins.bins();
    }
}

