/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

import DM.mega.Polygon2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

class Polyline2D
implements Shape,
Cloneable,
Serializable {
    private static final float ASSUME_ZERO = 0.001f;
    public int npoints;
    public double[] xpoints;
    public double[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath path;
    private GeneralPath closedPath;

    public Polyline2D() {
        this.xpoints = new double[4];
        this.ypoints = new double[4];
    }

    public Polyline2D(double[] dArray, double[] dArray2, int n) {
        if (n > dArray.length || n > dArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n;
        this.xpoints = new double[n + 1];
        this.ypoints = new double[n + 1];
        System.arraycopy(dArray, 0, this.xpoints, 0, n);
        System.arraycopy(dArray2, 0, this.ypoints, 0, n);
        this.calculatePath();
    }

    public Polyline2D(int[] nArray, int[] nArray2, int n) {
        if (n > nArray.length || n > nArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n;
        this.xpoints = new double[n];
        this.ypoints = new double[n];
        for (int i = 0; i < n; ++i) {
            this.xpoints[i] = nArray[i];
            this.ypoints[i] = nArray2[i];
        }
        this.calculatePath();
    }

    public Polyline2D(Line2D line2D) {
        this.npoints = 2;
        this.xpoints = new double[2];
        this.ypoints = new double[2];
        this.xpoints[0] = line2D.getX1();
        this.xpoints[1] = line2D.getX2();
        this.ypoints[0] = line2D.getY1();
        this.ypoints[1] = line2D.getY2();
        this.calculatePath();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.path = new GeneralPath();
        this.closedPath = null;
    }

    public Object clone() {
        Polyline2D polyline2D = new Polyline2D();
        for (int i = 0; i < this.npoints; ++i) {
            polyline2D.addPoint(this.xpoints[i], this.ypoints[i]);
        }
        return polyline2D;
    }

    private void calculatePath() {
        this.path = new GeneralPath();
        this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i = 1; i < this.npoints; ++i) {
            this.path.lineTo(this.xpoints[i], this.ypoints[i]);
        }
        this.bounds = this.path.getBounds2D();
        this.closedPath = null;
    }

    private void updatePath(double d, double d2) {
        this.closedPath = null;
        if (this.path == null) {
            this.path = new GeneralPath(0);
            this.path.moveTo(d, d2);
            this.bounds = new Rectangle2D.Double(d, d2, 0.0, 0.0);
        } else {
            this.path.lineTo(d, d2);
            double d3 = this.bounds.getMaxX();
            double d4 = this.bounds.getMaxY();
            double d5 = this.bounds.getMinX();
            double d6 = this.bounds.getMinY();
            if (d < d5) {
                d5 = d;
            } else if (d > d3) {
                d3 = d;
            }
            if (d2 < d6) {
                d6 = d2;
            } else if (d2 > d4) {
                d4 = d2;
            }
            this.bounds = new Rectangle2D.Double(d5, d6, d3 - d5, d4 - d6);
        }
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void addPoint(double d, double d2) {
        if (this.npoints == this.xpoints.length) {
            double[] dArray = new double[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
            this.xpoints = dArray;
            dArray = new double[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, dArray, 0, this.npoints);
            this.ypoints = dArray;
        }
        this.xpoints[this.npoints] = d;
        this.ypoints[this.npoints] = d2;
        ++this.npoints;
        this.updatePath(d, d2);
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    private void updateComputingPath() {
        if (this.npoints >= 1 && this.closedPath == null) {
            this.closedPath = (GeneralPath)this.path.clone();
            this.closedPath.closePath();
        }
    }

    public boolean contains(Point point) {
        return false;
    }

    @Override
    public boolean contains(double d, double d2) {
        return false;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return false;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.npoints <= 0 || !this.bounds.intersects(d, d2, d3, d4)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.intersects(d, d2, d3, d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (this.path == null) {
            return null;
        }
        return this.path.getPathIterator(affineTransform);
    }

    public Polygon2D getPolygon2D() {
        Polygon2D polygon2D = new Polygon2D();
        for (int i = 0; i < this.npoints - 1; ++i) {
            polygon2D.addPoint(this.xpoints[i], this.ypoints[i]);
        }
        Point2D.Double double_ = new Point2D.Double(this.xpoints[0], this.ypoints[0]);
        Point2D.Double double_2 = new Point2D.Double(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        if (double_.distance(double_2) > (double)0.001f) {
            polygon2D.addPoint(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        }
        return polygon2D;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.path.getPathIterator(affineTransform);
    }
}

