/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Units {
    public static <T extends Continuum<T>> double sign(T t) {
        double result = Math.signum(t.toDouble());
        result = result == 0.0 ? 1.0 : result;
        return result;
    }

    public static <T extends Continuum<T>> double signum(T t) {
        return Math.signum(t.toDouble());
    }

    public static <T extends Continuum<T>> T min(T t1, T t2) {
        return t1.toDouble() < t2.toDouble() ? t1 : t2;
    }

    public static <T extends Continuum<T>> T max(T t1, T t2) {
        return t1.toDouble() > t2.toDouble() ? t1 : t2;
    }

    public static <T extends Continuum<T>> boolean less(T t1, T t2) {
        return t1.toDouble() < t2.toDouble();
    }

    public static <T extends Continuum<T>> boolean lessOrEqual(T t1, T t2) {
        return t1.toDouble() <= t2.toDouble();
    }

    public static <T extends Continuum<T>> boolean greater(T t1, T t2) {
        return !Units.lessOrEqual(t1, t2);
    }

    public static <T extends Continuum<T>> boolean greaterOrEqual(T t1, T t2) {
        return !Units.less(t1, t2);
    }

    public static <A extends AbsoluteToRelative<A, R>, R> R minusWithNulls(A a1, A a2) {
        if (a1 == null || a2 == null) {
            return null;
        }
        return a1.minus(a2);
    }

    public static <A extends AbsoluteToRelative<A, R>, R> A plusWithNulls(A a, R r) {
        if (a == null) {
            return null;
        }
        if (r == null) {
            return a;
        }
        return (A)((AbsoluteToRelative)a.plus(r));
    }
}

