/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.ooplace;

import org.la4j.Matrix;
import org.la4j.iterator.MatrixIterator;
import org.la4j.iterator.RowMajorMatrixIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.matrix.SparseMatrix;
import org.la4j.operation.SymmetricMatrixMatrixOperation;

public class OoPlaceMatrixHadamardProduct
extends SymmetricMatrixMatrixOperation<Matrix> {
    @Override
    public Matrix applySymmetric(DenseMatrix a, SparseMatrix b) {
        Matrix result = b.blank();
        MatrixIterator it = b.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(i, j, a.get(i, j) * x);
        }
        return result;
    }

    @Override
    public Matrix applySymmetric(SparseMatrix a, SparseMatrix b) {
        Matrix result = a.blank();
        MatrixIterator these = a.nonZeroIterator();
        MatrixIterator those = b.nonZeroIterator();
        MatrixIterator both = these.andAlsoMultiply(those);
        while (both.hasNext()) {
            double x = (Double)both.next();
            int i = both.rowIndex();
            int j = both.columnIndex();
            result.set(i, j, x);
        }
        return result;
    }

    @Override
    public Matrix applySymmetric(RowMajorSparseMatrix a, ColumnMajorSparseMatrix b) {
        Matrix result = a.blank();
        RowMajorMatrixIterator these = a.nonZeroRowMajorIterator();
        RowMajorMatrixIterator those = b.nonZeroRowMajorIterator();
        MatrixIterator both = these.andAlsoMultiply(those);
        while (both.hasNext()) {
            double x = (Double)both.next();
            int i = both.rowIndex();
            int j = both.columnIndex();
            result.set(i, j, x);
        }
        return result;
    }

    @Override
    public Matrix apply(DenseMatrix a, DenseMatrix b) {
        Matrix result = a.blank();
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                result.set(i, j, a.get(i, j) * b.get(i, j));
            }
        }
        return result;
    }

    @Override
    public void ensureApplicableTo(Matrix a, Matrix b) {
        if (a.rows() != b.rows() || a.columns() != b.columns()) {
            throw new IllegalArgumentException("Given matrices should have the same shape: " + a.rows() + "x" + a.columns() + " does not equal to " + b.rows() + "x" + b.columns() + ".");
        }
    }
}

