/*
 * Decompiled with CFR 0.152.
 */
package dk;

import dk.BattleField;
import dk.Enemy;
import dk.EnemyController;
import dk.Point;
import dk.StartOfTurnCondition;
import dk.TacticController;
import dk.Util;
import dk.Vector;
import dk.config.Config;
import java.awt.Color;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public abstract class Base
extends AdvancedRobot {
    public boolean debug = false;
    public boolean printStats = true;
    public boolean dumpToFile = true;
    public static boolean traceFire = false;
    public static boolean traceHits = false;
    public static boolean dumpPrediction = true;
    public static final double RATE_GUN_TURN = Util.toRadians(20.0);
    public static final double RATE_RADAR_TURN = Util.toRadians(45.0);
    public static final int ROBOT_SIZE = 18;
    public static final double MAX_VELOCITY = 8.0;
    public static final double MAX_TURN_RATE = Util.toRadians(10.0);
    private transient double velocity;
    private transient double heading;
    private transient double headingChange;
    private transient double acceleration;
    private transient double decayRate = Util.halfLifeDecayRate(4L);
    private transient double averageHeading;
    private transient double averageVelocity;
    private transient double averageAcceleration;
    private transient double averageHeadingChange;
    protected int survivalScore = 0;
    protected int bulletDamageScore = 0;
    protected int bulletDamageBonus = 0;
    protected int ramDamageScore = 0;
    protected int ramDamageBonus = 0;
    protected int lastSurvivorBonus = 0;
    protected int damageTakenScore = 0;
    public Config config;
    public TacticController tactics;
    protected Enemy target = null;
    protected int totalHitCount = 0;
    protected int wallHitCount = 0;
    protected int skippedTurnCount = 0;
    protected int shotsFired = 0;
    protected int shotsHit = 0;
    protected int totalRobotCount;

    public Base() {
        BattleField bf = BattleField.sharedInstance();
        bf.setRobot(this);
    }

    public Point getPosition() {
        return new Point(this.getX(), this.getY());
    }

    public Vector getMovementVector() {
        return new Vector(this.getHeadingRadians(), this.getVelocity());
    }

    public Point getEstimatedPosition(long time) {
        return Util.applyHeading(this.getPosition(), this.getHeadingRadians(), (double)(time - this.getTime()) * this.getVelocity());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.getEnemyController().onRobotScannedEvent(this, e);
        if (this.tactics != null) {
            this.tactics.onScannedRobot(this, e);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.survivalScore += 50;
        this.getEnemyController().onRobotDeathEvent(this, e);
        if (this.tactics != null) {
            this.tactics.onRobotDeath(this, e);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        ++this.totalHitCount;
        this.getEnemyController().onHitByBullet(this, e);
        if (this.tactics != null) {
            this.tactics.onHitByBullet(this, e);
        }
        this.damageTakenScore = (int)((double)this.damageTakenScore + Util.bulletDamage(e.getBullet().getPower()));
    }

    public void onBulletHit(BulletHitEvent e) {
        this.getEnemyController().onBulletHit(this, e);
        ++this.shotsHit;
        this.bulletDamageScore = (int)((double)this.bulletDamageScore + Util.bulletDamage(e.getBullet().getPower()));
        Enemy enemy = this.getEnemyController().getEnemy(e.getName());
        if (!enemy.isAlive()) {
            this.bulletDamageBonus = (int)((double)this.bulletDamageBonus + enemy.getDamaged() * 0.2);
        }
    }

    public void onWin(WinEvent e) {
        this.lastSurvivorBonus += this.totalRobotCount * 10;
        if (this.tactics != null) {
            this.tactics.onWin(this, e);
        }
        this.doEndOfRound();
    }

    public void onDeath(DeathEvent e) {
        if (this.tactics != null) {
            this.tactics.onDeath(this, e);
        }
        this.doEndOfRound();
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.tactics != null) {
            this.tactics.onHitRobot(this, e);
        }
    }

    public void onHitWall(HitWallEvent e) {
        ++this.wallHitCount;
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++this.skippedTurnCount;
    }

    public void onEnemyBulletFired(Enemy e, double power) {
        if (this.tactics != null) {
            this.tactics.onEnemyBulletFired(this, e, power);
        }
        if (this.config != null) {
            this.config.onEnemyBulletFired(this, e, power);
        }
        if (traceHits) {
            ((Robot)this).out.println("enemy " + e.getName() + " fired " + power);
        }
    }

    public int getTotalRobotCount() {
        return this.totalRobotCount;
    }

    public int getScoreThisRound() {
        return this.bulletDamageScore + this.bulletDamageBonus + this.survivalScore + this.lastSurvivorBonus + this.ramDamageScore + this.ramDamageBonus;
    }

    public int getPenaltyThisRound() {
        return this.damageTakenScore;
    }

    public EnemyController getEnemyController() {
        return BattleField.enemyController;
    }

    public void setConfig(Config c) {
        this.config = c;
    }

    public void setTactics(TacticController controller) {
        this.tactics = controller;
    }

    public int getTotalHitCount() {
        return this.totalHitCount;
    }

    public Enemy getTarget() {
        return this.target;
    }

    public void setTarget(Enemy enemy) {
        this.target = enemy;
        if (this.config != null) {
            this.config.setTarget(enemy);
        }
    }

    public Bullet setFireBullet(double power) {
        if (this.getGunHeat() == 0.0) {
            ++this.shotsFired;
            if (this.target != null) {
                this.target.countFireAttempt();
            }
            return super.setFireBullet(power);
        }
        return null;
    }

    public void setFire(double power) {
        this.setFireBullet(power);
    }

    public void reset() {
        this.target = null;
        this.totalRobotCount = this.getOthers();
        this.setColors(Color.WHITE, Color.WHITE, Color.YELLOW);
        this.getEnemyController().reset();
        this.addCustomEvent(new StartOfTurnCondition(this));
    }

    public void run() {
        this.reset();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.doStartRound();
        while (true) {
            this.doTurn();
            this.execute();
        }
    }

    public void doStartRound() {
        this.tactics.doStartRound(this);
    }

    public void doStartTurn() {
        this.acceleration = this.getVelocity() - this.velocity;
        this.headingChange = Util.normalizeBearing(this.getHeadingRadians() - this.heading);
        this.heading = this.getHeadingRadians();
        this.velocity = this.getVelocity();
        this.averageHeading = Util.timeWeightedAverage(this.heading, this.averageHeading, 1L, this.decayRate);
        this.averageVelocity = Util.timeWeightedAverage(this.velocity, this.averageVelocity, 1L, this.decayRate);
        this.averageAcceleration = Util.timeWeightedAverage(this.acceleration, this.averageAcceleration, 1L, this.decayRate);
        this.averageHeadingChange = Util.timeWeightedAverage(this.headingChange, this.averageHeadingChange, 1L, this.decayRate);
    }

    public void doTurn() {
        this.tactics.doTurn(this);
    }

    public void doEndOfRound() {
        if (this.printStats) {
            PrintStream stream = ((Robot)this).out;
            if (this.dumpToFile) {
                try {
                    File file = this.getDataFile("stats.txt");
                    stream = new PrintStream((OutputStream)new RobocodeFileOutputStream(file));
                    ((Robot)this).out.println("writing stats to " + file.getPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getEnemyController().printStats(stream);
            stream.println("---------------");
            this.printStats(stream);
            if (stream != ((Robot)this).out) {
                stream.close();
                this.printStats(((Robot)this).out);
            }
        }
    }

    public void printStats(PrintStream stream) {
        stream.println("hit by others = " + this.totalHitCount);
        stream.println("shots fired = " + this.shotsFired);
        if (this.wallHitCount > 0) {
            stream.println("walls hit = " + this.wallHitCount);
        }
        if (this.skippedTurnCount > 0) {
            stream.println("skipped turns = " + this.skippedTurnCount);
        }
        double percentage = 0.0;
        if (this.shotsFired > 0) {
            percentage = (double)this.shotsHit / (double)this.shotsFired;
        }
        stream.println("shots hit = " + this.shotsHit + " (" + percentage + ")");
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getAverageAcceleration() {
        return this.averageAcceleration;
    }

    public double getAverageHeading() {
        return this.averageHeading;
    }

    public double getAverageHeadingChange() {
        return this.averageHeadingChange;
    }

    public double getAverageVelocity() {
        return this.averageVelocity;
    }

    public double getHeadingChange() {
        return this.headingChange;
    }
}

