/*
 * Decompiled with CFR 0.152.
 */
package de.erdega.robocode;

import de.erdega.robocode.base.AbstractChassis;
import de.erdega.robocode.base.AnalyzedScannedRobotEvent;
import de.erdega.robocode.util.Vector;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.util.Utils;

public class DuckAndCover
extends AbstractChassis {
    private final AdvancedRobot _robot;
    private final double FIELD_WIDTH;
    private final double FIELD_HEIGHT;
    private final Vector MIDDLE;
    private double MIN_ENEMY_DIST = 200.0;
    private double MAX_ENEMY_DIST = 450.0;
    private double ROBOT_SIZE;
    private double HALF_ROBOT_SIZE;
    private double SECURE_WALL_DISTANCE;
    private double _previousEnemyEnergy = -1.0;
    private boolean _moveAhead = false;

    public DuckAndCover(AdvancedRobot robot) {
        this._robot = robot;
        double robotWith = this._robot.getWidth();
        double robotHeight = this._robot.getHeight();
        this.ROBOT_SIZE = Math.sqrt(robotWith * robotWith + robotHeight * robotHeight);
        this.HALF_ROBOT_SIZE = this.ROBOT_SIZE / 2.0;
        this.SECURE_WALL_DISTANCE = this.HALF_ROBOT_SIZE + 20.0;
        this.FIELD_WIDTH = this._robot.getBattleFieldWidth();
        this.FIELD_HEIGHT = this._robot.getBattleFieldHeight();
        this.MIDDLE = new Vector(this.FIELD_WIDTH / 2.0, this.FIELD_HEIGHT / 2.0);
    }

    public void handleScannedRobotEvent(AnalyzedScannedRobotEvent event) {
        double distPos;
        double relDistPost;
        double distScale;
        Vector correction;
        Vector newMovingDir;
        Vector newRelativeTargetPos;
        Vector targetPos;
        if (this._previousEnemyEnergy < 0.0) {
            this._previousEnemyEnergy = event.getEnemyEnergy();
        }
        if (Math.abs(this._robot.getDistanceRemaining()) < 20.0) {
            this._moveAhead = !this._moveAhead;
            double newDist = 50.0 + Math.random() * 200.0;
            if (this._moveAhead) {
                this._robot.setAhead(newDist);
            } else {
                this._robot.setBack(newDist);
            }
        }
        Vector movingDir = Vector.createPolarVector(this._robot.getDistanceRemaining(), this._robot.getHeadingRadians()).getUnit();
        Vector bearing = event.getEnemyBearing();
        Vector bearingDir = bearing.getUnit();
        Vector preferredDir = Vector.createPolarVector(1.0, bearing.getPhi() + 1.5707963267948966);
        if (preferredDir.dotProduct(movingDir) < 0.0) {
            preferredDir = preferredDir.scale(-1.0);
        }
        if ((targetPos = (newRelativeTargetPos = (newMovingDir = preferredDir.add(correction = bearingDir.scale(distScale = -Math.cos((relDistPost = ((distPos = Math.min(this.MAX_ENEMY_DIST, Math.max(this.MIN_ENEMY_DIST, bearing.getLength()))) - this.MIN_ENEMY_DIST) / (this.MAX_ENEMY_DIST - this.MIN_ENEMY_DIST)) * Math.PI))).getUnit()).scale(Math.abs(this._robot.getDistanceRemaining()))).add(event.getRobotPosition())).getX() < this.SECURE_WALL_DISTANCE || targetPos.getX() > this.FIELD_WIDTH - this.SECURE_WALL_DISTANCE - 1.0 || targetPos.getY() < this.SECURE_WALL_DISTANCE || targetPos.getY() > this.FIELD_HEIGHT - this.SECURE_WALL_DISTANCE - 1.0) {
            newRelativeTargetPos = this.MIDDLE.sub(event.getRobotPosition());
            this.move(newRelativeTargetPos, event);
        }
        double relativeTurn = newRelativeTargetPos.getAngle(movingDir);
        this._robot.setTurnRightRadians(relativeTurn);
    }

    private void handleEscapeWall(AnalyzedScannedRobotEvent event) {
        Vector enemyTangent;
        Vector enemyVectorBearing = event.getEnemyBearing();
        Vector toMiddle = this.MIDDLE.sub(event.getRobotPosition());
        if (toMiddle.dotProduct(enemyTangent = new Vector(enemyVectorBearing.getY(), -enemyVectorBearing.getX())) < 0.0) {
            enemyTangent = enemyTangent.scale(-1.0);
        }
        double x = enemyTangent.getX();
        double y = enemyTangent.getY();
        if (x * toMiddle.getX() < 0.0) {
            x = 0.0;
        }
        if (y * toMiddle.getY() < 0.0) {
            y = 0.0;
        }
        Vector wallEscape = new Vector(x, y);
        this.move(Vector.createPolarVector(50.0, wallEscape.getPhi()), event);
    }

    public void handleBulletHitEvent(BulletHitEvent event) {
        this._previousEnemyEnergy -= event.getEnergy();
    }

    public void handleHitByBulletEvent(HitByBulletEvent event) {
        double energy = event.getVelocity();
    }

    private void move(Vector newHeading, AnalyzedScannedRobotEvent event) {
        double angle = event.getRobotHeading().getAngle(newHeading);
        if (Math.abs(angle) > 1.5707963267948966) {
            angle += Math.PI;
            angle = Utils.normalRelativeAngle((double)angle);
            this._robot.setBack(newHeading.getLength());
            this._moveAhead = false;
        } else {
            this._robot.setAhead(newHeading.getLength());
            this._moveAhead = true;
        }
        this._robot.setTurnLeftRadians(angle);
    }
}

