/*
 * Decompiled with CFR 0.152.
 */
package eem.gun;

import eem.EvBot;
import eem.gun.baseGun;
import eem.gun.misc;
import eem.misc.graphics;
import eem.misc.logger;
import eem.misc.physics;
import eem.target.InfoBot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class linearGun
extends baseGun {
    Point2D.Double targetAtFiringTimePos = new Point2D.Double(0.0, 0.0);

    public linearGun() {
        this.gunName = "linear";
        this.gunColor = new Color(255, 0, 0, 128);
    }

    public linearGun(EvBot evBot) {
        this();
        this.myBot = evBot;
        this.calcGunSettings();
    }

    @Override
    protected Point2D.Double calcTargetFuturePosition(Point2D.Double double_, double d, InfoBot infoBot) {
        Point2D.Double double_2 = this.findTargetHitPositionWithLinearPredictor(double_, d, infoBot);
        return double_2;
    }

    public Point2D.Double findTargetHitPositionWithLinearPredictor(Point2D.Double double_, double d, InfoBot infoBot) {
        double d2;
        double d3 = physics.bulletSpeed(d);
        logger.noise("Bullet speed " + d3);
        Point2D.Double double_2 = infoBot.getVelocity();
        logger.noise("Target velocity " + double_2.x + ", " + double_2.y);
        double d4 = Math.sqrt(double_2.x * double_2.x + double_2.y * double_2.y);
        if (!Utils.isNear((double)d4, (double)0.0)) {
            double d5 = double_2.x / d4;
            double d6 = double_2.y / d4;
        } else {
            d4 = 1.0E-5;
            d2 = Math.PI * 2 * Math.random();
            double d7 = Math.cos(d2);
            double d8 = Math.sin(d2);
        }
        logger.noise("Round time = " + this.myBot.getTime());
        logger.noise("target time = " + infoBot.getLastSeenTime());
        d2 = this.myBot.getTime() - infoBot.getLastSeenTime() + (long)physics.gunCoolingTime(this.myBot.getGunHeat()) + 1L;
        double d9 = infoBot.getX() + double_2.x * d2;
        double d10 = infoBot.getY() + double_2.y * d2;
        this.targetAtFiringTimePos.x = d9;
        this.targetAtFiringTimePos.y = d10;
        logger.noise("Target estimated current position Tx = " + d9 + " Ty = " + d10);
        Point2D.Double double_3 = misc.linear_predictor(d3, new Point2D.Double(d9, d10), double_2, double_);
        logger.noise("Predicted target position " + double_3.x + ", " + double_3.y);
        double_3 = this.futureTargetWithinPhysicalLimitsBasedOnVelocity(double_3, double_2);
        logger.noise("boxed target position " + double_3.x + ", " + double_3.y);
        return double_3;
    }

    private void drawTargetAtFiringTime(Graphics2D graphics2D) {
        if (null != this.targetAtFiringTimePos) {
            graphics2D.setColor(this.gunColor);
            graphics.drawSquare(graphics2D, this.targetAtFiringTimePos, 2 * (this.myBot.robotHalfSize + 2));
        }
    }

    @Override
    public void onPaint(Graphics2D graphics2D) {
        super.onPaint(graphics2D);
        this.drawTargetAtFiringTime(graphics2D);
    }
}

