/*
 * Decompiled with CFR 0.152.
 */
package fcr;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class First
extends AdvancedRobot {
    private int FORWARD;
    private double absoluteBearing;
    private int timeSinceLastScan;
    private int scanDirection;
    private double enemyX;
    private double enemyY;
    private double enemyFutureX;
    private double enemyFutureY;
    private double enemyDistance;
    private double enemyVelocity;
    private double enemyHeading;
    private double firePower;
    private double bulletSpeed;

    public void run() {
        while (true) {
            this.doScan();
            this.doTargeting();
            this.setAdjustRadarForGunTurn(true);
            this.setFire(this.firePower);
            this.execute();
        }
    }

    public void doTargeting() {
        double absBearing = this.absoluteBearing(this.getX(), this.getY(), this.enemyFutureX, this.enemyFutureY);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians())));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.enemyDistance = e.getDistance();
        this.enemyHeading = e.getHeadingRadians();
        this.enemyVelocity = e.getVelocity();
        this.enemyX = this.getX() + Math.sin(this.absoluteBearing) * e.getDistance();
        this.enemyY = this.getY() + Math.cos(this.absoluteBearing) * e.getDistance();
        this.enemyFutureX = this.enemyX + Math.sin(this.enemyHeading) * this.enemyVelocity * (e.getDistance() / this.bulletSpeed);
        this.enemyFutureY = this.enemyY + Math.cos(this.enemyHeading) * this.enemyVelocity * (e.getDistance() / this.bulletSpeed);
        this.timeSinceLastScan = 0;
        if (this.getDistanceRemaining() == 0.0) {
            this.FORWARD = -this.FORWARD;
            this.setAhead(185 * this.FORWARD);
        }
        this.setTurnRightRadians(e.getBearingRadians() + 1.5707963267948966 - 0.5236 * (double)this.FORWARD * (double)(e.getDistance() > 200.0 ? 1 : -1));
    }

    private final void doGun() {
        double gunTurn = Utils.normalRelativeAngle((double)(this.absoluteBearing - this.getGunHeadingRadians()));
        this.setTurnGunRightRadians(gunTurn);
    }

    private final void doScan() {
        ++this.timeSinceLastScan;
        this.scanDirection *= this.scanDirection;
        if (this.timeSinceLastScan < 3) {
            double radarTurn = Utils.normalRelativeAngle((double)(this.absoluteBearing - this.getRadarHeadingRadians()));
            this.setTurnRadarRightRadians(radarTurn *= (double)2 * (double)this.scanDirection);
        } else {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return Math.toRadians(bearing);
    }

    private final /* synthetic */ void this() {
        this.FORWARD = -1;
        this.timeSinceLastScan = 10;
        this.scanDirection = -1;
        this.enemyX = 0.0;
        this.enemyY = 0.0;
        this.enemyFutureX = 0.0;
        this.enemyFutureY = 0.0;
        this.enemyDistance = 0.0;
        this.enemyVelocity = 0.0;
        this.enemyHeading = 0.0;
        this.firePower = 2;
        this.bulletSpeed = 20.0 - this.firePower * (double)3;
    }

    public First() {
        this.this();
    }
}

