/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategy;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;

public class AimBySprayingAtLongDistance
extends CalibratedAimingStrategy {
    private static final double MIN_SHOOTING_DISTANCE = 250.0;
    private double sprayAngle = 90.0;
    private double sprayDistance = BattleConstants.getInstance().getRobotWidth();

    public AimBySprayingAtLongDistance(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
    }

    @Override
    public double getEstimatedSuccessOfShotUsingRules(double bulletSpeed) {
        return Math.min(100.0, this.getDefaultEstimatedSuccess(bulletSpeed));
    }

    @Override
    public void notifyShotJustFired() {
        this.sprayAngle = -this.sprayAngle;
    }

    @Override
    public Location getTargetForShot(double bulletSpeed) {
        Location currentEnemyLocation = this.getEnemy().getLatestRadarObservation().getLocation();
        double distance = Geometry.getDistanceBetweenLocations(currentEnemyLocation, this.getMyRobot().getLocation());
        if (distance > 250.0) {
            double bearingTowardsUs = Geometry.getBearingBetweenLocations(currentEnemyLocation, this.getMyRobot().getLocation());
            return Geometry.getLocationAtBearing(currentEnemyLocation, bearingTowardsUs + this.sprayAngle, this.sprayDistance);
        }
        return null;
    }
}

