/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.enemy;

import dmh.robocode.bullet.DangerousBullet;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;

public abstract class EnemyShootingAtUsStrategy {
    private CommandBasedRobot myRobot;
    private EnemyRobot enemy;
    long hits;
    long nearMisses;
    long misses;
    long bestHits;

    public EnemyShootingAtUsStrategy(CommandBasedRobot myRobot, EnemyRobot enemy) {
        this.myRobot = myRobot;
        this.enemy = enemy;
    }

    public final void processEndOfRound(CommandBasedRobot myRobotInNextRound) {
        this.myRobot = myRobotInNextRound;
    }

    protected EnemyRobot getEnemy() {
        return this.enemy;
    }

    protected CommandBasedRobot getMyRobot() {
        return this.myRobot;
    }

    public abstract DangerousBullet getDangerousBulletFiredNow(double var1, double var3);

    public void informHit() {
        ++this.hits;
    }

    public void informNearMiss() {
        ++this.nearMisses;
    }

    public void informMiss() {
        ++this.misses;
    }

    public void informBestHit() {
        ++this.bestHits;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " = " + Math.round(this.getWeightedChanceOfHit()) + "%   Hits = " + this.hits + "   Near Misses = " + this.nearMisses + "   Best Hits = " + this.bestHits + "   Misses = " + this.misses;
    }

    public double getWeightedChanceOfHit() {
        long totalHits = this.misses + this.nearMisses + this.hits;
        if (totalHits == 0L) {
            return 100.0;
        }
        return 100.0 * ((double)this.hits + (double)this.nearMisses / 2.0 + (double)this.bestHits / 2.0) / (double)totalHits;
    }

    public boolean isAlwaysUsed() {
        return this.hits >= 15L && (double)this.hits / (double)(this.misses + this.nearMisses + this.hits) >= 0.85;
    }

    public void informHitDetails(Location myLocation, DangerousBullet bullet, long currentTime) {
        double actualBulletHeading = Geometry.getBearingBetweenLocations(bullet.getFiredFromLocation(), myLocation);
        Location bulletLocationNow = bullet.getLocationAtTime(currentTime);
        double headingError = Geometry.getRelativeBearing(bullet.getEstimatedHeading(), actualBulletHeading);
        double distanceError = Geometry.getDistanceBetweenLocations(bulletLocationNow, myLocation);
        double distanceTravelled = Geometry.getDistanceBetweenLocations(bullet.getFiredFromLocation(), bulletLocationNow);
    }

    public String getStatsAsString() {
        return "\t" + this.misses + "\t" + this.nearMisses + "\t" + this.hits;
    }

    public void processStatsAsString(String stats) {
        String[] parts = stats.split("\t");
        this.misses = Integer.parseInt(parts[0]);
        this.nearMisses = Integer.parseInt(parts[1]);
        this.hits = Integer.parseInt(parts[2]);
    }

    public String getUniqueShortId() {
        return this.getClass().getSimpleName().replaceAll("[^A-Z]", "");
    }
}

