/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.simulator;

import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.simulator.EnemySimulator;

public class TimeMachineEnemySimulator
implements EnemySimulator {
    private EnemyRobot enemy;
    private long currentTime;
    private long startTime;
    private long endTime;
    private double xDisplacement;
    private double yDisplacement;

    public TimeMachineEnemySimulator(EnemyRobot enemy, long startTime, long endTime) {
        this(enemy, startTime, endTime, 0.0, 0.0);
    }

    public TimeMachineEnemySimulator(EnemyRobot enemy, long startTime, long endTime, double xDisplacement, double yDisplacement) {
        this.enemy = enemy;
        this.startTime = startTime;
        this.endTime = endTime;
        this.currentTime = startTime;
        this.xDisplacement = xDisplacement;
        this.yDisplacement = yDisplacement;
    }

    @Override
    public Location getLocation() {
        Location historicLocation = this.enemy.getLocationAtTime(this.currentTime);
        if (historicLocation == null) {
            historicLocation = this.enemy.getLatestRadarObservation().getLocation();
        }
        return new Location(historicLocation.getX() + this.xDisplacement, historicLocation.getY() + this.yDisplacement);
    }

    @Override
    public void takeOneTurn() {
        ++this.currentTime;
        if (this.currentTime > this.endTime) {
            this.currentTime = this.startTime;
        }
    }
}

