/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import java.awt.geom.Point2D;
import muf.utils.GameData;
import muf.utils.GameDataBuffer;
import muf.utils.IndexMaker;
import muf.utils.OccuranceCounter;
import muf.utils.Rutils;
import muf.utils.Targeting;

public class StatisticalTargeting
extends Targeting {
    protected static final int hRS = 18;
    protected double[] hitPoints = new double[]{-18.0, -9.0, 0.0, 9.0, 18.0};
    protected double[] hitPointWeights = new double[]{1.0, 2.0, 3.0, 2.0, 1.0};
    protected IndexMaker distanceIM;
    protected IndexMaker headingIM;
    protected IndexMaker velocityIM;
    protected IndexMaker bulletPowerIM;
    protected OccuranceCounter[][][][] stats;
    protected GameDataBuffer gameDataBuffer;

    public StatisticalTargeting(GameData gameData, GameDataBuffer gameDataBuffer, double d, double d2, int n, IndexMaker indexMaker, IndexMaker indexMaker2, IndexMaker indexMaker3, IndexMaker indexMaker4, IndexMaker indexMaker5) {
        this.gameData = gameData;
        this.gameDataBuffer = gameDataBuffer;
        this.distanceIM = indexMaker;
        this.headingIM = indexMaker2;
        this.velocityIM = indexMaker3;
        this.bulletPowerIM = indexMaker4;
        int n2 = indexMaker.getMaxIndex() + 1;
        int n3 = indexMaker2.getMaxIndex() + 1;
        int n4 = indexMaker3.getMaxIndex() + 1;
        int n5 = indexMaker4.getMaxIndex() + 1;
        this.stats = new OccuranceCounter[n2][n3][n4][n5];
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                while (n8 < n4) {
                    int n9 = 0;
                    while (n9 < n5) {
                        this.stats[n6][n7][n8][n9] = new OccuranceCounter(indexMaker5, n);
                        this.stats[n6][n7][n8][n9].setHighestOccuranceIndex(indexMaker5.getIndex(0.0));
                        ++n9;
                    }
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        this.name = new String("StatisticalTargeting");
    }

    public void setHitPoints(double[] dArray, double[] dArray2) {
        this.hitPoints = dArray;
        this.hitPointWeights = dArray2;
    }

    public void notifyEnemyScanned() {
        int n = 0;
        while (n < this.hitPoints.length) {
            double d = this.hitPoints[n];
            double d2 = this.hitPointWeights[n];
            int n2 = 0;
            while (n2 <= this.bulletPowerIM.getMaxIndex()) {
                double d3 = this.bulletPowerIM.getValueByIndex(n2);
                this.gameDataBuffer.reset();
                while (this.gameDataBuffer.hasPrev()) {
                    GameData gameData = this.gameDataBuffer.getPrev();
                    if (this.addStatistics(gameData, d3, d, d2)) break;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected boolean addStatistics(GameData gameData, double d, double d2, double d3) {
        double d4 = (this.gameData.enemyY - gameData.myY) / (this.gameData.enemyX - gameData.myX);
        double d5 = Math.sqrt(1.0 / (d4 * d4 + 1.0));
        double d6 = d4 * d5;
        double d7 = this.gameData.enemyX + d2 * d6;
        double d8 = this.gameData.enemyY + d2 * d5;
        double d9 = Point2D.distance(gameData.myX, gameData.myY, d7, d8);
        double d10 = Rutils.bulletVelocity(d);
        int n = (int)Math.round(d9 / d10);
        double d11 = Rutils.normalRelativeAngle(Rutils.pointsToAngle(gameData.myX, gameData.myY, d7, d8) - gameData.enemyAbsBearing);
        int n2 = (int)Math.ceil(Math.abs(d11) / 20.0);
        if (this.gameData.time - gameData.time == (long)(n2 + n)) {
            OccuranceCounter occuranceCounter = this.getAngleOccurance(this.gameData, d);
            occuranceCounter.add(d11, d3);
            return true;
        }
        return false;
    }

    protected OccuranceCounter getAngleOccurance(GameData gameData, double d) {
        int n = this.distanceIM.getIndex(gameData.enemyDistance);
        int n2 = this.headingIM.getIndex(gameData.enemyRelHeading);
        int n3 = this.velocityIM.getIndex(gameData.enemyVelocity);
        int n4 = this.bulletPowerIM.getIndex(d);
        return this.stats[n][n2][n3][n4];
    }

    public double getAbsAngle(double d) {
        return Rutils.normalAbsoluteAngle(this.getGunTurningRightAngle(d) + this.gameData.myGunHeading);
    }

    public double getGunTurningRightAngle(double d) {
        OccuranceCounter occuranceCounter = this.getAngleOccurance(this.gameData, d);
        return occuranceCounter.getHighestOccuranceValue();
    }
}

