/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Stats;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import nosteel.Basics.Vector;
import nosteel.Modules.Aiming;
import nosteel.Modules.Data.EnemyData;
import nosteel.Modules.Data.ScanData;
import nosteel.Modules.DataList;
import nosteel.Modules.Stats.Statistic;

public class AnalyseMovementSitting
extends Statistic {
    private List<Vector> distanceMovement = new ArrayList<Vector>();
    private final int DISTANCE_THRESHOLD = 3;
    private double SittingRatio;

    public AnalyseMovementSitting(DataList s, Aiming t) {
        super(s, t, AnalyseMovementSitting.class.getName());
    }

    public double getSittingRatio() {
        return this.SittingRatio;
    }

    private double calcTotalDistance(List<Vector> window) {
        double distance = 0.0;
        Vector v2 = null;
        for (Vector v : window) {
            if (v2 != null) {
                distance += v.substract(v2).getLength();
            }
            v2 = v;
        }
        return distance;
    }

    private void checkDistanceMovement(String target) {
        double shortSitting = 0.0;
        double longSitting = 0.0;
        boolean detected = false;
        this.distanceMovement.clear();
        ArrayList<Vector> window = new ArrayList<Vector>();
        ListIterator<ScanData> itData = this.scans.getEnemyData(target).getScanIterator(EnemyData.END_OF_LIST);
        block0: while (itData.hasPrevious()) {
            ScanData e = itData.previous();
            Vector v = new Vector(e.vHisPos.x, e.vHisPos.y);
            window.add(v);
            if (this.distanceMovement.size() == 0) {
                this.distanceMovement.add(v);
            }
            if (window.size() < 2) continue;
            double distance = this.calcTotalDistance(window);
            if (distance > 3.0) {
                this.distanceMovement.add((Vector)window.get(0));
                if (window.size() < 3) {
                    shortSitting += 1.0;
                }
                detected = false;
                int max = window.size();
                for (int k = 0; k < max; ++k) {
                    window.remove(0);
                    distance = this.calcTotalDistance(window);
                    if (distance < 3.0 || Double.isNaN(distance)) continue block0;
                }
                continue;
            }
            longSitting += 1.0;
        }
        this.distanceMovement.add((Vector)window.get(0));
        this.distanceMovement.add((Vector)window.get(window.size() - 1));
        this.SittingRatio = longSitting / (longSitting + shortSitting);
    }

    @Override
    public void analyse() {
        String target = this.aiming.getTargetName();
        if (target == null) {
            return;
        }
        if (this.scans.getEnemyData(target).getNumOfScans() <= 3) {
            return;
        }
        this.checkDistanceMovement(target);
    }

    @Override
    public void draw(Graphics2D g) {
    }

    @Override
    public void print() {
    }
}

