/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.analysis;

import alk.lap.LoudAndProud;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import java.util.HashMap;

public class TargetStrategyStatistic {
    private static final double PROB_HIT_INCREMENT = 0.2;
    private static final double PROB_NOHIT_DECREMENT = 0.1;
    public static final int STAT_SIZE = 7;
    public HashMap<String, StrategyCount> stat = new HashMap(7);
    public int numberOfcounts = 0;

    public TargetStrategyStatistic(LoudAndProud proud) {
        int i = 0;
        while (i < proud.getTacticLead().getEnemyTargetStrategies().length) {
            TargetStrategy t = proud.getTacticLead().getEnemyTargetStrategies()[i];
            this.stat.put(t.describe(), new StrategyCount(t));
            ++i;
        }
    }

    public void incHit(TargetStrategy t, int count) {
        for (StrategyCount sCount : this.stat.values()) {
            if (sCount.strat.describe().equals(t.describe())) {
                sCount.hitCount += count;
                sCount.probability = Math.min(sCount.probability + 0.2, 1.0);
                continue;
            }
            sCount.probability = Math.max(sCount.probability + 0.1, 0.2);
        }
        ++this.numberOfcounts;
    }

    public void setHitCount(TargetStrategy t, int count) {
        StrategyCount strategyCount = this.stat.get(t.describe());
        strategyCount.hitCount = count;
    }

    public StrategyCount getCount(String tName) {
        return this.stat.get(tName);
    }

    public StrategyCount getMaxCountStrat() {
        double maxCount = 0.0;
        StrategyCount maxStrat = null;
        for (StrategyCount sCount : this.stat.values()) {
            int count = sCount.hitCount;
            if (!((double)count >= maxCount)) continue;
            maxCount = count;
            maxStrat = sCount;
        }
        return maxStrat;
    }

    public static void paint(LoudAndProud proud) {
        int startX = 700;
        int startY = 550;
        int lineDistance = -16;
        int barWidthHalf = 8;
        StrategyCount[] maxStratC = proud.getStrategicLead().getAnalystsDB().getEnemyMostProbableTargetStrat();
        double scaleToMax = (double)maxStratC[0].hitCount == 0.0 ? 1.0 : 100.0 / (double)maxStratC[0].hitCount;
        int i = 0;
        TargetStrategy[] targetStrategyArray = proud.getTacticLead().getEnemyTargetStrategies();
        int n = 0;
        int n2 = targetStrategyArray.length;
        while (n < n2) {
            TargetStrategy strat = targetStrategyArray[n];
            int count = proud.getStrategicLead().getAnalystsDB().getEnemyTargetHitCount(strat);
            double width = (double)count * scaleToMax;
            proud.getVc().drawRect(new DVektor(startX, startY + i * lineDistance - barWidthHalf), new DVektor((double)startX - width, startY + i * lineDistance + barWidthHalf), String.valueOf(strat.describe()) + ":" + count + (count == maxStratC[0].hitCount ? "*" : "") + (count == maxStratC[1].hitCount ? "#" : ""), strat.getColorCode());
            ++i;
            ++n;
        }
    }

    public String toCSVHead(LoudAndProud proud) {
        StringBuffer aBuf = new StringBuffer();
        TargetStrategy[] targetStrategyArray = proud.getTacticLead().getEnemyTargetStrategies();
        int n = 0;
        int n2 = targetStrategyArray.length;
        while (n < n2) {
            TargetStrategy strat = targetStrategyArray[n];
            if (aBuf.length() != 0) {
                aBuf.append(",");
            }
            aBuf.append(strat.describe());
            ++n;
        }
        return aBuf.toString();
    }

    public String toCSV(LoudAndProud proud) {
        StringBuffer aBuf = new StringBuffer();
        TargetStrategy[] targetStrategyArray = proud.getTacticLead().getEnemyTargetStrategies();
        int n = 0;
        int n2 = targetStrategyArray.length;
        while (n < n2) {
            TargetStrategy strat = targetStrategyArray[n];
            if (aBuf.length() != 0) {
                aBuf.append(",");
            }
            aBuf.append(proud.getStrategicLead().getAnalystsDB().getEnemyTargetHitCount(strat));
            ++n;
        }
        return aBuf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StrategyCount
    implements Comparable<StrategyCount> {
        public TargetStrategy strat = null;
        public double probability = 0.0;
        public int hitCount = 0;

        public StrategyCount(TargetStrategy strat) {
            this.strat = strat;
        }

        @Override
        public int compareTo(StrategyCount o) {
            return this.hitCount < o.hitCount ? 1 : -1;
        }
    }
}

