/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.wave;

import java.awt.Color;
import java.awt.Graphics2D;
import rampancy.RampantRobot;
import rampancy.standard.RDefaultMovementStatistic;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RUtil;
import rampancy.util.movement.RMovementStatistic;
import rampancy.util.wave.REnemyWave;
import robocode.util.Utils;

public class REnemyWaveWithStats
extends REnemyWave {
    private double[] guessFactors;

    public REnemyWaveWithStats(REnemyRobot creator) {
        super(creator);
        RMovementStatistic movementStatistic = RampantRobot.getStatisticsManager().getMovementStatistics();
        if (movementStatistic instanceof RDefaultMovementStatistic) {
            this.guessFactors = ((RDefaultMovementStatistic)movementStatistic).getGuessFactorArray(this);
        }
    }

    public double getDangerForLocation(RPoint location, int numBins) {
        double offset = this.computeOffsetAngle(location);
        double factor = Utils.normalRelativeAngle((double)offset) / RUtil.computeMaxEscapeAngle(this.getVelocity()) * (double)this.getDirection();
        int index = RUtil.computeBin(factor, numBins);
        return this.guessFactors[index];
    }

    public void draw(Graphics2D g) {
        if (this.guessFactors == null) {
            super.draw(g);
        } else {
            double largest = 0.0;
            int i = 0;
            while (i < this.guessFactors.length) {
                if (this.guessFactors[i] > largest) {
                    largest = this.guessFactors[i];
                }
                ++i;
            }
            i = 0;
            while (i < this.guessFactors.length) {
                double danger = this.guessFactors[i];
                double factor = RUtil.getGuessFactorForIndex(i, this.guessFactors.length);
                double maxEscapeAngle = RUtil.computeMaxEscapeAngle(this.getVelocity()) * factor * (double)this.direction;
                RPoint location = RUtil.project(this.getOrigin(), this.getDirectionAngle() + maxEscapeAngle, this.getDistanceTraveled() + this.velocity);
                Color dangerColor = new Color(0, 0, 200);
                if (danger > 0.01) {
                    dangerColor = new Color((int)(155.0 * (danger / largest)) + 100, 0, 0);
                }
                g.setColor(dangerColor);
                RUtil.fillOval(location, 4, g);
                ++i;
            }
        }
    }
}

