/*
 * Decompiled with CFR 0.152.
 */
package tripphippy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;
import tripphippy.BotCache;
import tripphippy.BotData;
import tripphippy.GravPoint;
import tripphippy.OrbitMessage;
import tripphippy.StatusMessage;
import wiki.HelperMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alice
extends TeamRobot {
    public BotCache data;
    public Point2D.Double move;
    int shieldDir = 1;
    private Vector<GravPoint> gravPoints;
    private double midpointstrength = 0.0;
    private int midpointcount = 0;

    private void addGravPoints() {
        this.gravPoints.clear();
        this.gravPoints.add(new GravPoint(this.move.getX(), this.move.getY(), Math.pow(HelperMethods.getDistance(this.getX(), this.getY(), this.move.getX(), this.move.getY()), 2.0) * 17.0));
        for (BotData enemy : this.data.bots.values()) {
            if (enemy.dead) continue;
            this.gravPoints.add(new GravPoint(enemy.x, enemy.y, -40000.0));
        }
        ++this.midpointcount;
        if (this.midpointcount > 10) {
            this.midpointcount = 0;
            this.midpointstrength = HelperMethods.getRandom(-50000.0, -10000.0);
        }
        this.gravPoints.add(new GravPoint(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0, this.midpointstrength));
        this.gravPoints.add(new GravPoint(this.getBattleFieldWidth(), this.getBattleFieldHeight(), -10000.0));
        this.gravPoints.add(new GravPoint(0.0, this.getBattleFieldHeight(), -10000.0));
        this.gravPoints.add(new GravPoint(this.getBattleFieldWidth(), 0.0, -10000.0));
        this.gravPoints.add(new GravPoint(0.0, 0.0, -10000.0));
        for (int i = 0; i < 5; ++i) {
            this.gravPoints.add(new GravPoint(Math.random() * this.getBattleFieldWidth(), this.getBattleFieldHeight(), -5000.0));
            this.gravPoints.add(new GravPoint(this.getBattleFieldWidth(), Math.random() * this.getBattleFieldHeight(), -5000.0));
            this.gravPoints.add(new GravPoint(0.0, Math.random() * this.getBattleFieldHeight(), -5000.0));
            this.gravPoints.add(new GravPoint(Math.random() * this.getBattleFieldWidth(), 0.0, -5000.0));
        }
    }

    private void calculateForceAndMove() {
        double xforce = 0.0;
        double yforce = 0.0;
        double x = this.getX();
        double y = this.getY();
        Point2D.Double dest = new Point2D.Double();
        for (int i = 0; i < this.gravPoints.size(); ++i) {
            GravPoint gravPoint = this.gravPoints.elementAt(i);
            double force = gravPoint.power / Math.pow(HelperMethods.getDistance(x, y, gravPoint.x, gravPoint.y), 2.0);
            double ang = Utils.normalRelativeAngle((double)HelperMethods.getAngle(gravPoint.x, gravPoint.y, x, y));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        xforce += 10000.0 / Math.pow(HelperMethods.getDistance(x, y, this.getBattleFieldWidth(), y), 3.0);
        yforce += 10000.0 / Math.pow(HelperMethods.getDistance(x, y, x, this.getBattleFieldHeight()), 3.0);
        dest.setLocation(x - (xforce -= 10000.0 / Math.pow(HelperMethods.getDistance(x, y, 0.0, y), 3.0)), y - (yforce -= 10000.0 / Math.pow(HelperMethods.getDistance(x, y, x, 0.0), 3.0)));
        this.getGraphics().drawLine((int)x, (int)y, (int)(x - xforce), (int)(y - yforce));
        this.goTo(dest);
    }

    public void goTo(Point2D.Double destination) {
        double wid = this.getWidth() / 2.0;
        if (destination.getX() < wid) {
            destination.setLocation(wid, destination.getY());
        } else if (destination.getX() > this.getBattleFieldWidth() - wid) {
            destination.setLocation(this.getBattleFieldWidth() - wid, destination.getY());
        }
        if (destination.getY() < wid) {
            destination.setLocation(destination.getX(), wid);
        } else if (destination.getY() > this.getBattleFieldHeight() - wid) {
            destination.setLocation(destination.getX(), this.getBattleFieldHeight() - wid);
        }
        double angle = Utils.normalRelativeAngle((double)(HelperMethods.getAngle(this.getX(), this.getY(), destination.getX(), destination.getY()) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead(HelperMethods.getDistance(this.getX(), this.getY(), destination.getX(), destination.getY()) * (double)(angle == turnAngle ? 1 : -1));
    }

    public void selectCorner() {
        double middlex = this.getBattleFieldWidth() / 2.0;
        double middley = this.getBattleFieldHeight() / 2.0;
        if (this.getX() > middlex) {
            this.move.setLocation(HelperMethods.getRandom(this.getBattleFieldWidth() - 320.0, this.getBattleFieldWidth() - 100.0), this.move.getY());
        } else {
            this.move.setLocation(HelperMethods.getRandom(100.0, 320.0), this.move.getY());
        }
        if (this.getY() > middley) {
            this.move.setLocation(this.move.getX(), HelperMethods.getRandom(this.getBattleFieldHeight() - 320.0, this.getBattleFieldHeight() - 100.0));
        } else {
            this.move.setLocation(this.move.getX(), HelperMethods.getRandom(100.0, 320.0));
        }
    }

    public void run() {
        double shieldAngle = 0.0;
        double shieldDist = 75.0;
        this.data = new BotCache(this);
        this.gravPoints = new Vector();
        this.move = new Point2D.Double(HelperMethods.getRandom(0.0, this.getBattleFieldWidth()), HelperMethods.getRandom(0.0, this.getBattleFieldHeight()));
        Point2D.Double aim = new Point2D.Double();
        BotData target = null;
        double gunPower = 3.0;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setBodyColor(Color.blue);
        this.setGunColor(Color.yellow);
        this.setRadarColor(Color.black);
        this.setScanColor(Color.black);
        this.setBulletColor(Color.red);
        this.data.ResetRound();
        this.selectCorner();
        while (true) {
            this.data.Run();
            if (HelperMethods.getDistance(this.getX(), this.getY(), this.move.getX(), this.move.getY()) < 40.0) {
                this.selectCorner();
            }
            if (target != null && this.getGunHeat() <= 0.0 && this.getEnergy() > gunPower && Utils.isNear((double)this.getGunTurnRemainingRadians(), (double)0.0)) {
                this.setFire(gunPower);
                gunPower = HelperMethods.getRandom(1.1, 3.0);
                if (gunPower > this.getEnergy()) {
                    gunPower = this.getEnergy() - 0.1;
                }
            }
            this.addGravPoints();
            this.calculateForceAndMove();
            if (this.getGunHeat() > 0.5 || target == null) {
                target = this.data.getClosestUpdatedEnemyAvoidFriendlyFire(this.getX(), this.getY());
            }
            if (target != null) {
                int timeToImpact = (int)Math.ceil(HelperMethods.getDistance(this.getX(), this.getY(), target.x, target.y) / Rules.getBulletSpeed((double)gunPower));
                aim = target.getPredictedPosition(timeToImpact);
                for (int a = 0; a < 5; ++a) {
                    timeToImpact = (int)Math.ceil(HelperMethods.getDistance(this.getX(), this.getY(), aim.getX(), aim.getY()) / Rules.getBulletSpeed((double)gunPower));
                    aim = target.getPredictedPosition(timeToImpact);
                }
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(HelperMethods.getAngle(this.getX(), this.getY(), aim.getX(), aim.getY()) - this.getGunHeadingRadians())));
            }
            this.setTurnRadarRightRadians(this.data.getOptimumRadar());
            if (this.getTeammates() != null) {
                HashMap<String, OrbitMessage> orbs = this.generateOrbits(shieldAngle, shieldDist);
                shieldAngle += (double)this.shieldDir * (Math.PI / (shieldDist / 1.5));
                try {
                    for (String s : this.getTeammates()) {
                        this.sendMessage(s, orbs.get(s));
                    }
                }
                catch (IOException io) {
                    io.printStackTrace(this.out);
                }
            }
            this.execute();
        }
    }

    public HashMap<String, OrbitMessage> generateOrbits(double rotate, double dist) {
        if (this.getTeammates() == null) {
            return null;
        }
        HashMap<String, OrbitMessage> ret = new HashMap<String, OrbitMessage>();
        Vector<String> s = new Vector<String>();
        for (String stupid : this.getTeammates()) {
            BotData b = this.data.bots.get(stupid);
            if (b != null && b.dead) continue;
            s.add(stupid);
        }
        double ang = Utils.normalAbsoluteAngle((double)rotate);
        double delta = Math.PI * 2 / (double)s.size();
        for (int i = 0; i < s.size(); ++i) {
            ret.put((String)s.elementAt(i), new OrbitMessage(HelperMethods.getXcomponent(ang, dist) + this.getX(), HelperMethods.getYcomponent(ang, dist) + this.getY()));
            ang += delta;
        }
        return ret;
    }

    public void onPaint(Graphics2D g) {
        for (GravPoint gp : this.gravPoints) {
            if (gp.power < 0.0) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.blue);
            }
            double r = Math.abs(gp.power / 500.0);
            g.drawOval((int)(gp.x - r), (int)(gp.y - r), (int)(r * 2.0), (int)(r * 2.0));
        }
        g.setColor(Color.green);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.data.Update(e);
        if (!this.isTeammate(e.getName())) {
            try {
                BotData stat = this.data.bots.get(e.getName());
                this.broadcastMessage(new StatusMessage(stat.name, stat.x, stat.y, stat.lastEnergy, stat.energy, stat.lastDirection, stat.direction, stat.lastVelocity, stat.velocity, e.getTime(), false));
            }
            catch (IOException io) {
                io.printStackTrace(this.out);
            }
        }
    }

    public void onBattleEnded(BattleEndedEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
        this.data.Update(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.data.Update(e);
        this.shieldDir = -this.shieldDir;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.data.Update(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.data.Update(e);
        try {
            this.broadcastMessage(new StatusMessage(e.getName(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, e.getTime(), true));
        }
        catch (IOException io) {
            io.printStackTrace(this.out);
        }
    }

    public void onDeath(DeathEvent e) {
        this.data.Update(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onWin(WinEvent e) {
    }

    public void onStatus(StatusEvent e) {
        try {
            this.broadcastMessage(new StatusMessage(this.getName(), this.getX(), this.getY(), this.getEnergy(), this.getEnergy(), this.getHeadingRadians(), this.getHeadingRadians(), this.getVelocity(), this.getVelocity(), e.getTime(), false));
        }
        catch (IOException io) {
            io.printStackTrace(this.out);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onCustomEvent(CustomEvent e) {
    }

    public void onMessageReceived(MessageEvent e) {
        if (e.getMessage() instanceof StatusMessage) {
            this.data.Update((StatusMessage)e.getMessage());
        }
    }
}

