/*
 * Decompiled with CFR 0.152.
 */
package cb.util;

import cb.util.MovementCommands;
import cb.util.MovementState;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.Rules;
import robocode.util.Utils;

public class BattleFieldUtils {
    public static final int BOT_WIDTH = 36;
    public static final int BOT_HALF_WIDTH = 18;
    private static final double WALL_BORDER = 19.5;
    private static final double SMALLEST_FACTOR = 0.95;
    private static final double BIGGEST_FACTOR = 1.7;
    private static final double MIN_WALL_STICK = 100.0;
    private static final double MAX_WALL_STICK = 120.0;
    private double battleFieldWidth;
    private double battleFieldHeight;
    private Rectangle2D.Double battleField;

    public void setDimensions(double battleFieldWidth, double battleFieldHeight) {
        this.battleFieldWidth = battleFieldWidth;
        this.battleFieldHeight = battleFieldHeight;
        this.battleField = new Rectangle2D.Double(18.0, 18.0, battleFieldWidth - 36.0, battleFieldHeight - 36.0);
    }

    public Point2D.Double circle(Point2D.Double sourcePoint, int circleDirection, Point2D.Double enemyLocation, double desiredDistance, double enemyBulletPower) {
        double factor = BattleFieldUtils.limit(0.95, desiredDistance / sourcePoint.distance(enemyLocation), 1.7);
        double wallStick = sourcePoint.distance(enemyLocation) * Math.sin(BattleFieldUtils.maximumEscapeAngle(enemyBulletPower));
        wallStick = BattleFieldUtils.limit(100.0, wallStick, 120.0);
        Point2D.Double p = BattleFieldUtils.project(sourcePoint, BattleFieldUtils.absoluteBearing(sourcePoint, enemyLocation) - factor * (double)circleDirection * Math.PI / 2.0, wallStick);
        return this.wallSmoothing(sourcePoint, p, circleDirection, wallStick);
    }

    private Point2D.Double wallSmoothing(Point2D.Double location, Point2D.Double destination, int circleDirection, double wallStick) {
        Point2D.Double p = new Point2D.Double(destination.x, destination.y);
        for (int i = 0; !this.battleField.contains(p) && i < 4; ++i) {
            double a;
            if (p.x < 19.5) {
                p.x = 19.5;
                a = location.x - 19.5;
                p.y = location.y + (double)circleDirection * Math.sqrt(wallStick * wallStick - a * a);
                continue;
            }
            if (p.y > this.battleFieldHeight - 19.5) {
                p.y = this.battleFieldHeight - 19.5;
                a = this.battleFieldHeight - 19.5 - location.y;
                p.x = location.x + (double)circleDirection * Math.sqrt(wallStick * wallStick - a * a);
                continue;
            }
            if (p.x > this.battleFieldWidth - 19.5) {
                p.x = this.battleFieldWidth - 19.5;
                a = this.battleFieldWidth - 19.5 - location.x;
                p.y = location.y - (double)circleDirection * Math.sqrt(wallStick * wallStick - a * a);
                continue;
            }
            if (!(p.y < 19.5)) continue;
            p.y = 19.5;
            a = location.y - 19.5;
            p.x = location.x - (double)circleDirection * Math.sqrt(wallStick * wallStick - a * a);
        }
        return p;
    }

    public MovementState predictPosition(int direction, MovementState initialState, Point2D.Double enemyLocation, Point2D.Double waveSource, long waveTime, double bulletPower, double desiredDistance, double maxVelocity) {
        MovementState state = initialState;
        int counter = 0;
        boolean intercepted = false;
        do {
            MovementCommands commands = this.goTo(state, this.circle(state.location, direction, enemyLocation, desiredDistance, bulletPower));
            state = state.predict(commands);
            ++counter;
            if (!(state.location.distance(waveSource) < (double)((long)(counter + 1) + initialState.time - waveTime) * Rules.getBulletSpeed((double)bulletPower))) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return state;
    }

    public Point2D.Double maximumEscapeAngle(int direction, MovementState robotState, Point2D.Double fireLocation, double bulletPower) {
        MovementState state = robotState;
        int counter = 0;
        boolean intercepted = false;
        double desiredDistance = fireLocation.distance(robotState.location);
        do {
            MovementCommands commands = this.goTo(state, this.circle(state.location, direction, fireLocation, desiredDistance, bulletPower));
            state = state.predict(commands);
            ++counter;
            if (!(state.location.distance(fireLocation) < (double)(counter + 1) * Rules.getBulletSpeed((double)bulletPower))) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return state.location;
    }

    public ArrayList<Point2D.Double> predictMovements(MovementState initialState, Point2D.Double destination) {
        MovementState state = initialState;
        int counter = 0;
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        do {
            MovementCommands commands = this.goTo(state, destination);
            state = state.predict(commands);
            points.add(state.location);
        } while (state.location.distance(destination) > 1.0 && ++counter < 500);
        return points;
    }

    public MovementCommands goTo(MovementState state, Point2D.Double destination) {
        Point2D.Double w;
        MovementCommands commands = new MovementCommands();
        double x = destination.x - state.location.x;
        double y = destination.y - state.location.y;
        double angleToTarget = Math.atan2(x, y);
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - state.heading));
        double distance = Math.hypot(x, y);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        if (distance > 1.0) {
            commands.setTurnAngle(turnAngle);
        }
        double velocity = Math.min(8.0, Math.cos(turnAngle) * 10.0) + 1.0;
        do {
            double len = (velocity -= 1.0) * velocity / 2.0 + velocity;
            w = BattleFieldUtils.project(state.location, state.heading, len * (double)(targetAngle == turnAngle ? 1 : -1));
        } while (velocity > 0.0 && !this.battleField.contains(w));
        commands.setMaxVelocity(velocity);
        if (targetAngle == turnAngle) {
            commands.setDistance(distance);
        } else {
            commands.setDistance(-distance);
        }
        if (distance < 15.0 && Math.abs(turnAngle) > 0.1) {
            commands.setMaxVelocity(0.0);
        }
        return commands;
    }

    public boolean contains(Point2D.Double p, double battleBorder) {
        return p.x >= battleBorder && p.y >= battleBorder && p.x <= this.battleFieldWidth - battleBorder && p.y <= this.battleFieldHeight - battleBorder;
    }

    public static Point2D.Double project(Point2D.Double source, double angle, double length) {
        return new Point2D.Double(source.getX() + Math.sin(angle) * length, source.getY() + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double maximumEscapeAngle(double bulletPower) {
        return Math.asin(8.0 / Rules.getBulletSpeed((double)bulletPower));
    }

    public static Point2D.Double between(Point2D.Double a, Point2D.Double b, double f) {
        return new Point2D.Double(a.x + f * (b.x - a.x), a.y + f * (b.y - a.y));
    }
}

