/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement.wavesurfing;

import florent.XSeries.Configuration;
import florent.XSeries.movement.antigravity.BulletPoint;
import florent.XSeries.movement.wavesurfing.AdaptativeVisitRecorder;
import florent.XSeries.movement.wavesurfing.GFLog;
import florent.XSeries.movement.wavesurfing.MovementVisitRecorder;
import florent.XSeries.radar.Enemy;
import florent.XSeries.utils.RobocodeTools;
import florent.XSeries.utils.VisitRecorder;
import florent.XSeries.utils.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.util.Utils;

public class EnemyWave
extends Wave {
    private static AdvancedRobot me;
    private static double lastVelocity;
    private static double timeSinceVChange;
    private static double myHeading;
    private static Point2D.Double targetLocation;
    private static VisitRecorder hitRecorder;
    private static VisitRecorder recorder;
    private static Rectangle2D.Double BF;
    private int distanceIndex;
    private int velocityIndex;
    private int accelIndex;
    private int wallIndex;
    private int timeIndex;
    private int powerIndex;
    private int bftIndex;
    private int predictedGf;
    public Enemy enemy;
    public static double time;
    public BulletPoint point;
    public boolean surfable = true;

    public static void initClass(AdvancedRobot me) {
        EnemyWave.me = me;
        BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
        targetLocation = new Point2D.Double(me.getX(), me.getY());
        time = (int)me.getTime();
        recorder = new MovementVisitRecorder();
        hitRecorder = new AdaptativeVisitRecorder();
    }

    public EnemyWave(Enemy enemy) {
        this.enemy = enemy;
    }

    public void init(Point2D.Double gun, Point2D.Double target, int bearingDirection, double power, double velocity, double absoluteBearing, double fireTime) {
        this.init(gun, target, bearingDirection, power, velocity, absoluteBearing, 2, true, fireTime);
    }

    public void init(Point2D.Double gun, Point2D.Double target, int bearingDirection, double power, double velocity, double absoluteBearing, int offset, boolean register, double fireTime) {
        super.init(gun, target, bearingDirection, power, fireTime);
    }

    public void segment(double distance, double velocity, double lateralVelocity, Point2D.Double target, double power) {
        GFLog log;
        this.distanceIndex = RobocodeTools.index(GFLog.DISTANCE_SLICES, distance);
        this.velocityIndex = RobocodeTools.index(GFLog.VELOCITY_SLICES, Math.abs(lateralVelocity));
        this.accelIndex = RobocodeTools.index(GFLog.ACCEL_SLICES, Math.abs(velocity) - Math.abs(lastVelocity));
        this.wallIndex = RobocodeTools.index(GFLog.WALL_SLICES, this.wallDistance(1.0, BF, target));
        this.timeIndex = RobocodeTools.index(GFLog.TIME_SLICES, timeSinceVChange * 1.0 / this.travelTime(target, this.fireTime));
        this.bftIndex = RobocodeTools.index(GFLog.BULLET_FLIGHT_TIME_SLICES, distance / RobocodeTools.bulletVelocity(power));
        this.powerIndex = RobocodeTools.index(GFLog.POWER_SLICES, power);
        lastVelocity = velocity;
        GFLog gFLog = log = me.getOthers() > 1 ? this.enemy.logMelee : this.enemy.logDuel;
        if (this.enemy.logDuel != null) {
            this.predictedGf = this.mostVisitedIndex();
        }
    }

    private void synch() {
        if (time == (double)me.getTime()) {
            return;
        }
        timeSinceVChange += (double)me.getTime() - time;
        time = (int)me.getTime();
        targetLocation = new Point2D.Double(me.getX(), me.getY());
        if (Math.abs(me.getVelocity() - lastVelocity) > 0.5) {
            timeSinceVChange = 0.0;
        }
        myHeading = me.getHeadingRadians();
    }

    public boolean test() {
        this.synch();
        if (this.point != null) {
            this.point.point.setLocation(this.predictedLocation());
        }
        if (this.passed(18.0, time, targetLocation) && !this.passed(-18.0, time, targetLocation)) {
            double gf = this.visitingGf();
            if (me.getOthers() > 0) {
                double[][] buffers = Configuration.others > 1 ? this.enemy.logMelee.visitBuffers(this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex) : this.enemy.logDuel.visitBuffers(this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex);
                int i = 0;
                while (i < 15) {
                    recorder.registerVisit(gf, this.lowGf(gf, this.distance), this.highGf(gf, this.distance), buffers[i]);
                    ++i;
                }
            }
        }
        if (this.passed(-40.0, time, targetLocation)) {
            me.removeCustomEvent((Condition)this);
            this.enemy.remove(this);
        }
        return false;
    }

    protected Point2D.Double getTargetLocation() {
        return targetLocation;
    }

    public double danger(Point2D.Double location) {
        double val = 0.0;
        int index = RobocodeTools.toGF(this.visitingGf(location), Configuration.others > 1 ? this.enemy.logMelee.rawHits : this.enemy.logDuel.rawHits);
        double cHeading = myHeading + RobocodeTools.absoluteBearing(targetLocation, location);
        if (!this.enemy.flattenner()) {
            double i;
            int gf = this.predictedGf;
            if (this.enemy.isHeadOn()) {
                gf = 15;
            }
            if ((i = (double)Math.abs(gf - index)) < Math.ceil(30.0 * (Math.atan(18.0 / location.distance(this.getGunLocation())) / Math.asin(8.0 / this.velocity)))) {
                i /= 4.0;
            } else if (!BF.contains(location)) {
                i = 0.4;
            } else if (Math.abs(RobocodeTools.absoluteBearing(location, this.enemy.location) - cHeading) < 0.8975979010256552) {
                i /= 2.0;
            }
            val += 1.0 / i / Math.pow(Math.abs(1.0 + this.distanceToImpact(targetLocation, time) / this.velocity), 0.3);
        } else {
            int i = 1;
            while (i <= 30) {
                val += this.danger(i) / Math.pow(Math.abs(index - i) + 1, 0.5) / Math.pow(Math.abs(1.0 + this.distanceToImpact(targetLocation, time) / this.velocity), 0.5);
                ++i;
            }
        }
        return val;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        GFLog log;
        this.synch();
        GFLog gFLog = log = Configuration.others > 1 ? this.enemy.logMelee : this.enemy.logDuel;
        if (me.getOthers() <= 0) {
            return;
        }
        double gf = this.visitingGf(new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
        ++log.hit;
        if (Math.abs(RobocodeTools.toGF(gf, log.rawHits) - this.predictedGf) <= RobocodeTools.toGF(this.halfWidth(this.distance), log.rawHits) - RobocodeTools.toGF(-this.halfWidth(this.distance), log.rawHits) + 1) {
            ++log.goodHit;
        }
        if (Math.abs(RobocodeTools.toGF(gf, log.rawHits) - 15) <= RobocodeTools.toGF(this.halfWidth(this.distance), log.rawHits) - RobocodeTools.toGF(-this.halfWidth(this.distance), log.rawHits) + 1) {
            ++log.headOnHit;
        }
        double[][] buffers = log.hitBuffers(this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex);
        log.updateFactors(RobocodeTools.toGF(gf, log.rawHits), this.distance, this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex);
        int i = 0;
        while (i < 15) {
            this.registerHit(gf, this.lowGf(gf, this.distance), this.highGf(gf, this.distance), buffers[i]);
            ++i;
        }
        this.surfable = false;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (me.getOthers() <= 0) {
            return;
        }
        this.synch();
        GFLog log = Configuration.others > 1 ? this.enemy.logMelee : this.enemy.logDuel;
        double gf = this.visitingGf(new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
        ++log.hit;
        if (Math.abs(RobocodeTools.toGF(gf, log.rawHits) - this.predictedGf) <= RobocodeTools.toGF(this.halfWidth(this.distance), log.rawHits) - RobocodeTools.toGF(-this.halfWidth(this.distance), log.rawHits) + 1) {
            ++log.goodHit;
        }
        if (Math.abs(RobocodeTools.toGF(gf, log.rawHits) - 15) <= RobocodeTools.toGF(this.halfWidth(this.distance), log.rawHits) - RobocodeTools.toGF(-this.halfWidth(this.distance), log.rawHits) + 1) {
            ++log.headOnHit;
        }
        log.updateFactors(RobocodeTools.toGF(gf, log.rawHits), this.distance, this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex);
        double[][] buffers = log.hitBuffers(this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex);
        int i = 0;
        while (i < 15) {
            this.registerHit(gf, this.lowGf(gf, this.distance), this.highGf(gf, this.distance), buffers[i]);
            ++i;
        }
        this.surfable = false;
    }

    private int mostVisitedIndex() {
        GFLog log = Configuration.others > 1 ? this.enemy.logMelee : this.enemy.logDuel;
        double distance = this.gunLocation.distance(this.startLocation);
        double[][] buffers = log.hitBuffers(this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex);
        int bestGF = 15;
        int GF_ONE = 30;
        double bestVal = 0.0;
        int halfWidth = (int)Math.floor(Math.atan(18.0 / distance) * (double)GF_ONE);
        int gf = GF_ONE;
        while (gf > 0) {
            double tmp = 0.0;
            int i = Math.max(1, gf - halfWidth);
            while (i <= Math.min(gf + halfWidth, GF_ONE)) {
                int j = 0;
                while (j < 15) {
                    tmp += buffers[j][i] * GFLog.WEIGHTS[j];
                    ++j;
                }
                if (tmp > bestVal) {
                    bestGF = gf;
                    bestVal = tmp;
                }
                ++i;
            }
            --gf;
        }
        return bestGF;
    }

    protected void registerHit(double gf, double lowGf, double highGf, double[] gfs) {
        hitRecorder.registerVisit(gf, lowGf, highGf, gfs);
    }

    public double visitingGf(Point2D.Double location) {
        return RobocodeTools.bindToRange(Utils.normalRelativeAngle((double)(Math.atan2(location.x - this.gunLocation.x, location.y - this.gunLocation.y) - Math.atan2(this.startLocation.x - this.gunLocation.x, this.startLocation.y - this.gunLocation.y))) / this.maxEscapeAngle() * (double)this.bearingDirection, -1.0, 1.0);
    }

    private double danger(int index) {
        GFLog log = Configuration.others > 1 ? this.enemy.logMelee : this.enemy.logDuel;
        double[][] buffers = log.hitBuffers(this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex);
        double[][] buffersVisits = log.visitBuffers(this.powerIndex, this.velocityIndex, this.timeIndex, this.distanceIndex, this.wallIndex, this.bftIndex, this.accelIndex);
        double val = 0.0;
        int i = 0;
        while (i < 15) {
            val += (buffers[i][index] + buffersVisits[i][index] / 10.0) * GFLog.WEIGHTS[i];
            ++i;
        }
        return val;
    }

    protected VisitRecorder getRecorder() {
        return recorder;
    }

    public Point2D.Double predictedLocation() {
        double angle = RobocodeTools.absoluteBearing(this.gunLocation, this.startLocation) + ((double)this.predictedGf - 15.0) / 15.0 * this.maxEscapeAngle() * (double)this.bearingDirection;
        double distanceTraveled = this.velocity * (time - this.fireTime);
        return new Point2D.Double(this.gunLocation.x + Math.sin(angle) * distanceTraveled, this.gunLocation.y + Math.cos(angle) * distanceTraveled);
    }

    public void onPaint(Graphics2D g) {
        int radius = (int)(this.velocity * (time - this.fireTime));
        if (this.surfable) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.magenta);
        }
        g.drawOval((int)(this.gunLocation.x - (double)radius), (int)(Configuration.battleFieldHeigth - this.gunLocation.y - (double)radius), 2 * radius, 2 * radius);
    }
}

