/*
 * Decompiled with CFR 0.152.
 */
package ak;

import ak.AdvancedBullet;
import ak.DataWriter;
import ak.FiringStrategy;
import ak.LogData;
import ak.OtherBot;
import ak.RobotBody;
import ak.Statistic;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Fermat
extends AdvancedRobot {
    Vector otherBots;
    Vector bulletVector;
    RobotBody robotBody;
    int target;
    int previousTarget;
    int oneOnOneTarget;
    double[] pastVelocities;
    Point2D.Double[] pastPositions;
    double[] pastHeadings;
    double[] updateTime;
    double avgVelocity;
    boolean written;
    boolean reset;
    boolean oneWritten;
    boolean oneOnOne;
    boolean won;
    int hits;
    int misses;
    int hitBullets;
    int hitWalls;
    int hitRobots;
    int skippedTurns;
    int turns;

    public void run() {
        OtherBot bot = new OtherBot(this, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, "dummy");
        this.setColors(Color.black, Color.black, Color.blue);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRight(360.0);
        RobotBody.dodgeBullets.clear();
        this.previousTarget = -1;
        this.won = false;
        this.oneOnOne = this.getOthers() <= 1;
        this.skippedTurns = 0;
        this.hitRobots = 0;
        this.hitWalls = 0;
        this.hitBullets = 0;
        this.misses = 0;
        this.hits = 0;
        this.pastVelocities = new double[50];
        this.pastPositions = new Point2D.Double[50];
        this.pastHeadings = new double[50];
        this.updateTime = new double[50];
        int i = 0;
        while (i < 50) {
            this.updateTime[i] = -50.0;
            ++i;
        }
        double rwidth = this.getWidth();
        double rheight = this.getHeight();
        while (true) {
            this.doUpdates();
            this.target = this.findBestTarget();
            if (this.getOthers() == 1 && !this.written && this.target != -1) {
                this.oneOnOneTarget = this.target;
                this.writeToDataFile();
                this.readOneOnOneData(this.target);
                this.written = true;
            }
            if (this.target == -1 || this.getOthers() == 0) {
                this.execute();
                continue;
            }
            double currTime = this.getTime();
            bot = (OtherBot)this.otherBots.elementAt(this.target);
            i = 0;
            while (i < this.bulletVector.size()) {
                AdvancedBullet adBullet = (AdvancedBullet)this.bulletVector.elementAt(i);
                Point2D.Double currPos = adBullet.getCurrentPosition(currTime);
                bot = (OtherBot)this.otherBots.elementAt(adBullet.targetBot);
                double inc = 0.1;
                while (inc < 1.1) {
                    currPos = adBullet.getCurrentPosition(currTime - 1.0 + inc);
                    Point2D.Double botPos = new Point2D.Double(bot.prevX + (currTime - 1.0 + inc - (double)bot.previousScanTime) * (bot.X - bot.prevX) / (double)(bot.scanTime - bot.previousScanTime), bot.prevY + (currTime - 1.0 + inc - (double)bot.previousScanTime) * (bot.Y - bot.prevY) / (double)(bot.scanTime - bot.previousScanTime));
                    if (this.getDistance(currPos.x, currPos.y, botPos.x, botPos.y) < Math.min(rwidth / (double)2, rheight / (double)2)) {
                        Statistic stat = (Statistic)bot.stats.elementAt(adBullet.strategy);
                        ++stat.numHits;
                        ++stat.numShots;
                        this.bulletVector.remove(i);
                        --i;
                        break;
                    }
                    inc += 0.1;
                }
                if (!(inc < 1.1) && this.getDistance(currPos.x, currPos.y, adBullet.source.x, adBullet.source.y) > this.getDistance(bot.X, bot.Y, adBullet.source.x, adBullet.source.y) + Math.max(rwidth, rheight)) {
                    Statistic stat = (Statistic)bot.stats.elementAt(adBullet.strategy);
                    ++stat.numShots;
                    this.bulletVector.remove(i);
                    --i;
                }
                ++i;
            }
            bot.fireBot(this);
        }
    }

    void doUpdates() {
        this.setTurnRadarLeft(this.getScanAngle());
        this.updateAttackers();
        this.pastVelocities[(int)(this.getTime() % 50L)] = this.getVelocity();
        this.pastPositions[(int)(this.getTime() % 50L)] = new Point2D.Double(this.getX(), this.getY());
        this.pastHeadings[(int)(this.getTime() % 50L)] = this.getHeading();
        this.updateTime[(int)(this.getTime() % 50L)] = this.getTime();
        Point2D.Double dirP = this.robotBody.getDirection(this.otherBots, this, 0);
        this.goTo(this.getX() - dirP.x, this.getY() - dirP.y);
        if (this.avgVelocity == -1.0) {
            this.avgVelocity = Math.abs(this.getVelocity());
            this.turns = 1;
        } else if (this.getVelocity() != 0.0) {
            ++this.turns;
            this.avgVelocity = (this.avgVelocity * (double)(this.turns - 1) + Math.abs(this.getVelocity())) / (double)this.turns;
        }
    }

    void writeOneOnOneData(int target) {
        if (target == -1) {
            return;
        }
        try {
            OtherBot bot = (OtherBot)this.otherBots.elementAt(target);
            PrintStream tps = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(bot.name + ".1v1.txt")));
            int j = 0;
            while (j < bot.stats.size()) {
                Statistic stat = (Statistic)bot.stats.elementAt(j);
                tps.println(stat.numShots);
                tps.println(stat.numHits);
                ++j;
            }
            tps.println(bot.lastWin);
            tps.println(bot.movementStrategy);
            if (tps.checkError()) {
                this.out.println("Error writing data to robot file");
            }
            tps.close();
        }
        catch (IOException ex) {
            this.out.println("Could not write Data");
        }
    }

    /*
     * Unable to fully structure code
     */
    void readOneOnOneData(int target) {
        block6: {
            bot = (OtherBot)this.otherBots.elementAt(target);
            bot.rollingAvgVelocity = bot.rollingAvgStopVelocity = Math.abs(bot.velocity);
            bot.avgStopVelocity = bot.rollingAvgStopVelocity = bot.rollingAvgStopVelocity;
            bot.avgVelocity = bot.rollingAvgStopVelocity;
            bot.rollingAvgStraightHeadingChange = 0.0;
            bot.rollingAvgHeadingChange = 0.0;
            bot.avgStraightHeadingChange = 0.0;
            bot.avgHeadingChange = 0.0;
            bot.headingChange = 0.0;
            bot.stats = new Vector<E>();
            bot.straightHeadingScans = 1;
            bot.stopVelocityScans = 1;
            bot.headingScans = 1;
            bot.velocityScans = 1;
            this.reset = false;
            bot.logTable.clear();
            bot.logStartTime = this.getTime();
            bot.logTable.put(new Integer((int)this.getTime()), new LogData(0.0, bot.velocity));
            bot.scanTime = this.getTime();
            try {
                br = new BufferedReader(new FileReader(this.getDataFile(bot.name + ".1v1.txt")));
                i = 0;
                while (i < FiringStrategy.count) {
                    stat = new Statistic();
                    stat.numShots = Integer.parseInt(br.readLine());
                    stat.numHits = Integer.parseInt(br.readLine());
                    bot.stats.addElement(stat);
                    ++i;
                }
                bot.lastWin = Integer.parseInt(br.readLine());
                bot.movementStrategy = Integer.parseInt(br.readLine());
                bot.movementStrategy = 1 - bot.movementStrategy;
                break block6;
            }
            catch (Exception exp1) {
                this.reset = true;
                bot.stats.clear();
                i = 0;
                ** while (i < FiringStrategy.count)
            }
lbl-1000:
            // 1 sources

            {
                stat = new Statistic();
                stat.numHits = 1;
                stat.numShots = 2;
                bot.stats.addElement(stat);
                ++i;
                continue;
            }
lbl46:
            // 1 sources

            bot.lastWin = 0;
            bot.movementStrategy = 0;
        }
        if (bot.lastWin > 5) {
            bot.stats.clear();
            i = 0;
            while (i < FiringStrategy.count) {
                stat = new Statistic();
                stat.numHits = 1;
                stat.numShots = 2;
                bot.stats.addElement(stat);
                ++i;
            }
            bot.lastWin = 0;
        }
    }

    double getScanAngle() {
        OtherBot bot;
        int scanBot = -1;
        long minTime = 1000000000L;
        double minDist = 1.0E30;
        if (this.otherBots.size() < this.getOthers()) {
            return 360.0;
        }
        int i = 0;
        while (i < this.otherBots.size()) {
            bot = (OtherBot)this.otherBots.elementAt(i);
            if (bot.alive && (bot.scanTime < minTime || bot.scanTime == minTime && this.getDistance(bot.X, bot.Y, this.getX(), this.getY()) < minDist)) {
                minTime = bot.scanTime;
                minDist = this.getDistance(bot.X, bot.Y, this.getX(), this.getY());
                scanBot = i;
            }
            ++i;
        }
        if (scanBot == -1 || this.getTime() - minTime > 8L) {
            return 360.0;
        }
        bot = (OtherBot)this.otherBots.elementAt(scanBot);
        double turn = this.findRadarTurn(bot.X, bot.Y);
        if (turn < 0.0) {
            return turn - 20.0;
        }
        return turn + 20.0;
    }

    public void onHitWall(HitWallEvent e) {
        ++this.hitWalls;
    }

    public void onHitRobot(HitRobotEvent e) {
        ++this.hitRobots;
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++this.skippedTurns;
    }

    public void onBulletMissed(BulletMissedEvent e) {
        ++this.misses;
    }

    public void onBulletHit(BulletHitEvent e) {
        ++this.hits;
    }

    void updateAttackers() {
        OtherBot botB;
        int nearest = -1;
        double min = 1.0E30;
        int i = 0;
        while (i < this.otherBots.size()) {
            OtherBot botA = (OtherBot)this.otherBots.elementAt(i);
            if (botA.alive) {
                double dist = (botA.X - this.getX()) * (botA.X - this.getX()) + (botA.Y - this.getY()) * (botA.Y - this.getY());
                if (dist < min) {
                    min = dist;
                    nearest = i;
                }
                int j = 0;
                while (j < this.otherBots.size()) {
                    if (i != j) {
                        botB = (OtherBot)this.otherBots.elementAt(j);
                        if (botB.alive && (botA.X - botB.X) * (botA.X - botB.X) + (botA.Y - botB.Y) * (botA.Y - botB.Y) < dist) break;
                    }
                    ++j;
                }
                if (j == this.otherBots.size()) {
                    botA.lastAttackTime = this.getTime();
                    botA.attacking = true;
                }
            }
            ++i;
        }
        int attackers = 0;
        i = 0;
        while (i < this.otherBots.size()) {
            botB = (OtherBot)this.otherBots.elementAt(i);
            if (!botB.alive || (double)this.getTime() - botB.lastAttackTime > 10.0) {
                botB.attacking = false;
            }
            if (botB.attacking) {
                ++attackers;
            }
            ++i;
        }
        if (attackers == 0 && nearest != -1) {
            botB = (OtherBot)this.otherBots.elementAt(nearest);
            botB.lastAttackTime = this.getTime();
            botB.attacking = true;
        }
    }

    int findBestTarget() {
        int target = -1;
        double minValue = 1.0E30;
        int i = 0;
        while (i < this.otherBots.size()) {
            OtherBot bot = (OtherBot)this.otherBots.elementAt(i);
            if (bot.alive) {
                double turn = Math.abs(this.findGunTurn(bot.X, bot.Y));
                double value = Math.pow((bot.X - this.getX()) * (bot.X - this.getX()) + (bot.Y - this.getY()) * (bot.Y - this.getY()), 2) * Math.pow(45.0 + turn, 0.5);
                if (value < minValue) {
                    minValue = value;
                    target = i;
                }
            }
            ++i;
        }
        return target;
    }

    double findGunTurn(double x, double y) {
        double angle = this.normalAbsoluteHeading(Math.toDegrees(1.5707963267948966 - Math.atan2(this.getY() - y, this.getX() - x)));
        return this.normalRelativeAngle(this.getGunHeading() - angle + 180.0);
    }

    double findRadarTurn(double x, double y) {
        double angle = this.normalAbsoluteHeading(Math.toDegrees(1.5707963267948966 - Math.atan2(this.getY() - y, this.getX() - x)));
        return this.normalRelativeAngle(this.getRadarHeading() - angle + 180.0);
    }

    void goTo(double x, double y) {
        double angle = this.normalAbsoluteHeading(Math.toDegrees(1.5707963267948966 - Math.atan2(this.getY() - y, this.getX() - x)));
        int dir = 1;
        angle = this.normalRelativeAngle(this.getHeading() - angle + 180.0);
        if (angle > 90.0) {
            angle -= 180.0;
            dir = -1;
        } else if (angle < -90.0) {
            angle += 180.0;
            dir = -1;
        }
        this.setTurnLeft(angle);
        this.setAhead(20 * dir);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        OtherBot bot;
        int i = 0;
        while (i < this.otherBots.size()) {
            bot = (OtherBot)this.otherBots.elementAt(i);
            if (bot.name == e.getName()) {
                bot.update(e.getEnergy(), this.getX() + e.getDistance() * Math.cos(Math.toRadians(this.normalRelativeAngle(90.0 - (this.getHeading() + e.getBearing())))), this.getY() + e.getDistance() * Math.sin(Math.toRadians(this.normalRelativeAngle(90.0 - (this.getHeading() + e.getBearing())))), e.getHeading(), e.getVelocity(), this.getTime());
                break;
            }
            ++i;
        }
        if (i == this.otherBots.size()) {
            bot = new OtherBot(this, e.getEnergy(), this.getX() + e.getDistance() * Math.cos(Math.toRadians(this.normalRelativeAngle(90.0 - (this.getHeading() + e.getBearing())))), this.getY() + e.getDistance() * Math.sin(Math.toRadians(this.normalRelativeAngle(90.0 - (this.getHeading() + e.getBearing())))), e.getHeading(), e.getVelocity(), this.getTime(), e.getName());
            this.otherBots.addElement(bot);
        }
    }

    public void printStats() {
        this.out.println("Hits/Shots(%): " + this.hits + '/' + (this.hits + this.misses) + " ( " + (int)((double)this.hits * 100.0 / (double)(this.hits + this.misses)) + "% )");
        this.out.println("Hit by Bullets: " + this.hitBullets);
        this.out.println("Hit Other Robots: " + this.hitRobots);
        this.out.println("Hit Walls: " + this.hitWalls);
        this.out.println("Skipped Turns: " + this.skippedTurns);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        int i = 0;
        while (i < this.otherBots.size()) {
            OtherBot bot = (OtherBot)this.otherBots.elementAt(i);
            if (bot.name == e.getName()) {
                bot.alive = false;
                break;
            }
            ++i;
        }
    }

    public double normalAbsoluteHeading(double angle) {
        if (angle < 0.0) {
            return 360.0 + angle % 360.0;
        }
        return angle % 360.0;
    }

    public double normalRelativeAngle(double angle) {
        if (angle > 180.0) {
            return (angle + 180.0) % 360.0 - 180.0;
        }
        if (angle < -180.0) {
            return (angle - 180.0) % 360.0 + 180.0;
        }
        return angle;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        ++this.hitBullets;
        int j = 0;
        while (j < this.otherBots.size()) {
            OtherBot bot = (OtherBot)this.otherBots.elementAt(j);
            if (bot.name == e.getName()) {
                bot.lastAttackTime = this.getTime();
                bot.attacking = true;
                break;
            }
            ++j;
        }
    }

    public void writeToDataFile() {
        DataWriter dataWriter = new DataWriter(this);
        dataWriter.start();
    }

    public void onDeath(DeathEvent e) {
        if (!this.won) {
            this.out.println("Robots Remaining: " + this.getOthers());
            this.printStats();
            if (this.getOthers() > 1 && !this.written) {
                this.writeToDataFile();
                this.written = true;
            } else {
                if (this.oneOnOneTarget == -1) {
                    return;
                }
                OtherBot bot = (OtherBot)this.otherBots.elementAt(this.oneOnOneTarget);
                ++bot.lastWin;
                this.writeOneOnOneData(this.oneOnOneTarget);
            }
        }
    }

    public void onWin(WinEvent e) {
        this.out.println("I won, Yo!");
        this.won = true;
        this.printStats();
        if (this.oneOnOneTarget == -1) {
            return;
        }
        OtherBot bot = (OtherBot)this.otherBots.elementAt(this.oneOnOneTarget);
        bot.lastWin = 0;
        this.writeOneOnOneData(this.oneOnOneTarget);
    }

    double getDistance(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        return Math.sqrt(x * x + y * y);
    }

    private final /* synthetic */ void this() {
        this.otherBots = new Vector();
        this.bulletVector = new Vector();
        this.robotBody = new RobotBody();
        this.oneOnOneTarget = -1;
        this.avgVelocity = -1.0;
        this.written = false;
        this.reset = true;
        this.oneWritten = false;
        this.won = false;
        this.turns = 0;
    }

    public Fermat() {
        this.this();
    }
}

