/*
 * Decompiled with CFR 0.152.
 */
package origin;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import origin.EDataDispVector;
import origin.Enemy;
import origin.EnemyML;
import origin.EnemyStateML;
import origin.Wave;
import util.Vector2D;

public class SelfWave
extends Wave {
    private long aliveTime;
    private static long maxAliveTime;
    private ConcurrentHashMap<String, Enemy> enemies;
    private HashMap<String, EnemyML> enemiesml;
    private HashMap<String, EnemyStateML> eStartStates;
    private HashMap<String, Point2D.Double> eStartLocs;
    private boolean remove = false;

    public SelfWave(double centerX, double centerY, long startTime, double bulletPower, ConcurrentHashMap<String, Enemy> enemies, HashMap<String, EnemyML> enemiesml) {
        super(centerX, centerY, startTime, bulletPower);
        this.enemies = enemies;
        this.enemiesml = enemiesml;
        this.eStartStates = new HashMap();
        this.eStartLocs = new HashMap();
        for (Map.Entry<String, Enemy> e : enemies.entrySet()) {
            String cName = e.getKey();
            Enemy cEnemy = e.getValue();
            EnemyStateML nState = new EnemyStateML(cEnemy.getDistance(), cEnemy.getHeading(), cEnemy.getVelocity(), cEnemy.getLatestTurnRate(), cEnemy.getTimeSinceDecel());
            this.eStartStates.put(cName, nState);
            this.eStartLocs.put(cName, cEnemy.getLocation());
        }
    }

    public void update(long currentTime) {
        if (this.aliveTime > maxAliveTime || this.eStartStates.size() == 0) {
            this.remove = true;
        }
        double cRad = this.getRad(currentTime);
        Iterator<String> iterator = this.eStartStates.keySet().iterator();
        while (iterator.hasNext()) {
            double eY;
            String uncrashedEnemy = iterator.next();
            if (!this.enemies.containsKey(uncrashedEnemy)) {
                iterator.remove();
                continue;
            }
            Enemy cEnemy = this.enemies.get(uncrashedEnemy);
            double eX = cEnemy.getX();
            double bearing = Math.atan2(eX - this.centerX, (eY = cEnemy.getY()) - this.centerY);
            Point2D.Double waveClosestPos = new Point2D.Double(this.centerX + cRad * Math.sin(bearing), this.centerY + cRad * Math.cos(bearing));
            if (!(waveClosestPos.distance(cEnemy.getLocation()) < 20.0)) continue;
            Vector2D dVector = new Vector2D(this.eStartLocs.get(uncrashedEnemy), cEnemy.getLocation());
            this.enemiesml.get(uncrashedEnemy).addData(new EDataDispVector(this.eStartStates.get(uncrashedEnemy), dVector));
            iterator.remove();
        }
    }

    public boolean getRemove() {
        return this.remove;
    }
}

