/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.geom.Point2D;

public class Vector2D
extends Point2D {
    Point2D startPos;
    private double angle;
    private double magnitude;

    public Vector2D(Point2D startPos, double a, double m) {
        this.startPos = new Point2D.Double(startPos.getX(), startPos.getY());
        this.angle = a;
        this.magnitude = m;
    }

    public Vector2D(Point2D startPos, Point2D endPos) {
        this.startPos = startPos;
        this.angle = Math.atan2(endPos.getX() - startPos.getX(), endPos.getY() - startPos.getY());
        this.magnitude = startPos.distance(endPos);
    }

    public Vector2D(double a, double m) {
        this.angle = a;
        this.magnitude = m;
    }

    public Point2D getStartPos() {
        return new Point2D.Double(this.startPos.getX(), this.startPos.getY());
    }

    public double getAngle() {
        return this.angle;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(double m) {
        this.magnitude = m;
    }

    public void scaleMagnitude(double scaleFactor) {
        this.magnitude *= scaleFactor;
    }

    public Point2D.Double project() {
        return new Point2D.Double(Math.sin(this.angle) * this.magnitude, Math.cos(this.angle) * this.magnitude);
    }

    public Point2D.Double projectFromStartPos(double scaleFactor) {
        return new Point2D.Double(this.startPos.getX() + Math.sin(this.angle) * this.magnitude * scaleFactor, this.startPos.getY() + Math.cos(this.angle) * this.magnitude * scaleFactor);
    }

    @Override
    public double getX() {
        return this.startPos.getX();
    }

    @Override
    public double getY() {
        return this.startPos.getY();
    }

    @Override
    public void setLocation(double arg0, double arg1) {
        this.startPos = new Point2D.Double(arg0, arg1);
    }
}

