/*
 * Decompiled with CFR 0.152.
 */
package kenran.sight;

import java.awt.geom.Point2D;
import kenran.Bakko;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class HeroicGaze {
    private final Bakko _bakko;
    private final double _lockMultiplier;

    public HeroicGaze(Bakko bakko, double lockMultiplier) {
        this._bakko = bakko;
        this._lockMultiplier = lockMultiplier;
        this._bakko.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyBearing = this._bakko.getHeadingRadians() + e.getBearingRadians();
        double radarAngle = enemyBearing - this._bakko.getRadarHeadingRadians();
        Point2D.Double enemyPosition = kenran.util.Utils.project(this._bakko.getPosition(), enemyBearing, e.getDistance());
        this._bakko.setEnemyPosition(enemyPosition);
        this._bakko.setTurnRadarRightRadians(this._lockMultiplier * Utils.normalRelativeAngle((double)radarAngle));
    }

    public void lookForEscapedEnemy() {
        if (this._bakko.getRadarTurnRemainingRadians() == 0.0 && !this._bakko.hasWon()) {
            System.out.println("\tRadar slipped. Readjusting...");
            this._bakko.setTurnRadarLeftRadians(Double.POSITIVE_INFINITY);
        }
    }
}

