/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.ArrayList;
import java.util.List;
import robocode.DeathEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import tcf.HistRec;
import tcf.MyRules;
import tcf.PatEntry;
import tcf.Pattern;
import tcf.PatternStore;
import tcf.Repat3;
import tcf.Utils;
import tcf.Vec2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Opponent {
    public static final int HISTORY_LEN = 200;
    public static final char INVALID_SYMBOL = '\uffff';
    public static final int PAT1_LEN = 15;
    public static final int PAT2_LEN = 30;
    public Repat3 m_r = null;
    public String m_name = null;
    public boolean m_isAlive = true;
    public Vec2d m_curPos = null;
    public Vec2d m_prevPos = null;
    public double m_lastFireTime;
    public double m_lastBulletPower;
    public double m_nextTimeCanFire;
    public ScannedRobotEvent m_curScan = null;
    public ScannedRobotEvent m_prevScan = null;
    public double m_firePower = 3.0;
    private int m_histIdx = 0;
    private HistRec[] m_history = new HistRec[200];
    private static PatternStore m_patterns;

    public Opponent(Repat3 r, PatternStore patterns) {
        this.m_r = r;
        m_patterns = patterns;
        this.startNewRound();
    }

    public void startNewRound() {
        for (int i = 0; i < 200; ++i) {
            this.m_history[i] = new HistRec();
        }
        this.m_prevScan = null;
        this.m_curScan = null;
        this.m_prevPos = null;
        this.m_curPos = null;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.m_curScan == null) {
            for (int i = 0; i < 200; ++i) {
                this.m_history[i].m_ang = e.getHeading();
            }
        }
        this.m_prevScan = this.m_curScan;
        this.m_curScan = e;
        double oppBearing = this.m_r.getHeading() + e.getBearing();
        this.m_prevPos = this.m_curPos;
        this.m_curPos = this.m_r.location().plus(Vec2d.polar(oppBearing, e.getDistance()));
        HistRec hr0 = this.getHistory(0);
        double newEdge = Utils.distToEdge((Robot)this.m_r, this.m_curPos.x, this.m_curPos.y);
        double newVel = e.getVelocity();
        double newDist = hr0.m_dist + newVel;
        double newHead = e.getHeading();
        if (this.m_prevScan != null) {
            double deltaHead = 0.0;
            long startTime = this.m_prevScan.getTime();
            long rangeTime = e.getTime() - startTime;
            double startEdge = hr0.m_edge;
            double rangeEdge = newEdge - startEdge;
            double startVel = this.m_prevScan.getVelocity();
            double rangeVel = e.getVelocity() - startVel;
            double startDist = hr0.m_dist;
            double rangeDist = (e.getVelocity() + startVel) * (double)rangeTime / 2.0;
            double startHead = hr0.m_ang;
            double rangeHead = Utils.normAngle180(e.getHeading() - hr0.m_ang);
            for (long deltaTime = 1L; deltaTime < rangeTime; ++deltaTime) {
                double propTime = deltaTime / rangeTime;
                double edge = startEdge + rangeEdge * propTime;
                double vel = startVel + rangeVel * propTime;
                double dist = startDist + rangeDist * propTime;
                double head = startHead + rangeHead * propTime;
                this.addToHistory(edge, vel, dist, head);
            }
            if (rangeTime > 1L) {
                newDist = startDist + rangeDist;
            }
        }
        this.addToHistory(newEdge, newVel, newDist, newHead);
        hr0 = this.getHistory(1);
        Vec2d myPos = this.m_r.location();
        Vec2d oppPos = Utils.project(myPos, oppBearing, e.getDistance());
        double oppHeading = e.getHeading();
        double oppSpeed = e.getVelocity();
        char symbol = Opponent.encode(oppHeading - hr0.m_ang, oppSpeed);
        if (symbol != '\uffff') {
            Pattern p = this.createPattern(1);
            this.record(p, symbol);
        }
    }

    public boolean aimAndFireGun(List<Vec2d> predictions) {
        if (predictions != null) {
            predictions.clear();
        }
        Vec2d myPos = this.m_r.location();
        Vec2d oppPos = this.m_curPos;
        double oppHeading = this.m_curScan.getHeading();
        double oppSpeed = this.m_curScan.getVelocity();
        int t = 0;
        double fireSpeed = MyRules.getBulletSpeed(this.m_firePower);
        for (double d = 0.0; d < myPos.distance(oppPos); d += fireSpeed) {
            Pattern pattern = this.createPattern(-t);
            char symbol = this.predict(pattern);
            Vec2d oldOppPos = oppPos;
            oppSpeed = Opponent.decodeSpeed(symbol);
            oppPos = Utils.project(oppPos, oppHeading += Opponent.decodeDeltaHeading(symbol), oppSpeed);
            boolean wall = false;
            if (oppPos.x < 17.99) {
                wall = true;
                oppPos.x = 18.0;
            } else if (oppPos.x > this.m_r.getBattleFieldWidth() - 17.99) {
                wall = true;
                oppPos.x = this.m_r.getBattleFieldWidth() - 18.0;
            }
            if (oppPos.y < 17.99) {
                wall = true;
                oppPos.y = 18.0;
            } else if (oppPos.y > this.m_r.getBattleFieldHeight() - 17.99) {
                wall = true;
                oppPos.y = this.m_r.getBattleFieldHeight() - 18.0;
            }
            if (predictions != null) {
                predictions.add(oppPos);
            }
            if (wall) {
                oppSpeed = 0.0;
            }
            HistRec hrT0 = this.getHistory(-t);
            double dist = hrT0.m_dist + oppSpeed;
            double ang = oppHeading;
            HistRec hrT1 = this.getHistory(-(t + 1));
            hrT1.m_edge = Utils.distToEdge((Robot)this.m_r, oldOppPos.x, oldOppPos.y);
            hrT1.m_vel = oppSpeed;
            hrT1.m_dist = dist;
            hrT1.m_ang = ang;
            ++t;
        }
        double oppBearing = oppPos.minus(myPos).getHeading();
        double gunTurn = oppBearing - this.m_r.getGunHeading();
        this.m_r.setTurnGunRight(Utils.normAngle180(gunTurn));
        boolean fired = false;
        if (this.m_r.getGunHeat() == 0.0) {
            this.m_r.setFire(this.m_firePower);
            fired = true;
        }
        return fired;
    }

    public void addToHistory(double edge, double vel, double dist, double head) {
        this.m_histIdx = (this.m_histIdx + 200 - 1) % 200;
        this.m_history[this.m_histIdx].m_edge = edge;
        this.m_history[this.m_histIdx].m_vel = vel;
        this.m_history[this.m_histIdx].m_dist = dist;
        this.m_history[this.m_histIdx].m_ang = head;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.m_prevScan = null;
        this.m_curScan = null;
        this.m_prevPos = null;
        this.m_curPos = null;
    }

    public void onDeath(DeathEvent e) {
        this.m_prevScan = null;
        this.m_curScan = null;
        this.m_prevPos = null;
        this.m_curPos = null;
    }

    private HistRec getHistory(int deltaT) {
        int idx = (this.m_histIdx + 200 + deltaT) % 200;
        return this.m_history[idx];
    }

    public Pattern createPattern(int deltaT) {
        HistRec hr0 = this.getHistory(deltaT);
        HistRec hr1 = this.getHistory(deltaT + 15);
        HistRec hr2 = this.getHistory(deltaT + 15 + 30);
        double edge = hr0.m_edge;
        double vel = hr0.m_vel;
        double dist1 = hr0.m_dist - hr1.m_dist;
        double dist2 = hr0.m_dist - hr2.m_dist;
        double ang1 = Utils.normAngle180(hr0.m_ang - hr1.m_ang);
        double ang2 = Utils.normAngle180(hr0.m_ang - hr2.m_ang);
        return new Pattern(edge, vel, dist1, dist2, ang1, ang2);
    }

    public void doTickUpdate() {
        this.chooseFirePower();
    }

    private void chooseFirePower() {
        ScannedRobotEvent e = this.m_curScan;
        if (e == null) {
            return;
        }
        double dist = e.getDistance();
        double firePower = 3.0;
        firePower = dist > 100.0 ? (this.m_r.getEnergy() > 55.0 ? 3.0 : (this.m_r.getEnergy() > 25.0 ? 2.0 : (this.m_r.getEnergy() > 10.0 ? 1.0 : (this.m_r.getEnergy() > 2.5 ? 0.5 : 0.1)))) : 3.0;
        if (dist > 750.0) {
            firePower = Math.min(0.5, firePower);
        }
        if ((firePower = Math.max(0.1, Math.min(firePower, 3.0))) != this.m_firePower) {
            this.m_firePower = firePower;
        }
    }

    public void doTargetUpdate() {
        ScannedRobotEvent e = this.m_curScan;
    }

    private void record(Pattern pattern, char symbol) {
        ArrayList<PatEntry> info = m_patterns.get(pattern);
        if (info == null) {
            info = new ArrayList();
            m_patterns.put(pattern, info);
        }
        PatEntry found = null;
        for (PatEntry pi : info) {
            if (pi.m_symbol != symbol) continue;
            found = pi;
            break;
        }
        if (found == null) {
            found = new PatEntry();
            found.m_symbol = symbol;
            info.add(found);
        }
        ++found.m_frequency;
    }

    private char predict(Pattern pattern) {
        ArrayList<PatEntry> info = m_patterns.get(pattern);
        if (info == null) {
            Pattern p2 = m_patterns.getClosestPattern(pattern);
            if (p2 != null) {
                info = m_patterns.get(p2);
            } else {
                return Opponent.encode(0.0, 0.0);
            }
        }
        PatEntry best = null;
        for (PatEntry pi : info) {
            if (best != null && best.m_frequency >= pi.m_frequency) continue;
            best = pi;
        }
        return best.m_symbol;
    }

    private static char encode(double deltaHeading, double speed) {
        if (Math.abs(deltaHeading) > 10.0) {
            return '\uffff';
        }
        int dhCode = (int)Math.rint(deltaHeading * 4.0 + 40.0);
        int spdCode = (int)Math.rint(speed + 8.0);
        return (char)(dhCode * 17 + spdCode);
    }

    private static double decodeDeltaHeading(char symbol) {
        return (double)(symbol / 17 - 40) * 0.25;
    }

    private static int decodeSpeed(char symbol) {
        return symbol % 17 - 8;
    }
}

