/*
 * Decompiled with CFR 0.152.
 */
package drm.parts;

import drm.common3.Brain;
import drm.common3.BulletStore;
import drm.common3.Coordinate;
import drm.common3.Driver;
import drm.common3.Enemy;
import drm.common3.Gun;
import drm.common3.Mech;
import drm.common3.Motor;
import drm.common3.Radar;
import drm.common3.Utils;
import drm.parts.MeleeDriver;
import drm.parts.ShadowDriver;
import java.util.Enumeration;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AssaultDriver
extends Driver {
    static final double ACC_BRK_RATE = 1.0;
    static final int STATE_ASSAULT = 0;
    static final int STATE_ESCAPE = 1;
    static final int STATE_ROTATE = 2;
    static final double DRIVER_CHANGE_DAMAGE_RATE = 2.0;
    static boolean bulletHitFlag = false;
    static int roundNum = 0;
    static int transformed = 0;
    double maxOwnArea;
    Radar radar;
    Motor motor;
    Gun gun;
    int loopCount;
    int awayCount;
    int maxAwayCount;
    int state;
    int accThrd;
    boolean awayFlg;
    boolean reverseFlg;
    boolean angryFlg;
    boolean angryFlg2;
    boolean nextReverseFlg;
    boolean awayStopCancelFlg;
    boolean escapeFinishFlg;
    BulletStore avoidBullet;
    Random random;
    double firstMyEnergy;
    double firstEnemyEnergy;
    Enemy prevEnemy;
    int normalBulletHitCount;
    int bulletHitCount;
    int sameEscCount;
    int rotateMoveCount;
    int rotateBulletHitCount;

    public void init() {
        if (this.getMechas() != null) {
            this.radar = (Radar)this.getMech(0);
            this.motor = (Motor)this.getMech(1);
            this.gun = (Gun)this.getMech(2);
        }
    }

    public void initialize() {
        super.initialize();
        this.maxOwnArea = this.getAdvancedRobot().getBattleFieldHeight() / (double)4;
        if (this.maxOwnArea < this.getAdvancedRobot().getBattleFieldWidth() / (double)4) {
            this.maxOwnArea = this.getAdvancedRobot().getBattleFieldWidth() / (double)4;
        }
        this.motor.setSpeed(0.0);
        this.gun.setBulletPower(1.0);
        if (this.getAdvancedRobot().getRoundNum() != roundNum) {
            transformed = 0;
            bulletHitFlag = false;
        }
        roundNum = this.getAdvancedRobot().getRoundNum();
        this.reverseFlg = this.random.nextBoolean();
        this.awayFinish();
    }

    public void move() {
        super.move();
        switch (this.state) {
            case 0: {
                this.assaultMove();
                break;
            }
            case 1: {
                this.escapeMove();
                break;
            }
            case 2: {
                this.rotateMove();
                break;
            }
            default: {
                this.assaultMove();
            }
        }
        this.changeDriver();
    }

    void rotateMove() {
        boolean rotateFinishFlg = false;
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null && enemy.getNewEnemyInfo().x != -99999.0 && enemy.getNewEnemyInfo().y != -99999.0 && enemy.getNewEnemyInfo().heading != -99999.0 && enemy.getNewEnemyInfo().velocity != -99999.0 && enemy.getNewEnemyInfo().distance != -99999.0 && enemy.getNewEnemyInfo().time == this.getAdvancedRobot().getTime()) {
            this.aim(enemy);
            BulletStore avoidBullet = this.getBrain().getNearestBullet();
            if (avoidBullet != null && avoidBullet.distance < 20.0 * avoidBullet.velocity) {
                rotateFinishFlg = true;
            }
            if (this.rotateMoveCount == 0) {
                this.rotateBulletHitCount = this.bulletHitCount + this.normalBulletHitCount;
            }
            if (this.rotateMoveCount++ > 10) {
                rotateFinishFlg = true;
            }
            if (this.rotateBulletHitCount < this.bulletHitCount + this.normalBulletHitCount) {
                rotateFinishFlg = true;
            }
        }
        double turnAngle = Utils.getRobotMaxTurning(this.getAdvancedRobot().getVelocity()) - this.random.nextDouble() * 10.0;
        if (this.reverseFlg) {
            turnAngle = -turnAngle;
        }
        this.motor.setTurn(turnAngle);
        if (rotateFinishFlg) {
            this.rotateMoveCount = 0;
            this.state = 1;
        }
    }

    void escapeMove() {
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            if (enemy.getNewEnemyInfo().x != -99999.0 && enemy.getNewEnemyInfo().y != -99999.0 && enemy.getNewEnemyInfo().heading != -99999.0 && enemy.getNewEnemyInfo().velocity != -99999.0 && enemy.getNewEnemyInfo().distance != -99999.0 && enemy.getNewEnemyInfo().time == this.getAdvancedRobot().getTime()) {
                this.aim(enemy);
                this.escapeFinishFlg = false;
                double x = this.getAdvancedRobot().getBattleFieldWidth() - enemy.getNewEnemyInfo().x;
                double y = this.getAdvancedRobot().getBattleFieldHeight() - enemy.getNewEnemyInfo().y;
                if (!this.reverseFlg) {
                    this.motor.setAheadPoint(x, y);
                } else {
                    this.motor.setAheadPoint(this.getAdvancedRobot().getX() * (double)2 - x, this.getAdvancedRobot().getY() * (double)2 - y);
                }
                if (Math.abs(Utils.calcDistance(x, y, this.getAdvancedRobot().getX(), this.getAdvancedRobot().getY())) < Utils.getRobotR()) {
                    this.away(0L);
                } else {
                    this.away(100L);
                }
                double turnAngle = 10.0 - this.random.nextDouble() * 20.0;
                this.motor.setTurn(turnAngle);
                this.escapeFinishFlg = true;
            }
        } else {
            this.aimCancel();
        }
        if (this.awayFlg) {
            this.loopAccelAndBrake();
        }
        if (enemy != null && this.motor.getSpeed() == 0.0 && this.escapeFinishFlg) {
            this.motor.resetAheadPoint();
            this.motor.resetTargetPoint();
            this.state = 0;
        }
    }

    void assaultMove() {
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            if (enemy.getNewEnemyInfo().x != -99999.0 && enemy.getNewEnemyInfo().y != -99999.0 && enemy.getNewEnemyInfo().heading != -99999.0 && enemy.getNewEnemyInfo().velocity != -99999.0 && enemy.getNewEnemyInfo().distance != -99999.0 && enemy.getNewEnemyInfo().time == this.getAdvancedRobot().getTime()) {
                this.aim(enemy);
                if (enemy.isFired) {
                    if (this.avoidBullet != null && this.avoidBullet.expectImpactTime < this.getAdvancedRobot().getTime() && !this.nextReverseFlg) {
                        this.reverse();
                    }
                    if (enemy.bulletStoreList.size() > 0) {
                        this.avoidBullet = bulletHitFlag || this.getAdvancedRobot().getEnergy() <= Utils.getBulletDamage(3) ? (BulletStore)enemy.bulletStoreList.lastElement() : (this.avoidBullet != this.getBrain().getNearestBullet() ? this.getBrain().getNearestBullet() : null);
                    }
                    if (this.bulletHitCount > 2 && this.sameEscCount++ > 1) {
                        System.out.println("Rev.");
                        this.reverse();
                    }
                    double d = 9.0;
                    if (enemy.bulletStoreList.size() > 0) {
                        BulletStore bs = (BulletStore)enemy.bulletStoreList.lastElement();
                        d = Utils.calcGunHeat(bs.power) / this.getAdvancedRobot().getGunCoolingRate() - (double)3;
                    }
                    if (this.nextReverseFlg) {
                        d *= (double)2;
                    }
                    if (this.bulletHitCount > 2 && this.normalBulletHitCount < 2) {
                        d = d / (double)2 + d / (double)2 * this.random.nextDouble();
                    }
                    if (this.angryFlg) {
                        d = this.bulletHitCount > 2 && this.random.nextDouble() < 0.1 ? this.random.nextDouble() * 40.0 : 20.0 + this.random.nextDouble() * 20.0;
                        this.loopCount = 0;
                        this.angryFlg = false;
                        this.angryFlg2 = true;
                        boolean bl = false;
                        if (this.bulletHitCount > 2 && this.random.nextBoolean()) {
                            bl = true;
                        }
                    }
                    if (this.maxAwayCount > 0 && this.awayCount > this.maxAwayCount) {
                        this.awayCount = 0;
                    } else {
                        this.away((long)d);
                        ++this.awayCount;
                    }
                } else if (enemy.getNewEnemyInfo().distance < 75.0) {
                    this.away(12L);
                    this.awayCount = 0;
                }
                double turnAngle = Utils.getRobotMaxTurning(this.getAdvancedRobot().getVelocity()) - this.random.nextDouble() * 10.0;
                if (this.reverseFlg) {
                    turnAngle = -turnAngle;
                }
                if (Utils.normalRelativeAngle(this.getAdvancedRobot().getGunHeading() - this.getAdvancedRobot().getHeading()) < 0.0) {
                    turnAngle = -turnAngle;
                }
                if (enemy.getNewEnemyInfo().distance < this.maxOwnArea) {
                    turnAngle = -turnAngle;
                }
                if (enemy.getNewEnemyInfo().distance != this.maxOwnArea) {
                    this.motor.setTurn(turnAngle);
                }
            } else {
                this.awayCount = 0;
                this.maxAwayCount = 0;
            }
        } else {
            this.aimCancel();
        }
        if (this.awayFlg) {
            this.loopAccelAndBrake();
        }
        if (enemy != null && this.motor.getSpeed() == 0.0) {
            if (this.random.nextDouble() < 0.005) {
                this.state = 1;
            } else if (this.random.nextDouble() < 0.005) {
                this.state = 2;
            }
        }
    }

    void changeDriver() {
        Enemy enemy = this.getBrain().getTarget();
        if (this.getAdvancedRobot().getOthers() == 1) {
            if (MeleeDriver.angryFlg) {
                this.motor.resetTargetPoint();
                this.motor.resetAheadPoint();
                this.setNextDriver(new MeleeDriver(this.getAdvancedRobot(), this.getMechas(), this.getBrain()));
            }
            if (enemy != null) {
                if (this.firstMyEnergy == 0.0) {
                    this.firstMyEnergy = this.getAdvancedRobot().getEnergy();
                }
                if (this.firstEnemyEnergy == 0.0) {
                    this.firstEnemyEnergy = enemy.getNewEnemyInfo().energy;
                }
                double myDamage = this.firstMyEnergy - this.getAdvancedRobot().getEnergy();
                double enemyDamage = this.firstEnemyEnergy - enemy.getNewEnemyInfo().energy;
                if (enemyDamage == 0.0) {
                    return;
                }
                double damageRate = myDamage / this.firstMyEnergy;
                double damageCompareRate = myDamage / enemyDamage;
                if (damageCompareRate > (double)2 && damageRate > 0.5 && transformed < 1) {
                    ++transformed;
                    this.motor.resetTargetPoint();
                    this.motor.resetAheadPoint();
                    this.setNextDriver(new ShadowDriver(this.getAdvancedRobot(), this.getMechas(), this.getBrain()));
                }
            }
        } else if (this.getAdvancedRobot().getOthers() > 1 && (enemy != this.prevEnemy && this.prevEnemy != null || this.angryFlg)) {
            this.motor.resetTargetPoint();
            this.motor.resetAheadPoint();
            this.setNextDriver(new MeleeDriver(this.getAdvancedRobot(), this.getMechas(), this.getBrain()));
        }
        this.prevEnemy = enemy;
    }

    void away(long time) {
        double maxSpeed = (double)time / 1.5;
        this.accThrd = (int)maxSpeed;
        this.awayFlg = true;
    }

    void awayFinish() {
        this.loopCount = 0;
        this.awayFlg = false;
        this.awayStopCancelFlg = false;
        if (this.angryFlg2) {
            this.random.nextBoolean();
            this.angryFlg2 = false;
        }
        double sp = this.motor.getSpeed();
        double deg = this.getAdvancedRobot().getHeading();
        if (this.reverseFlg) {
            deg = Utils.normalAbsoluteAngle(deg + 180.0);
        }
        if (Utils.chkOutOfBattleField(deg, 100.0, (Robot)this.getAdvancedRobot()) || this.chkHitBullet(deg, 100.0, (Robot)this.getAdvancedRobot())) {
            this.reverse();
            this.nextReverseFlg = true;
        } else {
            this.nextReverseFlg = false;
        }
    }

    void loopAccelAndBrake() {
        double deg = this.getAdvancedRobot().getHeading();
        double sp = this.motor.getSpeed();
        if (sp < 0.0) {
            deg = Utils.normalAbsoluteAngle(deg + 180.0);
        }
        if (sp != 0.0 && !this.awayStopCancelFlg) {
            boolean test;
            int dist = 100;
            if (this.state == 1) {
                dist = 150;
                test = this.chkHitBullet(deg, dist, (Robot)this.getAdvancedRobot());
            } else {
                test = this.chkHitBullet(deg, dist, (Robot)this.getAdvancedRobot());
            }
            if (Utils.chkOutOfBattleField(deg, 50.0, (Robot)this.getAdvancedRobot()) || test) {
                this.loopCount += this.accThrd;
            }
        }
        if (this.loopCount > this.accThrd) {
            this.heavyBrake();
        } else if (this.loopCount > 8 && this.random.nextDouble() < 0.1) {
            this.brake();
        } else {
            this.accel();
        }
        ++this.loopCount;
        if (0.0 == Math.abs(this.getAdvancedRobot().getVelocity()) && this.loopCount > this.accThrd) {
            this.awayFinish();
        }
    }

    void accelAndBrake() {
        double deg = this.getAdvancedRobot().getHeading();
        double sp = this.motor.getSpeed();
        if (sp < 0.0) {
            deg = Utils.normalAbsoluteAngle(deg + 180.0);
        }
        if (Utils.chkOutOfBattleField(deg, this.maxOwnArea, (Robot)this.getAdvancedRobot())) {
            this.brake();
        } else {
            this.accel();
        }
    }

    void brake() {
        double bsp = this.motor.getSpeed();
        double asp = Math.abs(bsp);
        if (asp > 0.0) {
            asp -= 1.0;
        }
        if (this.reverseFlg) {
            asp = -asp;
        }
        this.motor.setSpeed(asp);
    }

    void heavyBrake() {
        double sp = this.motor.getSpeed();
        if (sp != 0.0) {
            this.motor.setSpeed(0.0);
        }
    }

    void accel() {
        double bsp = this.motor.getSpeed();
        double asp = Math.abs(bsp);
        if (asp < 8.0) {
            asp += 1.0;
        }
        if (this.reverseFlg) {
            asp = -asp;
        }
        this.motor.setSpeed(asp);
    }

    void reverse() {
        double speed = this.motor.getSpeed();
        double deg = this.getAdvancedRobot().getHeading();
        if (!this.reverseFlg) {
            deg = Utils.normalAbsoluteAngle(deg + 180.0);
        }
        if (!Utils.chkOutOfBattleField(deg, 100.0, (Robot)this.getAdvancedRobot())) {
            this.motor.setSpeed(-speed);
            this.reverseFlg ^= true;
            this.awayCount = 0;
            this.sameEscCount = 0;
        }
    }

    boolean chkHitBullet(double heading, double distance, Robot robot) {
        boolean ret = false;
        double robotx = robot.getX();
        double roboty = robot.getY();
        double robotvel = 8.0;
        double robotR = Utils.getRobotR();
        double hheading = heading;
        double deltaHeading = this.getBrain().getDeltaHeading();
        Enemy enemy = this.getBrain().getTarget();
        if (enemy == null) {
            return ret;
        }
        if (enemy.isAlive && enemy.getNewEnemyInfo().time == this.getAdvancedRobot().getTime()) {
            Enumeration en2 = enemy.bulletStoreList.elements();
            while (en2.hasMoreElements()) {
                BulletStore bs = (BulletStore)en2.nextElement();
                if (bs.distance < distance) {
                    double prevDistance = bs.distance;
                    double x = robotx + robotvel * Math.sin(Math.toRadians(hheading));
                    double y = roboty + robotvel * Math.cos(Math.toRadians(hheading));
                    double bx = bs.x + bs.velocity * Math.sin(Math.toRadians(bs.heading));
                    double by = bs.y + bs.velocity * Math.cos(Math.toRadians(bs.heading));
                    double nextDistance = Utils.calcDistance(x, y, bx, by);
                    while (nextDistance < prevDistance) {
                        prevDistance = nextDistance;
                        if (!((nextDistance = Utils.calcDistance(x += robotvel * Math.sin(Math.toRadians(hheading += deltaHeading)), y += robotvel * Math.cos(Math.toRadians(hheading)), bx += bs.velocity * Math.sin(Math.toRadians(bs.heading)), by += bs.velocity * Math.cos(Math.toRadians(bs.heading)))) < robotR)) continue;
                        ret = true;
                        break;
                    }
                }
                if (ret) break;
            }
        }
        return ret;
    }

    boolean chkHitBullet2(double heading, double distance, Robot robot) {
        boolean ret = false;
        double robotx = robot.getX();
        double roboty = robot.getY();
        double robotR = Utils.getRobotR();
        long time = robot.getTime();
        Enemy enemy = this.getBrain().getTarget();
        if (enemy == null) {
            return ret;
        }
        if (enemy.isAlive && enemy.getNewEnemyInfo().time == time) {
            Enumeration en2 = enemy.bulletStoreList.elements();
            while (en2.hasMoreElements()) {
                BulletStore bs = (BulletStore)en2.nextElement();
                double bdDistance = bs.velocity * (double)(time - bs.inittime);
                double mdDistance = Utils.calcDistance(bs.initx, bs.inity, robotx, roboty);
                if (!(bs.distance < distance) || !(bdDistance < mdDistance)) continue;
                double vDistance = bs.distance * Math.sin(Math.toRadians(Utils.calcRelativeBearing(bs.heading, bs.x, bs.y, robotx, roboty)));
                double vDeg = bs.heading + -1.0 * (vDistance / Math.abs(vDistance)) * 90.0;
                if (!(Math.abs(vDistance) < (double)2 * robotR) || !(Math.abs(Utils.normalRelativeAngle(vDeg - heading)) > 90.0)) continue;
                System.out.println("Bullet alert.:" + enemy.name);
                ret = true;
                break;
            }
        }
        return ret;
    }

    void aim(Enemy enemy) {
        double x = enemy.getNewEnemyInfo().x;
        double y = enemy.getNewEnemyInfo().y;
        double bulletPower = Math.min((double)3, Utils.getBulletPowerToKill(enemy.getNewEnemyInfo().energy));
        double myEnergy = this.getAdvancedRobot().getEnergy();
        if (myEnergy < bulletPower) {
            bulletPower = 0.1;
        }
        Coordinate impactPoint = null;
        impactPoint = this.getBrain().getLogTraceEnemyImpactPoint(enemy, enemy, this.getBrain().myStoreList, bulletPower);
        if (impactPoint == null && Brain.enemyListBak != null) {
            Enemy prevRoundEnemy = (Enemy)Brain.enemyListBak.get(enemy.name);
            impactPoint = this.getBrain().getLogTraceEnemyImpactPoint(prevRoundEnemy, enemy, Brain.myStoreListBak, bulletPower);
            boolean bl = false;
            if (impactPoint != null) {
                bl = true;
            }
        }
        if (impactPoint == null) {
            impactPoint = this.getBrain().getCircuitEnemyImpactPoint(enemy, bulletPower);
            if (this.random.nextDouble() < 0.5) {
                double mx = this.getAdvancedRobot().getX();
                double my = this.getAdvancedRobot().getY();
                double delta = enemy.deltaShoot / Utils.getBulletVelocity(bulletPower) * Utils.calcDistance(mx, my, x, y);
                if (Utils.normalRelativeAngle(Utils.calcAbsoluteBearing(mx, my, x, y) - Utils.calcAbsoluteBearing(mx, my, impactPoint.x, impactPoint.y)) < 0.0) {
                    delta = -delta;
                }
                this.gun.setDelta(delta);
            } else {
                this.gun.setDelta(0.0);
            }
        } else {
            this.gun.setDelta(0.0);
        }
        if (enemy.getNewEnemyInfo().energy != 0.0 && myEnergy < 1.0) {
            impactPoint = null;
        }
        this.gun.setBulletPower(bulletPower);
        this.radar.setTargetPoint(x, y);
        if (this.state == 0) {
            this.motor.setTargetPoint(x, y);
        }
        if (impactPoint != null && impactPoint.x > 0.0 && impactPoint.x < this.getAdvancedRobot().getBattleFieldWidth() && impactPoint.y > 0.0 && impactPoint.y < this.getAdvancedRobot().getBattleFieldHeight()) {
            this.gun.setTargetPoint(impactPoint.x, impactPoint.y);
        }
    }

    void aimCancel() {
        this.radar.resetTargetPoint();
        this.motor.resetTargetPoint();
        this.gun.resetTargetPoint();
    }

    public double getMaxOwnArea() {
        return this.maxOwnArea;
    }

    public void onBulletHit(BulletHitEvent e) {
        super.onBulletHit(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        super.onBulletHitBullet(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        super.onBulletMissed(e);
    }

    public void onDeath(DeathEvent e) {
        super.onDeath(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        super.onHitByBullet(e);
        int count = 0;
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            if (e.getName().equals(enemy.name)) {
                this.angryFlg = true;
                if (!this.nextReverseFlg) {
                    bulletHitFlag = true;
                }
            }
            Enumeration en = enemy.bulletStoreList.elements();
            while (en.hasMoreElements()) {
                BulletStore bs = (BulletStore)en.nextElement();
                if (!(Math.abs(bs.x - this.getAdvancedRobot().getX()) < Utils.getRobotR() * (double)2) || !(Math.abs(bs.y - this.getAdvancedRobot().getY()) < Utils.getRobotR() * (double)2)) continue;
                System.out.println("Ouch!");
                ++this.normalBulletHitCount;
                ++count;
                if (this.normalBulletHitCount <= 1) continue;
                this.awayStopCancelFlg = true;
            }
            if (count == 0) {
                System.out.println("URYYYYY!");
                ++this.bulletHitCount;
            }
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        super.onHitRobot(e);
        this.heavyBrake();
        this.awayFinish();
        if (this.getAdvancedRobot().getOthers() == 1) {
            MeleeDriver.angryFlg = true;
        }
    }

    public void onHitWall(HitWallEvent e) {
        super.onHitWall(e);
        this.reverse();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        super.onRobotDeath(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        super.onScannedRobot(e);
    }

    public void onWin(WinEvent e) {
        super.onWin(e);
    }

    private final /* synthetic */ void this() {
        this.loopCount = 0;
        this.awayCount = 0;
        this.maxAwayCount = 0;
        this.state = 1;
        this.accThrd = 8;
        this.awayFlg = false;
        this.reverseFlg = false;
        this.angryFlg = false;
        this.angryFlg2 = false;
        this.nextReverseFlg = false;
        this.awayStopCancelFlg = false;
        this.escapeFinishFlg = false;
        this.avoidBullet = null;
        this.random = new Random();
        this.firstMyEnergy = 0.0;
        this.firstEnemyEnergy = 0.0;
        this.prevEnemy = null;
        this.normalBulletHitCount = 0;
        this.bulletHitCount = 0;
        this.sameEscCount = 0;
        this.rotateMoveCount = 0;
        this.rotateBulletHitCount = 0;
    }

    public AssaultDriver() {
        this.this();
        this.init();
    }

    public AssaultDriver(AdvancedRobot r) {
        super(r);
        this.this();
        this.init();
    }

    public AssaultDriver(AdvancedRobot r, Mech[] m) {
        super(r, m);
        this.this();
        this.init();
    }

    public AssaultDriver(AdvancedRobot r, Mech[] m, Brain b) {
        super(r, m, b);
        this.this();
        this.init();
    }
}

