/*
 * Decompiled with CFR 0.152.
 */
package syl.fire;

import java.util.Hashtable;
import robocode.Bullet;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.core.RobotListenerAdapter;
import syl.fire.HitRatioManager;
import syl.fire.VirtualBullet;
import syl.util.Angle;
import syl.util.Coordinate;
import syl.util.RobotMath;

public abstract class FireStrategy
extends RobotListenerAdapter {
    private Hashtable hitRatioManagers = new Hashtable();
    private BaseRobot robot;

    public FireStrategy(BaseRobot robot) {
        this.robot = robot;
    }

    public abstract boolean isEvasiveFireStrategy();

    public void initialize() {
        this.robot.addRobotListener(this);
    }

    public void cleanUp() {
        this.robot.removeRobotListener(this);
    }

    public abstract Coordinate getFuturePosition(Enemy var1, double var2);

    public void bulletMissed(VirtualBullet trackingBullet) {
    }

    public void bulletHit(VirtualBullet trackingBullet) {
    }

    public Bullet fireBullet(Enemy enemy) {
        if (enemy == null) {
            return null;
        }
        double firePower = this.calculateFirePower(enemy);
        Coordinate targetCoordinate = this.getFuturePosition(enemy, firePower);
        if (targetCoordinate == null) {
            return null;
        }
        double gunOffset = this.turnGun(targetCoordinate);
        if (firePower > 0.0 && this.getRobot().getGunHeat() == 0.0 && Math.abs(this.getRobot().getGunTurnRemaining()) < 3.0) {
            return this.getRobot().setFireBullet(firePower);
        }
        return null;
    }

    public VirtualBullet fireVirtualBullet(Enemy enemy) {
        if (this.robot.getTime() % 2L != 0L) {
            return null;
        }
        if (enemy == null) {
            return null;
        }
        double firePower = this.calculateFirePower(enemy);
        Coordinate targetCoordinate = this.getFuturePosition(enemy, firePower);
        if (targetCoordinate == null) {
            return null;
        }
        VirtualBullet virtualBullet = new VirtualBullet(this, this.getRobot().getCoordinate(), targetCoordinate, this.getRobot().getTime(), enemy, firePower);
        this.getHitRatioManager(enemy).addTrackingBullet(virtualBullet);
        return virtualBullet;
    }

    public double calculateFirePower(Enemy enemy) {
        double firePower = Math.min(3.0, this.robot.getEnergy() - 0.1);
        double enemyEnergy = enemy.getEnergy();
        if (enemyEnergy <= 0.0) {
            firePower = Math.min(0.1, firePower);
        }
        double killingPower = RobotMath.getBulletPower(enemyEnergy) + 0.1;
        firePower = Math.min(killingPower, firePower);
        if (this.robot.getEnergy() <= 20.0) {
            firePower = Math.min(3.0 * (20.0 / this.robot.getEnergy()), firePower);
        }
        return firePower;
    }

    private double turnGun(Coordinate targetCoordinate) {
        double enemyAngle = this.getRobot().getCoordinate().getAngle(targetCoordinate);
        double gunOffset = Angle.toRelativeAngle(this.getRobot().getGunHeading() - enemyAngle);
        this.getRobot().setTurnGunLeft(gunOffset);
        return gunOffset;
    }

    public HitRatioManager getHitRatioManager(Enemy enemy) {
        HitRatioManager hitRatioManager = (HitRatioManager)this.hitRatioManagers.get(enemy.getName());
        if (hitRatioManager == null) {
            hitRatioManager = new HitRatioManager();
            this.hitRatioManagers.put(enemy.getName(), hitRatioManager);
        }
        return hitRatioManager;
    }

    public double getHitRatio(Enemy enemy) {
        if (enemy != null) {
            HitRatioManager hitRatioManager = this.getHitRatioManager(enemy);
            hitRatioManager.updateHitRatio(this.robot.getTime());
            return hitRatioManager.getCurrentHitRatio();
        }
        return 0.0;
    }

    public BaseRobot getRobot() {
        return this.robot;
    }

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

