/*
 * Decompiled with CFR 0.152.
 */
package syl.movement;

import java.util.ArrayList;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.core.EnemyFireEvent;
import syl.core.FireScannerListener;
import syl.movement.GravityMovementStrategy;
import syl.movement.MovementStrategy;
import syl.util.Coordinate;

public class EvasiveGravityMovementStrategy
extends GravityMovementStrategy
implements FireScannerListener {
    private ArrayList evasiveMovementBullets = new ArrayList();
    private static final double MOVE_DISTANCE = 35.0;

    public void initialize() {
        super.initialize();
        this.getRobot().getFireScanner().addFireScannerListener(this);
    }

    public void cleanUp() {
        super.cleanUp();
        this.getRobot().getFireScanner().removeFireScannerListener(this);
    }

    public EvasiveGravityMovementStrategy(BaseRobot robot) {
        super(robot);
    }

    public void doMovement(Enemy enemy) {
        this.updateGravityPoints();
        Coordinate targetCoordinate = this.getTargetCoordinate();
        Coordinate currentCoordinate = this.getRobot().getCoordinate();
        double angle = currentCoordinate.getAngle(targetCoordinate);
        double direction = MovementStrategy.turnTo(this.getRobot(), angle);
        int i = this.evasiveMovementBullets.size() - 1;
        while (i > -1) {
            if (((EvasiveMovementBullet)this.evasiveMovementBullets.get(i)).isDanger(this.getRobot().getTime(), this.getRobot().getCoordinate())) {
                this.getRobot().setAhead(35.0 * direction);
                this.evasiveMovementBullets.remove(i);
            }
            --i;
        }
    }

    public void onEnemyFire(EnemyFireEvent event) {
        if (this.getRobot().getVelocity() == 0.0) {
            double speed = 20.0 - 3.0 * event.getPower();
            double distance = event.getEnemy().getCoordinate().getDistance(this.getRobot().getCoordinate());
            long arrivalTime = (long)((double)this.getRobot().getTime() + Math.floor(distance / speed));
            Coordinate targetCoordinate = this.getRobot().getCoordinate().getClone();
            this.evasiveMovementBullets.add(new EvasiveMovementBullet(targetCoordinate, arrivalTime));
        }
    }

    class EvasiveMovementBullet {
        private long arrivalTime;
        private Coordinate targetCoordinate;
        private static final long REACTION_TIME = 15L;
        private static final double SAVE_DISTANCE = 25.0;

        public EvasiveMovementBullet(Coordinate targetCoordinate, long arrivalTime) {
            this.arrivalTime = arrivalTime;
            this.targetCoordinate = targetCoordinate;
        }

        public boolean isDanger(long time, Coordinate robotCoordinate) {
            if (this.targetCoordinate.getDistance(robotCoordinate) > 25.0) {
                return false;
            }
            return this.arrivalTime - time < 15L;
        }
    }
}

