/*
 * Decompiled with CFR 0.152.
 */
package taqho;

import java.awt.geom.Point2D;
import java.text.NumberFormat;
import taqho.Logger;

public class MathUtils {
    private static NumberFormat dp2 = NumberFormat.getInstance();
    private static final double PI = Math.PI;
    private static final double TWOPI = Math.PI * 2;
    private static final double HALFPI = 1.5707963267948966;

    public static void Initialise() {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
        Logger.log("MU: MathUtility Initialised.");
    }

    public static double sin(double angle) {
        return Math.sin(Math.toRadians(angle));
    }

    public static double asin(double quotient) {
        return Math.toDegrees(Math.asin(quotient));
    }

    public static double cos(double angle) {
        return Math.cos(Math.toRadians(angle));
    }

    public static double acos(double quotient) {
        return Math.toDegrees(Math.acos(quotient));
    }

    public static double tan(double angle) {
        return Math.tan(Math.toRadians(angle));
    }

    public static double atan(double quotient) {
        return Math.toDegrees(Math.atan(quotient));
    }

    public static double atan2(double ydelta, double xdelta) {
        return Math.toDegrees(Math.atan2(ydelta, xdelta));
    }

    public static double normaliseBearingDegrees(double bearing) {
        while (bearing > 180.0) {
            bearing -= 360.0;
        }
        while (bearing < -180.0) {
            bearing += 360.0;
        }
        return bearing;
    }

    public static double normaliseBearing(double bearing) {
        while (bearing > Math.PI) {
            bearing -= Math.PI * 2;
        }
        while (bearing < -Math.PI) {
            bearing += Math.PI * 2;
        }
        return bearing;
    }

    public static double reduceTo0to360(double heading) {
        while (heading < 0.0) {
            heading += 360.0;
        }
        while (heading > 360.0) {
            heading -= 360.0;
        }
        return heading;
    }

    public static double bearingBetweenPoints(double x1, double y1, double x2, double y2) {
        double xDiff = x2 - x1;
        double yDiff = y2 - y1;
        double d = Point2D.distance(x1, y1, x2, y2);
        if (xDiff > 0.0) {
            if (yDiff > 0.0) {
                return Math.asin(xDiff / d);
            }
            if (yDiff < 0.0) {
                return Math.PI - Math.asin(xDiff / d);
            }
            return 1.5707963267948966;
        }
        if (xDiff < 0.0) {
            if (yDiff < 0.0) {
                return Math.PI + Math.asin(-xDiff / d);
            }
            if (yDiff > 0.0) {
                return Math.PI * 2 - Math.asin(-xDiff / d);
            }
            return 4.71238898038469;
        }
        if (yDiff >= 0.0) {
            return 0.0;
        }
        return Math.PI;
    }

    public static double bearingBetweenPointsDegrees(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(MathUtils.bearingBetweenPoints(x1, y1, x2, y2));
    }

    public static double sign(double x) {
        return x > 0.0 ? 1 : -1;
    }
}

