/*
 * Decompiled with CFR 0.152.
 */
package kid.cluster;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import kid.cluster.Cluster;
import kid.cluster.Comparison;
import kid.cluster.Dimension;
import kid.cluster.Vector;
import kid.data.Data;
import kid.data.Printable;
import kid.segmentation.Segmentable;
import robocode.RobocodeFileOutputStream;

public class Space<E extends Data, F extends Segmentable, G extends Segmentable>
implements Printable {
    private ArrayList<Dimension<E, F, G>> dimensions;

    public Space(Comparison[] comparisons) {
        this.dimensions = new ArrayList(comparisons.length);
        int i = 0;
        while (i < comparisons.length) {
            this.dimensions.add(new Dimension(comparisons[i]));
            ++i;
        }
    }

    public void add(E data, F view, G reference) {
        Vector<E, F, G> v = new Vector<E, F, G>(data, view, reference);
        for (Dimension<E, F, G> d : this.dimensions) {
            d.add(v);
        }
    }

    public Collection<E> getCluster(F view, G reference, int size) {
        Cluster<E> cluster = new Cluster<E>(this.dimensions, view, reference, size);
        return cluster.getCluster();
    }

    @Override
    public void print(PrintStream console) {
        for (Dimension<E, F, G> d : this.dimensions) {
            d.print(console);
        }
        console.println();
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
        PrintStream out = new PrintStream((OutputStream)output);
        for (Dimension<E, F, G> d : this.dimensions) {
            d.print(output);
        }
        out.println();
    }
}

