/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.move.formula;

import ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;
import ags.utils.dataStructures.trees.thirdGenKD.WeightedManhattanDistanceFunction;
import catcat20.core.move.SurfWave;
import catcat20.core.move.formula.SurfFormula;
import catcat20.core.utils.LUtils;
import catcat20.core.utils.knn.KNNData;
import java.awt.Color;
import java.util.ArrayList;

public class SurfKNNModel<T> {
    public KdTree<T> tree;
    public SurfFormula formula;
    public int maxK = 32;
    public double kDivisor = 2.0;
    public Color color = new Color(1.0f, 0.0f, 1.0f, 0.33f);
    public double treeWeight = 1.0;
    public double[] weights;
    public DistanceFunction distanceFunction;

    public SurfKNNModel(SurfFormula formula) {
        this(new WeightedManhattanDistanceFunction(formula.weights), formula);
    }

    public SurfKNNModel(DistanceFunction distanceFunction, SurfFormula formula) {
        this.distanceFunction = distanceFunction;
        this.weights = formula.weights;
        this.formula = formula;
        this.tree = new KdTree(this.weights.length);
    }

    public SurfKNNModel<T> setMaxK(int maxK) {
        this.maxK = maxK;
        return this;
    }

    public SurfKNNModel<T> setTreeWeight(double treeWeight) {
        this.treeWeight = treeWeight;
        return this;
    }

    public SurfKNNModel<T> setKDivisor(double kDivisor) {
        this.kDivisor = kDivisor;
        return this;
    }

    public SurfKNNModel<T> setColor(Color color) {
        this.color = color;
        return this;
    }

    public void addPoint(SurfWave w, SurfWave.WaveData waveData, T data) {
        this.tree.addPoint(this.formula.dataPoint(w, waveData), (Object)data);
    }

    public ArrayList<KNNData<T>> getNearestNeighborsList(SurfWave w, SurfWave.WaveData waveData) {
        return this.getNearestNeighborsList(w, waveData, LUtils.limit(1, (int)Math.sqrt(this.tree.size()), this.maxK));
    }

    public ArrayList<KNNData<T>> getNearestNeighborsList(SurfWave w, SurfWave.WaveData waveData, double divisor) {
        return this.getNearestNeighborsList(w, waveData, LUtils.limit(1, (int)((double)this.tree.size() / divisor), this.maxK));
    }

    public ArrayList<KNNData<T>> getNearestNeighborsList(SurfWave w, SurfWave.WaveData waveData, int k) {
        NearestNeighborIterator<T> neighbors = this.tree.getNearestNeighborIterator(this.formula.dataPoint(w, waveData), k, this.distanceFunction);
        ArrayList<KNNData<T>> list = new ArrayList<KNNData<T>>();
        int dataCount = 0;
        for (T data : neighbors) {
            KNNData dataset = new KNNData();
            dataset.order = ++dataCount;
            dataset.distance = neighbors.distance();
            dataset.data = data;
            dataset.treeWeight = this.treeWeight;
            dataset.color = this.color;
            list.add(dataset);
        }
        return list;
    }
}

